/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.protocol.response.format;

import org.opensearch.sql.protocol.response.QueryResult;
import org.opensearch.sql.protocol.response.format.ErrorFormatter;
import org.opensearch.sql.protocol.response.format.FlatResponseBase;
import org.opensearch.sql.protocol.response.format.FlatResponseWithPrettifier;
import org.opensearch.sql.protocol.response.format.ResponseFormatter;

public class RawResponseFormatter
implements ResponseFormatter<QueryResult> {
    public static final String CONTENT_TYPE = "plain/text; charset=UTF-8";
    private final String separator;
    private final boolean pretty;

    public RawResponseFormatter() {
        this("|", false);
    }

    public RawResponseFormatter(boolean pretty) {
        this("|", pretty);
    }

    public RawResponseFormatter(String separator, boolean pretty) {
        this.separator = separator;
        this.pretty = pretty;
    }

    @Override
    public String format(QueryResult response) {
        FlatResponseBase flatResponse = this.pretty ? new FlatResponseWithPrettifier(response, this.separator) : new FlatResponseBase(response, this.separator);
        return flatResponse.format();
    }

    @Override
    public String format(Throwable t2) {
        return ErrorFormatter.prettyFormat(t2);
    }

    @Override
    public String contentType() {
        return CONTENT_TYPE;
    }
}

