/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.parameter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.datasource.model.DataSourceType;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryRequestContext;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryRequest;
import org.opensearch.sql.spark.parameter.DataSourceSparkParameterComposer;
import org.opensearch.sql.spark.parameter.GeneralSparkParameterComposer;
import org.opensearch.sql.spark.parameter.SparkSubmitParameters;
import shaded.com.google.common.collect.ImmutableList;

public class SparkParameterComposerCollection {
    private final Collection<GeneralSparkParameterComposer> generalComposers = new ArrayList<GeneralSparkParameterComposer>();
    private final Map<DataSourceType, Collection<DataSourceSparkParameterComposer>> datasourceComposers = new HashMap<DataSourceType, Collection<DataSourceSparkParameterComposer>>();

    public void register(DataSourceType dataSourceType, DataSourceSparkParameterComposer composer) {
        if (!this.datasourceComposers.containsKey(dataSourceType)) {
            this.datasourceComposers.put(dataSourceType, new LinkedList());
        }
        this.datasourceComposers.get(dataSourceType).add(composer);
    }

    public void register(GeneralSparkParameterComposer composer) {
        this.generalComposers.add(composer);
    }

    public void composeByDataSource(DataSourceMetadata dataSourceMetadata, SparkSubmitParameters sparkSubmitParameters, DispatchQueryRequest dispatchQueryRequest, AsyncQueryRequestContext context) {
        for (DataSourceSparkParameterComposer composer : this.getComposersFor(dataSourceMetadata.getConnector())) {
            composer.compose(dataSourceMetadata, sparkSubmitParameters, dispatchQueryRequest, context);
        }
    }

    public void compose(SparkSubmitParameters sparkSubmitParameters, DispatchQueryRequest dispatchQueryRequest, AsyncQueryRequestContext context) {
        for (GeneralSparkParameterComposer composer : this.generalComposers) {
            composer.compose(sparkSubmitParameters, dispatchQueryRequest, context);
        }
    }

    private Collection<DataSourceSparkParameterComposer> getComposersFor(DataSourceType type2) {
        return this.datasourceComposers.getOrDefault(type2, ImmutableList.of());
    }

    public boolean isComposerRegistered(DataSourceType type2) {
        return this.datasourceComposers.containsKey(type2);
    }
}

