/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.utils;

import inet.ipaddr.AddressStringException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv6.IPv6Address;
import lombok.Generated;
import org.opensearch.sql.exception.SemanticCheckException;

public final class IPUtils {
    private static final IPAddressStringParameters.Builder commonValidationOptions = new IPAddressStringParameters.Builder().allowEmpty(false).allowMask(false).setEmptyAsLoopback(false).allowPrefixOnly(false).allow_inet_aton(false).allowSingleSegment(false);
    private static final IPAddressStringParameters ipAddressStringParameters = commonValidationOptions.allowPrefix(false).toParams();
    private static final IPAddressStringParameters ipAddressRangeStringParameters = commonValidationOptions.allowPrefix(true).toParams();

    public static IPAddress toRange(String s2) throws SemanticCheckException {
        try {
            IPAddress range = new IPAddressString(s2, ipAddressRangeStringParameters).toAddress();
            if (range.isIPv4Convertible()) {
                int prefixLength = range.getPrefixLength();
                range = range.toIPv4().setPrefixLength(prefixLength, false);
            }
            return range;
        }
        catch (AddressStringException e) {
            String errorFormat = "IP address range string '%s' is not valid. Error details: %s";
            throw new SemanticCheckException(String.format("IP address range string '%s' is not valid. Error details: %s", s2, e.getMessage()), e);
        }
    }

    public static IPAddress toAddress(String s2) throws SemanticCheckException {
        try {
            IPAddress address = new IPAddressString(s2, ipAddressStringParameters).toAddress();
            if (address.isIPv4Convertible()) {
                address = address.toIPv4();
            }
            return address;
        }
        catch (AddressStringException e) {
            String errorFormat = "IP address string '%s' is not valid. Error details: %s";
            throw new SemanticCheckException(String.format("IP address string '%s' is not valid. Error details: %s", s2, e.getMessage()), e);
        }
    }

    public static int compare(IPAddress a, IPAddress b) {
        IPv6Address ipv6A = IPUtils.toIPv6Address(a);
        IPv6Address ipv6B = IPUtils.toIPv6Address(b);
        return ipv6A.compareTo(ipv6B);
    }

    private static IPv6Address toIPv6Address(IPAddress ipAddress) {
        IPv6Address iPv6Address;
        if (ipAddress instanceof IPv4Address) {
            IPv4Address iPv4Address = (IPv4Address)ipAddress;
            iPv6Address = iPv4Address.toIPv6();
        } else {
            iPv6Address = (IPv6Address)ipAddress;
        }
        return iPv6Address;
    }

    @Generated
    private IPUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

