/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.latex.glossaries.AbstractGlsCommand;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossariesSty;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossaryEntry;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsLabel;
import java.io.IOException;

public class GlsSetField
extends AbstractGlsCommand {
    protected boolean expand = false;
    protected boolean global = false;
    protected boolean checkExists = true;

    public GlsSetField(String string, GlossariesSty glossariesSty) {
        this(string, false, false, glossariesSty);
    }

    public GlsSetField(String string, boolean bl, boolean bl2, GlossariesSty glossariesSty) {
        this(string, bl, bl2, true, glossariesSty);
    }

    public GlsSetField(String string, boolean bl, boolean bl2, boolean bl3, GlossariesSty glossariesSty) {
        super(string, glossariesSty);
        this.expand = bl;
        this.global = bl2;
        this.checkExists = bl3;
    }

    @Override
    public Object clone() {
        return new GlsSetField(this.getName(), this.expand, this.global, this.checkExists, this.getSty());
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        GlsLabel glsLabel = this.popEntryLabel(teXParser, teXObjectList);
        String string = this.sty.getFieldName(this.popLabelString(teXParser, teXObjectList));
        TeXObject teXObject = this.popArg(teXParser, teXObjectList);
        GlossaryEntry glossaryEntry = glsLabel.getEntry();
        if (glossaryEntry == null) {
            if (this.checkExists) {
                this.sty.undefWarnOrError(teXObjectList, "glossaries.entry.not.defined", glsLabel.getLabel());
            } else {
                String string2 = this.sty.getInternalFieldName(string);
                String string3 = String.format("glo@%s@%s", glsLabel.getLabel(), string2);
                this.sty.getParser().putControlSequence(!this.global, new GenericCommand(true, string3, null, teXObject));
            }
        } else {
            if (this.expand) {
                teXObject = TeXParserUtils.expandFully(teXObject, teXParser, teXObjectList);
            }
            glossaryEntry.setField(string, teXObject, !this.global, teXObjectList);
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

