/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.flow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.flow.MaximumFlowAlgorithmBase;
import org.jgrapht.alg.interfaces.MaximumFlowAlgorithm;
import org.jgrapht.alg.util.Extension;

public final class EdmondsKarpMaximumFlow<V, E>
extends MaximumFlowAlgorithmBase<V, E> {
    private DirectedGraph<V, E> network;
    private double epsilon;
    private VertexExtension currentSource;
    private VertexExtension currentSink;
    private final Extension.ExtensionFactory<VertexExtension> vertexExtensionsFactory = new Extension.ExtensionFactory<VertexExtension>(){

        @Override
        public VertexExtension create() {
            return new VertexExtension();
        }
    };
    private final Extension.ExtensionFactory<EdgeExtension> edgeExtensionsFactory = new Extension.ExtensionFactory<EdgeExtension>(){

        @Override
        public EdgeExtension create() {
            return new EdgeExtension();
        }
    };

    public EdmondsKarpMaximumFlow(DirectedGraph<V, E> network) {
        this(network, 1.0E-9);
    }

    public EdmondsKarpMaximumFlow(DirectedGraph<V, E> network, double epsilon) {
        if (network == null) {
            throw new NullPointerException("network is null");
        }
        if (epsilon <= 0.0) {
            throw new IllegalArgumentException("invalid epsilon (must be positive)");
        }
        for (Object e : network.edgeSet()) {
            if (!(network.getEdgeWeight(e) < -epsilon)) continue;
            throw new IllegalArgumentException("invalid capacity (must be non-negative)");
        }
        this.network = network;
        this.epsilon = epsilon;
    }

    @Override
    public MaximumFlowAlgorithm.MaximumFlow<V, E> buildMaximumFlow(V source, V sink) {
        double maxFlowValue;
        Map maxFlow;
        super.init(this.vertexExtensionsFactory, this.edgeExtensionsFactory);
        if (!this.network.containsVertex(source)) {
            throw new IllegalArgumentException("invalid source (null or not from this network)");
        }
        if (!this.network.containsVertex(sink)) {
            throw new IllegalArgumentException("invalid sink (null or not from this network)");
        }
        if (source.equals(sink)) {
            throw new IllegalArgumentException("source is equal to sink");
        }
        this.currentSource = this.extendedVertex(source);
        this.currentSink = this.extendedVertex(sink);
        while (true) {
            this.breadthFirstSearch();
            if (!this.currentSink.visited) {
                maxFlow = this.composeFlow();
                maxFlowValue = 0.0;
                for (E e : this.network.incomingEdgesOf(this.currentSink.prototype)) {
                    maxFlowValue += maxFlow.get(e).doubleValue();
                }
                break;
            }
            this.augmentFlow();
        }
        return new MaximumFlowAlgorithm.MaximumFlowImpl(maxFlowValue, maxFlow);
    }

    protected VertexExtension extendedVertex(V v) {
        return (VertexExtension)this.vertexExtended(v);
    }

    protected EdgeExtension extendedEdge(E e) {
        return (EdgeExtension)this.edgeExtended(e);
    }

    private void breadthFirstSearch() {
        for (Object v : this.network.vertexSet()) {
            this.extendedVertex(v).visited = false;
            this.extendedVertex(v).lastArcs = null;
        }
        LinkedList<VertexExtension> queue = new LinkedList<VertexExtension>();
        queue.offer(this.currentSource);
        this.currentSource.visited = true;
        this.currentSource.excess = Double.POSITIVE_INFINITY;
        this.currentSink.excess = 0.0;
        boolean seenSink = false;
        while (queue.size() != 0) {
            VertexExtension ux = (VertexExtension)queue.poll();
            for (EdgeExtension ex : ux.getOutgoing()) {
                if (!(ex.flow + this.epsilon < ex.capacity)) continue;
                VertexExtension vx = (VertexExtension)ex.getTarget();
                if (vx == this.currentSink) {
                    vx.visited = true;
                    if (vx.lastArcs == null) {
                        vx.lastArcs = new ArrayList<EdgeExtension>();
                    }
                    vx.lastArcs.add(ex);
                    vx.excess += Math.min(ux.excess, ex.capacity - ex.flow);
                    seenSink = true;
                    continue;
                }
                if (vx.visited) continue;
                vx.visited = true;
                vx.excess = Math.min(ux.excess, ex.capacity - ex.flow);
                vx.lastArcs = Collections.singletonList(ex);
                if (seenSink) continue;
                queue.add(vx);
            }
        }
    }

    private void augmentFlow() {
        HashSet<VertexExtension> seen = new HashSet<VertexExtension>();
        for (EdgeExtension ex : this.currentSink.lastArcs) {
            double deltaFlow = Math.min(((MaximumFlowAlgorithmBase.VertexExtensionBase)ex.getSource()).excess, ex.capacity - ex.flow);
            if (!this.augmentFlowAlongInternal(deltaFlow, (VertexExtension)ex.getSource(), seen)) continue;
            this.pushFlowThrough(ex, deltaFlow);
        }
    }

    private boolean augmentFlowAlongInternal(double deltaFlow, VertexExtension node, Set<VertexExtension> seen) {
        if (node == this.currentSource) {
            return true;
        }
        if (seen.contains(node)) {
            return false;
        }
        seen.add(node);
        EdgeExtension prev = node.lastArcs.get(0);
        if (this.augmentFlowAlongInternal(deltaFlow, (VertexExtension)prev.getSource(), seen)) {
            this.pushFlowThrough(prev, deltaFlow);
            return true;
        }
        return false;
    }

    public V getCurrentSource() {
        return (V)(this.currentSource == null ? null : this.currentSource.prototype);
    }

    public V getCurrentSink() {
        return (V)(this.currentSink == null ? null : this.currentSink.prototype);
    }

    @Override
    DirectedGraph<V, E> getNetwork() {
        return this.network;
    }

    class VertexExtension
    extends MaximumFlowAlgorithmBase.VertexExtensionBase {
        boolean visited;
        List<EdgeExtension> lastArcs;

        VertexExtension() {
        }
    }

    class EdgeExtension
    extends MaximumFlowAlgorithmBase.EdgeExtensionBase {
        EdgeExtension() {
        }
    }
}

