use Test::Instruction qw/all/;
use Terse;

instruction(
	test => 'obj',
	instance => Terse->new(),
	expected => 'Terse'
);

my $terse = Terse->new( a => 1, b => 2, c => sub { return 100 } );

instruction(
	test => 'obj',
	instance => $terse,
	expected => 'Terse'
);

instruction(
	test => 'scalar',
	instance => $terse,
	meth => 'c',
	expected => 100
);


instruction(
	test => 'hash',
	instance => $terse,
	expected => {
		a => 1,
		b => 2,
		c => $terse->{c}
	}
);

my $private = Terse->new( private => 1, a => 1, b => 2 );

instruction(
	test => 'obj',
	instance => $private,
	expected => 'Terse'
);

instruction(
	test => 'hash',
	instance => $private,
	expected => {
		'_a' => 1,
		'_b' => 2
	}
);

finish(6);
