/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtils {
    public static <E> Collection<List<E>> selectUpTo(List<E> list, int n) {
        ArrayList<List<E>> arrayList = new ArrayList<List<E>>();
        for (int i = 1; i <= n; ++i) {
            arrayList.addAll(CollectionUtils.selectExactly(list, i));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static <E> Collection<List<E>> selectExactly(List<E> list, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return Collections.emptyList();
        }
        if (n == 1) {
            ArrayList<List<List<E>>> arrayList = new ArrayList<List<List<E>>>();
            for (E e : list) {
                arrayList.add(Collections.singletonList(e));
            }
            return arrayList;
        }
        if (n > list.size()) {
            return Collections.emptyList();
        }
        if (n == list.size()) {
            return Collections.singletonList(list);
        }
        ArrayList<List<E>> arrayList = new ArrayList<List<E>>();
        for (List<E> list2 : CollectionUtils.selectExactly(list.subList(1, list.size()), n - 1)) {
            ArrayList<E> arrayList2 = new ArrayList<E>();
            arrayList2.add(list.get(0));
            arrayList2.addAll(list2);
            arrayList.add(Collections.unmodifiableList(arrayList2));
        }
        arrayList.addAll(CollectionUtils.selectExactly(list.subList(1, list.size()), n));
        return Collections.unmodifiableList(arrayList);
    }
}

