# Generated by default/object.tt
package Paws::AppMesh::ListenerTlsSdsCertificate;
  use Moose;
  has SecretName => (is => 'ro', isa => 'Str', request_name => 'secretName', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppMesh::ListenerTlsSdsCertificate

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppMesh::ListenerTlsSdsCertificate object:

  $service_obj->Method(Att1 => { SecretName => $value, ..., SecretName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppMesh::ListenerTlsSdsCertificate object:

  $result = $service_obj->Method(...);
  $result->Att1->SecretName

=head1 DESCRIPTION

An object that represents the listener's Secret Discovery Service
certificate. The proxy must be configured with a local SDS provider via
a Unix Domain Socket. See App Mesh TLS documentation
(https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html) for
more info.

=head1 ATTRIBUTES


=head2 B<REQUIRED> SecretName => Str

A reference to an object that represents the name of the secret
requested from the Secret Discovery Service provider representing
Transport Layer Security (TLS) materials like a certificate or
certificate chain.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppMesh>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

