# Generated by default/object.tt
package Paws::AppRunner::OperationSummary;
  use Moose;
  has EndedAt => (is => 'ro', isa => 'Str');
  has Id => (is => 'ro', isa => 'Str');
  has StartedAt => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');
  has TargetArn => (is => 'ro', isa => 'Str');
  has Type => (is => 'ro', isa => 'Str');
  has UpdatedAt => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppRunner::OperationSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppRunner::OperationSummary object:

  $service_obj->Method(Att1 => { EndedAt => $value, ..., UpdatedAt => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppRunner::OperationSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->EndedAt

=head1 DESCRIPTION

Provides summary information for an operation that occurred on an AWS
App Runner service.

=head1 ATTRIBUTES


=head2 EndedAt => Str

The time when the operation ended. It's in the Unix time stamp format.


=head2 Id => Str

A unique ID of this operation. It's unique in the scope of the App
Runner service.


=head2 StartedAt => Str

The time when the operation started. It's in the Unix time stamp
format.


=head2 Status => Str

The current state of the operation.


=head2 TargetArn => Str

The Amazon Resource Name (ARN) of the resource that the operation acted
on (for example, an App Runner service).


=head2 Type => Str

The type of operation. It indicates a specific action that occured.


=head2 UpdatedAt => Str

The time when the operation was last updated. It's in the Unix time
stamp format.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppRunner>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

