# Generated by default/object.tt
package Paws::ApiGateway::TlsConfig;
  use Moose;
  has InsecureSkipVerification => (is => 'ro', isa => 'Bool', request_name => 'insecureSkipVerification', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ApiGateway::TlsConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ApiGateway::TlsConfig object:

  $service_obj->Method(Att1 => { InsecureSkipVerification => $value, ..., InsecureSkipVerification => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ApiGateway::TlsConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->InsecureSkipVerification

=head1 DESCRIPTION

This class has no description

=head1 ATTRIBUTES


=head2 InsecureSkipVerification => Bool

Specifies whether or not API Gateway skips verification that the
certificate for an integration endpoint is issued by a supported
certificate authority
(https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-supported-certificate-authorities-for-http-endpoints.html).
This isnE<rsquo>t recommended, but it enables you to use certificates
that are signed by private certificate authorities, or certificates
that are self-signed. If enabled, API Gateway still performs basic
certificate validation, which includes checking the certificate's
expiration date, hostname, and presence of a root certificate
authority. Supported only for C<HTTP> and C<HTTP_PROXY> integrations.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ApiGateway>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

