#!/bin/sh
while test $# -gt 0
do
  case "$1" in
     -h|--help|--usage)
       echo "Usage info: ..."
       exit
     ;;
     +s|++switch)
       switch=0
     ;;
     -s|--switch)
       switch=1
     ;;
     -p|--param)
       param=$2; shift
     ;;
     --param=*)
       param=$(printf %s "$1" | cut -f 2- -d =)
     ;;
     --)
        shift;
        break;
     ;;
     -*)
       echo "$0: unregognized option: $1" >&2
       exit 1
     ;;
     *)
       break;
     ;;
   esac
   shift
done


echo "Program running with:"
echo "switch: $switch"
echo "param:  $param"
for arg in "$@"
do
  echo "operand: $arg"
done
