package Daje::Workflow::Checks;
use Mojo::Base -base, -signatures;

use Mojo::Loader qw(load_class);

# Daje::Workflow::Checks - is an inteface class to pre and post checks
#
# METHODS
# =======
#
#   check($self, $context, $checks)
#
#   $checks = [
#       {
#           "name":"Mandatory fields",
#           "class": "Daje::Workflow::Checks::Mandatory",
#           "checks": "sql_path,perl_path"
#        }
#   ]
#
#

has 'error';

sub check($self, $context, $checks) {
    return 1 unless defined $checks;
    my $result = 1;

    my $length = scalar @{$checks};
    for (my $i = 0; $i < $length; $i++) {
        my $cl = @{$checks}[$i]->{class};
        my $class = load_class $cl;
        # $class->import();
        $result = $cl->new(
            context => $context,
            checks  => @{$checks}[$i]->{checks},
            error   => $self->error,
        )->check();
    }
    return $result;
}
1;

#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

Daje::Workflow::Checks


=head1 DESCRIPTION

Daje::Workflow::Checks - is an inteface class to pre and post checks



=head1 REQUIRES

L<Mojo::Loader> 

L<Mojo::Base> 


=head1 METHODS


  check($self, $context, $checks)

  $checks = [
      {
          "name":"Mandatory fields",
          "class": "Daje::Workflow::Checks::Mandatory",
          "checks": "sql_path,perl_path"
       }
  ]




=cut

