use strict;
use warnings;
package App::DubiousHTTP::Tests::TestID;

sub num2path {{
    1	=> "chunked\/chunked",
    2	=> "chunked\/clen",
    3	=> "chunked\/0size",
    4	=> "chunked\/00size",
    5	=> "chunked\/ucsize",
    6	=> "chunked\/0ucsize",
    7	=> "chunked\/32\-size",
    8	=> "chunked\/64\-size",
    9	=> "chunked\/size\-space",
    10	=> "chunked\/size\-tab",
    11	=> "chunked\/size\-cr",
    12	=> "chunked\/size\-lf",
    13	=> "chunked\/size\-x",
    14	=> "chunked\/size\-\\054",
    15	=> "chunked\/size\-\\000",
    16	=> "chunked\/size\-\\013",
    17	=> "chunked\/size\-\\014",
    18	=> "chunked\/size\-spacex",
    19	=> "chunked\/space\-size",
    20	=> "chunked\/tab\-size",
    21	=> "chunked\/cr\-size",
    22	=> "chunked\/lf\-size",
    23	=> "chunked\/crlf\-size",
    24	=> "chunked\/crlf\-crlf\-size",
    25	=> "chunked\/crlf\-x\-crlf\-size",
    26	=> "chunked\/x\-size",
    27	=> "chunked\/\\054\-size",
    28	=> "chunked\/\\073\-size",
    29	=> "chunked\/\\000\-size",
    30	=> "chunked\/\\013\-size",
    31	=> "chunked\/\\014\-size",
    32	=> "chunked\/xspace\-size",
    33	=> "chunked\/\\053\-size",
    34	=> "chunked\/\\060\\170\-size",
    35	=> "chunked\/final\=00",
    36	=> "chunked\/final\=00000000000000000000",
    37	=> "chunked\/final\=0x",
    38	=> "chunked\/final\=Foo",
    39	=> "chunked\/finalchunk\=0\\012",
    40	=> "chunked\/finalchunk\=0\\015",
    41	=> "chunked\/finalchunk\=0",
    42	=> "chunked\/finalchunk\=0\\012\\012",
    43	=> "chunked\/finalchunk\=0\\012\\040\\012",
    44	=> "chunked\/finalchunk\=0\\012\\015\\012",
    45	=> "chunked\/finalchunk\=0\\012\\015\\015\\012",
    46	=> "chunked\/finalchunk\=0\\015\\012foobar\\015\\012",
    47	=> "chunked\/chunk\-ext\-junk",
    48	=> "chunked\/chunk\-ext\-chunk",
    49	=> "chunked\/chunked\,clen",
    50	=> "chunked\/clen\,chunked",
    51	=> "chunked\/chunked\,clen200",
    52	=> "chunked\/chunked\,clen50",
    53	=> "chunked\/addjunk\,chunked\,clen50",
    54	=> "chunked\/chunked\,http10",
    55	=> "chunked\/chunked\,clen\,http10",
    56	=> "chunked\/clen\,chunked\,http10",
    57	=> "chunked\/chunked\,http10\,gzip",
    58	=> "chunked\/chunked\,clen\,http10\,gzip",
    59	=> "chunked\/clen\,chunked\,http10\,gzip",
    60	=> "chunked\/chunked\,http10\,do_clen",
    61	=> "chunked\/chunked\,clen\,http10\,do_clen",
    62	=> "chunked\/clen\,chunked\,http10\,do_clen",
    63	=> "chunked\/chunked\,http10\,do_clen\,gzip",
    64	=> "chunked\/chunked\,clen\,http10\,do_clen\,gzip",
    65	=> "chunked\/clen\,chunked\,http10\,do_clen\,gzip",
    66	=> "chunked\/chunked\,HTTP\/1\.2",
    67	=> "chunked\/chunked\,clen\,HTTP\/1\.2\,do_clen",
    68	=> "chunked\/chunked\,HTTP\/2\.0",
    69	=> "chunked\/chunked\,clen\,HTTP\/2\.0\,do_clen",
    70	=> "chunked\/chunked\,HTTP\/2\.1",
    71	=> "chunked\/chunked\,clen\,HTTP\/2\.1\,do_clen",
    72	=> "chunked\/chunked\,HTTP\/0\.9",
    73	=> "chunked\/chunked\,clen\,HTTP\/0\.9\,do_clen",
    74	=> "chunked\/chunked\,HTTP\/1\.01",
    75	=> "chunked\/chunked\,clen\,HTTP\/1\.01\,do_clen",
    76	=> "chunked\/chunked\,HTTP\/1\.10",
    77	=> "chunked\/chunked\,clen\,HTTP\/1\.10\,do_clen",
    78	=> "chunked\/chunked\,http\/1\.1",
    79	=> "chunked\/chunked\,clen\,http\/1\.1\,do_clen",
    80	=> "chunked\/chunked\,http\/1\.0",
    81	=> "chunked\/chunked\,clen\,http\/1\.0\,do_clen",
    82	=> "chunked\/chunked\,HTTP\/0\.1\,gzip",
    83	=> "chunked\/chunked\,clen\,HTTP\/0\.1\,gzip\,do_clen",
    84	=> "chunked\/chunked\,HTTP\/01\.1\,gzip",
    85	=> "chunked\/chunked\,clen\,HTTP\/01\.1\,gzip\,do_clen",
    86	=> "chunked\/chunked\,HTTP\/11\.01\,gzip",
    87	=> "chunked\/chunked\,clen\,HTTP\/11\.01\,gzip\,do_clen",
    88	=> "chunked\/chunked\,HTTP\/11\.10\,gzip",
    89	=> "chunked\/chunked\,clen\,HTTP\/11\.10\,gzip\,do_clen",
    90	=> "chunked\/chunked\,HTTP\/9\.9\,gzip",
    91	=> "chunked\/chunked\,clen\,HTTP\/9\.9\,gzip\,do_clen",
    92	=> "chunked\/chUnked",
    93	=> "chunked\/nl\-chunked",
    94	=> "chunked\/chunkednl\-",
    95	=> "chunked\/nl\-nl\-chunked",
    96	=> "chunked\/nl\-nl\-chunked\-nl\-",
    97	=> "chunked\/chu",
    98	=> "chunked\/chunked\-semicolon",
    99	=> "chunked\/xchunked",
    100	=> "chunked\/chunkedx",
    101	=> "chunked\/chunked\-x",
    102	=> "chunked\/x\-chunked",
    103	=> "chunked\/chunked\-x\,do_clen",
    104	=> "chunked\/x\-chunked\,do_clen",
    105	=> "chunked\/x\-nl\-chunked",
    106	=> "chunked\/chunked\-nl\-x",
    107	=> "chunked\/rfc2047\,do_chunked",
    108	=> "chunked\/rfc2047\,do_clen",
    109	=> "chunked\/rfc2047\,clen\,do_clen",
    110	=> "chunked\/nl\-chunked\,do_clen",
    111	=> "chunked\/chunkednl\-\,do_clen",
    112	=> "chunked\/nl\-nl\-chunked\,do_clen",
    113	=> "chunked\/crchunked\,do_chunked",
    114	=> "chunked\/crchunked\,do_clen",
    115	=> "chunked\/cr\-chunked\,do_chunked",
    116	=> "chunked\/cr\-chunked\,do_clen",
    117	=> "chunked\/chunkedcr\-\,do_chunked",
    118	=> "chunked\/chunkedcr\-\,do_clen",
    119	=> "chunked\/ce\-chunked\,do_chunked",
    120	=> "chunked\/xte\,chunked\,do_chunked",
    121	=> "chunked\/xte\,chunked\,do_chunked\,gzip",
    122	=> "chunked\/chunked\,xte\,do_chunked",
    123	=> "chunked\/chunked\,xte\,do_chunked\,gzip",
    124	=> "chunked\/xte\,chunked\,xte\,do_chunked",
    125	=> "chunked\/xte\,chunked\,do_clen",
    126	=> "chunked\/chunked\,xte\,do_clen",
    127	=> "chunked\/chunked\,xte\,clen\,do_chunked",
    128	=> "chunked\/xte\,chunked\,clen\,do_chunked",
    129	=> "chunked\/xte\,chunked\,xte\,clen\,do_chunked",
    130	=> "chunked\/chunked\,xte\,clen\,do_clen",
    131	=> "chunked\/chunked\,xte\,clen\,do_clen\,gzip",
    132	=> "chunked\/xte\,chunked\,clen\,do_clen",
    133	=> "chunked\/xte\,chunked\,clen\,do_clen\,gzip",
    134	=> "chunked\/chunked\,clen\,do_clen",
    135	=> "chunked\/chunked\,clen\,do_clen\,gzip",
    136	=> "chunked\/space\-colon\-chunked\,do_chunked",
    137	=> "chunked\/tab\-colon\-chunked\,do_chunked",
    138	=> "chunked\/cr\-colon\-chunked\,do_chunked",
    139	=> "chunked\/space\-colon\-chunked\,do_clen",
    140	=> "chunked\/tab\-colon\-chunked\,do_clen",
    141	=> "chunked\/cr\-colon\-chunked\,do_clen",
    142	=> "chunked\/colon\-colon\-chunked\,do_chunked",
    143	=> "chunked\/colon\-colon\-chunked\,do_clen",
    144	=> "chunked\/cronly\-chunked\,do_chunked",
    145	=> "chunked\/crxonly\-chunked\,do_chunked",
    146	=> "chunked\/cronly\-chunked\,do_clen",
    147	=> "chunked\/lfonly\-chunked\,do_chunked",
    148	=> "chunked\/lfonly\-chunked\,do_clen",
    149	=> "chunked\/chunk\-lf",
    150	=> "chunked\/chunk\-cr",
    151	=> "chunked\/chunk\-crcr",
    152	=> "chunked\/chunk\-lflf",
    153	=> "chunked\/chunk\-lfcr",
    154	=> "chunked\/nofinal",
    155	=> "chunked\/eof\-inchunk",
    156	=> "chunked\/space\-before\-chunks",
    157	=> "chunked\/lf\-before\-chunks",
    158	=> "chunked\/cr\-before\-chunks",
    159	=> "chunked\/crlf\-before\-chunks",
    160	=> "compressed\/ce\:gzip\;gzip",
    161	=> "compressed\/ce\:x\-gzip\;gzip",
    162	=> "compressed\/ce\:deflate\;deflate",
    163	=> "compressed\/ce\:deFLaTe\;deflate",
    164	=> "compressed\/ce\:gzip\;gzip2p\,partial",
    165	=> "compressed\/ce\:deflate\;deflate2p\,partial",
    166	=> "compressed\/ce\:gzip\;gzip2p\,block",
    167	=> "compressed\/ce\:deflate\;deflate2p\,block",
    168	=> "compressed\/ce\:gzip\;gzip2p\,sync",
    169	=> "compressed\/ce\:deflate\;deflate2p\,sync",
    170	=> "compressed\/ce\:gzip\;gzip2p",
    171	=> "compressed\/ce\:deflate\;deflate2p",
    172	=> "compressed\/ce\:gzip\;gzip2p\,finish",
    173	=> "compressed\/ce\:deflate\;deflate2p\,finish",
    174	=> "compressed\/ce\:gzip\;gzip2s",
    175	=> "compressed\/ce\:deflate\;deflate2s",
    176	=> "compressed\/ce\:deflate\;zlib2s",
    177	=> "compressed\/ce\:deflate\;pkt\:zlib\+deflate",
    178	=> "compressed\/ce\:deflate\;chk\:zlib\+deflate",
    179	=> "compressed\/ce\:deflate\;pkt\:zlib\+deflate\+deflate",
    180	=> "compressed\/ce\:deflate\;chk\:zlib\+deflate\+deflate",
    181	=> "compressed\/ce\:lzma\;lzma1",
    182	=> "compressed\/ce\:br\;brotli",
    183	=> "compressed\/ce\:gzip\;gzip\-zlib",
    184	=> "compressed\/ce\:deflate\;zlib",
    185	=> "compressed\/ce\:deflate\;zlib2p",
    186	=> "compressed\/ce\:nl\-gzip\;gzip",
    187	=> "compressed\/ce\:nl\-deflate\;deflate",
    188	=> "compressed\/ce\:nl\-nl\-deflate\;deflate",
    189	=> "compressed\/ce\:deflate\,\;deflate",
    190	=> "compressed\/ce\:deflate\-nl\-\,\;deflate",
    191	=> "compressed\/ce\:deflate\-nl\-\,\-nl\-\;deflate",
    192	=> "compressed\/te\:gzip\;gzip",
    193	=> "compressed\/te\:deflate\;deflate",
    194	=> "compressed\/te\:gzip\;ce\:gzip\;gzip\;gzip",
    195	=> "compressed\/ce\:gzip\;ce\:gzip\;gzip\;gzip",
    196	=> "compressed\/ce\:gzip\,gzip\;gzip\;gzip",
    197	=> "compressed\/ce\:deflate\;ce\:deflate\;deflate\;deflate",
    198	=> "compressed\/ce\:deflate\,deflate\;deflate\;deflate",
    199	=> "compressed\/ce\:deflate\-nl\-\,\-nl\-deflate\;deflate\;deflate",
    200	=> "compressed\/ce\:deflate\-nl\-\,\-nl\-deflate\-nl\-\;deflate\;deflate",
    201	=> "compressed\/ce\:gzip\;ce\:deflate\;gzip\;deflate",
    202	=> "compressed\/ce\:gzip\,deflate\;gzip\;deflate",
    203	=> "compressed\/ce\:deflate\;ce\:gzip\;deflate\;gzip",
    204	=> "compressed\/ce\:deflate\,gzip\;deflate\;gzip",
    205	=> "compressed\/ce\:identity",
    206	=> "compressed\/ce\:identity\;ce\:identity",
    207	=> "compressed\/ce\:identity\,identity",
    208	=> "compressed\/ce\:identity\;ce\:gzip\;gzip",
    209	=> "compressed\/ce\:identity\,gzip\;gzip",
    210	=> "compressed\/ce\:gzip\;ce\:identity\;gzip",
    211	=> "compressed\/ce\:gzip\,identity\;gzip",
    212	=> "compressed\/ce\:identity\;ce\:deflate\;deflate",
    213	=> "compressed\/ce\:identity\,deflate\;deflate",
    214	=> "compressed\/ce\:deflate\;ce\:identity\;deflate",
    215	=> "compressed\/ce\:deflate\,identity\;deflate",
    216	=> "compressed\/ce\:gzip\;ce\:deflate\;ce\:gzip\;gzip\;deflate\;gzip",
    217	=> "compressed\/ce\:gzip\,deflate\,gzip\;gzip\;deflate\;gzip",
    218	=> "compressed\/ce\:gzip\,deflate\;ce\:gzip\;gzip\;deflate\;gzip",
    219	=> "compressed\/ce\:deflate\;ce\:gzip\;ce\:deflate\;deflate\;gzip\;deflate",
    220	=> "compressed\/ce\:deflate\,gzip\,deflate\;deflate\;gzip\;deflate",
    221	=> "compressed\/ce\:deflate\,gzip\;ce\:deflate\;deflate\;gzip\;deflate",
    222	=> "compressed\/ce\:gzip\;ce\:gzip\;gzip",
    223	=> "compressed\/ce\:gzip\;ce\:gzip",
    224	=> "compressed\/ce\:deflate\;ce\:deflate\;deflate",
    225	=> "compressed\/ce\:deflate\;ce\:deflate",
    226	=> "compressed\/ce\:gzip\;ce\:deflate\;deflate\;gzip",
    227	=> "compressed\/ce\:gzip\;ce\:deflate\;deflate",
    228	=> "compressed\/ce\:gzip\;ce\:deflate\;gzip",
    229	=> "compressed\/ce\:gzip\;ce\:deflate",
    230	=> "compressed\/ce\:gzip\,deflate\;deflate\;gzip",
    231	=> "compressed\/ce\:gzip\,deflate\;deflate",
    232	=> "compressed\/ce\:gzip\,deflate\;gzip",
    233	=> "compressed\/ce\:gzip\,deflate",
    234	=> "compressed\/ce\:deflate\;ce\:gzip\;gzip\;deflate",
    235	=> "compressed\/ce\:deflate\;ce\:gzip\;gzip",
    236	=> "compressed\/ce\:deflate\;ce\:gzip\;deflate",
    237	=> "compressed\/ce\:deflate\;ce\:gzip",
    238	=> "compressed\/ce\:deflate\,gzip\;gzip\;deflate",
    239	=> "compressed\/ce\:deflate\,gzip\;gzip",
    240	=> "compressed\/ce\:deflate\,gzip\;deflate",
    241	=> "compressed\/ce\:deflate\,gzip",
    242	=> "compressed\/ce\:x\-deflate\;deflate",
    243	=> "compressed\/ce\:x\-deflate\;zlib",
    244	=> "compressed\/ce\:gzipx\;gzip",
    245	=> "compressed\/ce\:xgzip\;gzip",
    246	=> "compressed\/ce\:gzip_x\;gzip",
    247	=> "compressed\/ce\:x_gzip\;gzip",
    248	=> "compressed\/ce\:deflate\;gzip",
    249	=> "compressed\/ce\:gzip\;deflate",
    250	=> "compressed\/ce\:deflate",
    251	=> "compressed\/ce\:deflate\,",
    252	=> "compressed\/ce\:deflate\-nl\-\,",
    253	=> "compressed\/ce\:deflate\-nl\-\,\-nl\-",
    254	=> "compressed\/ce\:gzip_x",
    255	=> "compressed\/ce\:deflate\;ce\:gzip_x\;deflate",
    256	=> "compressed\/ce\:gzip_x\;ce\:deflate\;deflate",
    257	=> "compressed\/ce\:foo",
    258	=> "compressed\/ce\:rfc2047\-deflate",
    259	=> "compressed\/ce\:rfc2047\-deflate\;deflate",
    260	=> "compressed\/te\:gzip",
    261	=> "compressed\/ce\-space\-colon\-deflate\;deflate",
    262	=> "compressed\/ce\-space\-colon\-deflate",
    263	=> "compressed\/ce\-space\-colon\-gzip\;gzip",
    264	=> "compressed\/ce\-space\-colon\-gzip",
    265	=> "compressed\/ce\-colon\-colon\-deflate\;deflate",
    266	=> "compressed\/ce\-colon\-colon\-deflate",
    267	=> "compressed\/ce\-colon\-colon\-gzip\;gzip",
    268	=> "compressed\/ce\-colon\-colon\-gzip",
    269	=> "compressed\/cronly\-deflate\;deflate",
    270	=> "compressed\/crxonly\-deflate\;deflate",
    271	=> "compressed\/cronly\-deflate",
    272	=> "compressed\/cronly\-gzip\;gzip",
    273	=> "compressed\/crxonly\-gzip\;gzip",
    274	=> "compressed\/cronly\-gzip",
    275	=> "compressed\/lfonly\-deflate\;deflate",
    276	=> "compressed\/lfonly\-deflate",
    277	=> "compressed\/lfonly\-gzip\;gzip",
    278	=> "compressed\/lfonly\-gzip",
    279	=> "compressed\/ce\:crdeflate\;deflate",
    280	=> "compressed\/ce\:crdeflate",
    281	=> "compressed\/ce\:cr\-deflate\;deflate",
    282	=> "compressed\/ce\:cr\-deflate",
    283	=> "compressed\/ce\:crgzip\;gzip",
    284	=> "compressed\/ce\:crgzip",
    285	=> "compressed\/ce\:cr\-gzip\;gzip",
    286	=> "compressed\/ce\:cr\-gzip",
    287	=> "compressed\/ce\:gzip\;gzip\;replace\:0\,2\=1f8c",
    288	=> "compressed\/ce\:gzip\;gzip\;replace\:2\,1\=88",
    289	=> "compressed\/ce\:gzip\;gzip\;replace\:3\,1\|01",
    290	=> "compressed\/ce\:gzip\;gzip\;replace\:3\,1\|02",
    291	=> "compressed\/ce\:gzip\;gzip\;replace\:3\,1\|02\;replace\:10\,0\=0000",
    292	=> "compressed\/ce\:gzip\;gzip\;replace\:3\,1\|04\;replace\:10\,0\=0000",
    293	=> "compressed\/ce\:gzip\;gzip\;replace\:3\,1\|04\;replace\:10\,0\=05004170010000",
    294	=> "compressed\/ce\:gzip\;gzip\;replace\:3\,1\|04\;replace\:10\,0\=0500",
    295	=> "compressed\/ce\:gzip\;gzip\-payload\-as\-extra",
    296	=> "compressed\/ce\:gzip\;gzip\;replace\:3\,1\|08\;replace\:10\,0\=2000",
    297	=> "compressed\/ce\:gzip\;gzip\;replace\:3\,1\|10\;replace\:10\,0\=2000",
    298	=> "compressed\/ce\:gzip\;gzip\;replace\:3\,1\|20",
    299	=> "compressed\/ce\:gzip\;gzip\;replace\:3\,1\|40",
    300	=> "compressed\/ce\:gzip\;gzip\;replace\:3\,1\|80",
    301	=> "compressed\/ce\:gzip\;gzip\;replace\:\-8\,4\^ffffffff",
    302	=> "compressed\/ce\:gzip\;gzip\;replace\:\-4\,1\^ff",
    303	=> "compressed\/ce\:gzip\;gzip\;replace\:\-4\,4\=",
    304	=> "compressed\/ce\:gzip\;gzip\;replace\:\-8\,8\=",
    305	=> "compressed\/ce\:gzip\;gzip\;replace\:\-4\,4\=\;clen\+4",
    306	=> "compressed\/ce\:gzip\;gzip\;replace\:\-8\,8\=\;clen\+8",
    307	=> "compressed\/ce\:gzip\;gzip\;replace\:\-4\,4\=\;noclen",
    308	=> "compressed\/ce\:gzip\;gzip\;replace\:\-8\,8\=\;noclen",
    309	=> "compressed\/ce\:cr\-gzip\;gzip\;replace\:3\,1\|01",
    310	=> "compressed\/ce\:cr\-gzip\;gzip\;replace\:3\,1\|02\;replace\:10\,0\=0000",
    311	=> "compressed\/ce\:cr\-gzip\;gzip\;replace\:3\,1\|08\;replace\:10\,0\=2000",
    312	=> "compressed\/ce\:cr\-gzip\;gzip\;replace\:3\,1\|10\;replace\:10\,0\=2000",
    313	=> "compressed\/ce\:cr\-gzip\;gzip\;replace\:3\,1\|04\;replace\:10\,0\=0000",
    314	=> "compressed\/ce\:cr\-gzip\;gzip\;replace\:3\,1\|04\;replace\:10\,0\=05004170010000",
    315	=> "compressed\/ce\:cr\-gzip\;gzip\;replace\:3\,1\|20",
    316	=> "compressed\/ce\:cr\-gzip\;gzip\;replace\:3\,1\|40",
    317	=> "compressed\/ce\:cr\-gzip\;gzip\;replace\:3\,1\|80",
    318	=> "compressed\/ce\:cr\-gzip\;gzip\;replace\:\-8\,4\^ffffffff",
    319	=> "compressed\/ce\:cr\-gzip\;gzip\;replace\:\-4\,1\^ff",
    320	=> "compressed\/ce\:cr\-gzip\;gzip\;replace\:\-4\,4\=",
    321	=> "compressed\/ce\:cr\-gzip\;gzip\;replace\:\-8\,8\=",
    322	=> "compressed\/ce\-space\-colon\-gzip\;gzip\;replace\:3\,1\|01",
    323	=> "compressed\/ce\-space\-colon\-gzip\;gzip\;replace\:3\,1\|02\;replace\:10\,0\=0000",
    324	=> "compressed\/ce\-space\-colon\-gzip\;gzip\;replace\:3\,1\|08\;replace\:10\,0\=2000",
    325	=> "compressed\/ce\-space\-colon\-gzip\;gzip\;replace\:3\,1\|10\;replace\:10\,0\=2000",
    326	=> "compressed\/ce\-space\-colon\-gzip\;gzip\;replace\:3\,1\|04\;replace\:10\,0\=0000",
    327	=> "compressed\/ce\-space\-colon\-gzip\;gzip\;replace\:3\,1\|04\;replace\:10\,0\=05004170010000",
    328	=> "compressed\/ce\-space\-colon\-gzip\;gzip\;replace\:3\,1\|20",
    329	=> "compressed\/ce\-space\-colon\-gzip\;gzip\;replace\:3\,1\|40",
    330	=> "compressed\/ce\-space\-colon\-gzip\;gzip\;replace\:3\,1\|80",
    331	=> "compressed\/ce\-space\-colon\-gzip\;gzip\;replace\:\-8\,4\^ffffffff",
    332	=> "compressed\/ce\-space\-colon\-gzip\;gzip\;replace\:\-4\,1\^ff",
    333	=> "compressed\/ce\-space\-colon\-gzip\;gzip\;replace\:\-4\,4\=",
    334	=> "compressed\/ce\-space\-colon\-gzip\;gzip\;replace\:\-8\,8\=",
    335	=> "compressed\/ce\:gzip\;gzip\;\\012\-before\-body",
    336	=> "clen\/close\,clen\,content",
    337	=> "clen\/close\,content",
    338	=> "clen\/close\,clen\,content\,junk",
    339	=> "clen\/close\,clen\,clen\,content\,junk",
    340	=> "clen\/close\,clen200\,content",
    341	=> "clen\/close\,clen50\,content",
    342	=> "clen\/close\,clen50\,clen\,content",
    343	=> "clen\/close\,clen\,clen50\,content",
    344	=> "clen\/close\,clen200\,clen\,content\,junk",
    345	=> "clen\/close\,clen\,clen200\,content\,junk",
    346	=> "clen\/close\,clen\-folding100\,clen200\,content\,junk",
    347	=> "clen\/close\,xte\,clen50\,clen\,content",
    348	=> "clen\/close\,xte\,clen\,clen50\,content",
    349	=> "clen\/close\,xte\,clen200\,clen\,content\,junk",
    350	=> "clen\/close\,xte\,clen\,clen200\,content\,junk",
    351	=> "clen\/close\,xte\,clen\-folding100\,clen200\,content\,junk",
    352	=> "clen\/close\,clen50\-folding100\,content",
    353	=> "clen\/close\,clen50\-100\,content",
    354	=> "clen\/close\,clen50\-\(100\)\,content",
    355	=> "clen\/close\,clen100\-folding50\,content",
    356	=> "clen\/close\,clen100\-50\,content",
    357	=> "clen\/close\,clen\(100\)\-50\,content",
    358	=> "clen\/close\,clen100\-folding200\,content\,junk",
    359	=> "clen\/close\,clen100\-\(200\)\,content\,junk",
    360	=> "clen\/close\,clen200\-folding100\,content\,junk",
    361	=> "clen\/close\,clen\(200\)\-100\,content\,junk",
    362	=> "clen\/close\,\\073\(clen\)\,content\,junk",
    363	=> "clen\/close\,\(clen\)\\073\,content\,junk",
    364	=> "clen\/close\,\\054\(clen\)\,content\,junk",
    365	=> "clen\/close\,\(clen\)\\054\,content\,junk",
    366	=> "clen\/close\,\(clen\)\\054\(clen\)\,content\,junk",
    367	=> "clen\/close\,\\042\(clen\)\\042\,content\,junk",
    368	=> "clen\/close\,\(clen\)A\,content\,junk",
    369	=> "clen\/close\,A\(clen\)\,content\,junk",
    370	=> "clen\/close\,\(clen\)\\040A\,content\,junk",
    371	=> "clen\/close\,A\\040\(clen\)\,content\,junk",
    372	=> "clen\/close\,\\240\(clen\)\,content\,junk",
    373	=> "clen\/close\,\(clen\)\\240\,content\,junk",
    374	=> "clen\/close\,\(clen\)\.0\,content\,junk",
    375	=> "clen\/close\,\(clen\)\.9\,content\,junk",
    376	=> "broken\/ok",
    377	=> "broken\/http09",
    378	=> "broken\/\\012http09",
    379	=> "broken\/\\012\\012http09",
    380	=> "broken\/HTT\\012\\012http09",
    381	=> "broken\/HTTP\\012\\012http09",
    382	=> "broken\/hTtp\\012\\012http09",
    383	=> "broken\/HTTP\\012http09",
    384	=> "broken\/hTtp\\012http09",
    385	=> "broken\/HTTP\/\\012\\012http09",
    386	=> "broken\/HTTP\.\\012\\012http09",
    387	=> "broken\/HTTPx\\012\\012http09",
    388	=> "broken\/HTTP\/1\.1\\040100\\040ok\\012\\012http09",
    389	=> "broken\/HTTP\/1\.1\\040\\053100\\040ok\\012\\012http09",
    390	=> "broken\/chunked\;177",
    391	=> "broken\/hdrfirst\;space\;chunked",
    392	=> "broken\/hdrfirst\;tab\;chunked",
    393	=> "broken\/hdrfirst\;space\;chunked\;do_clen",
    394	=> "broken\/hdrfirst\;tab\;chunked\;do_clen",
    395	=> "broken\/hdrfirst\;space\;chunked\;do_close",
    396	=> "broken\/hdrfirst\;tab\;chunked\;do_close",
    397	=> "broken\/somehdr\;space\;chunked",
    398	=> "broken\/somehdr\;tab\;chunked",
    399	=> "broken\/somehdr\;space\;chunked\;do_clen",
    400	=> "broken\/somehdr\;tab\;chunked\;do_clen",
    401	=> "broken\/8bitkey\;chunked",
    402	=> "broken\/8bitkey\;chunked\;do_clen",
    403	=> "broken\/colon\;chunked",
    404	=> "broken\/colon\;chunked\;do_clen",
    405	=> "broken\/177\;chunked",
    406	=> "broken\/177\;chunked\;do_clen",
    407	=> "broken\/data\:\\000\;chunked",
    408	=> "broken\/data\:\\000\;chunked\;do_clen",
    409	=> "broken\/junkline\;chunked",
    410	=> "broken\/junkline\;chunked\;do_clen",
    411	=> "broken\/spacehdr\;chunked",
    412	=> "broken\/spacehdr\;chunked\;do_clen",
    413	=> "broken\/cr\;chunked",
    414	=> "broken\/lf\;chunked",
    415	=> "broken\/crcr\;chunked",
    416	=> "broken\/lfcr\;chunked",
    417	=> "broken\/crcronly\;chunked",
    418	=> "broken\/cr\-cronly\;chunked",
    419	=> "broken\/crcronly\;chunked\;do_clen",
    420	=> "broken\/cr\-cronly\;chunked\;do_clen",
    421	=> "broken\/lflfonly\;chunked",
    422	=> "broken\/lf\-lfonly\;chunked",
    423	=> "broken\/lflfonly\;chunked\;do_clen",
    424	=> "broken\/lf\-lfonly\;chunked\;do_clen",
    425	=> "broken\/crlf\-crlfonly\;chunked",
    426	=> "broken\/crlf\-crlfonly\;chunked\;do_clen",
    427	=> "broken\/te\:chu\\000nked\;do_chunked",
    428	=> "broken\/data\:Transfer\\000\-encoding\:chunked\\015\\012\;do_chunked",
    429	=> "broken\/data\:Transfer\\000\-encoding\:chun\\000ked\\015\\012\;do_chunked",
    430	=> "broken\/te\\000\:chunked\;do_chunked",
    431	=> "broken\/te\\040\\011\\040\\011\\040\:chunked\;do_chunked",
    432	=> "broken\/te\\013\:chunked\;do_chunked",
    433	=> "broken\/te\\014\:chunked\;do_chunked",
    434	=> "broken\/te\\012\\040\:chunked\;do_chunked",
    435	=> "broken\/te\\015\\040\:chunked\;do_chunked",
    436	=> "broken\/te\\015\\012\\040\:chunked\;do_chunked",
    437	=> "broken\/te\\015\\012\\040\:\\015\\012\\040chunked\;do_chunked",
    438	=> "broken\/te\\015\\012\\040\\015\\012\\040\:\\015\\012\\040chunked\;do_chunked",
    439	=> "broken\/te\\012\\000\:chunked\;do_chunked",
    440	=> "broken\/te\:\,chunked\;do_chunked",
    441	=> "broken\/te\:\\073chunked\;do_chunked",
    442	=> "broken\/te\:\\000chunked\;do_chunked",
    443	=> "broken\/te\:\\013chunked\;do_chunked",
    444	=> "broken\/te\:\\014chunked\;do_chunked",
    445	=> "broken\/te\:\\240chunked\;do_chunked",
    446	=> "broken\/te\:\\012\\000chunked\;do_chunked",
    447	=> "broken\/te\:\\012\\013chunked\;do_chunked",
    448	=> "broken\/te\:\\012\\014chunked\;do_chunked",
    449	=> "broken\/te\:\\012\\240chunked\;do_chunked",
    450	=> "broken\/te\:chunked\,\;do_chunked",
    451	=> "broken\/te\:chunked\\073\;do_chunked",
    452	=> "broken\/te\:chunked\\000\;do_chunked",
    453	=> "broken\/te\:\\177chunked\;do_chunked",
    454	=> "broken\/te\:chunked\\177\;do_chunked",
    455	=> "broken\/te\:chu\\177nked\;do_chunked",
    456	=> "broken\/te\:\\357\\273\\277chunked\;do_chunked",
    457	=> "broken\/te\:\\302\\204chunked\;do_chunked",
    458	=> "broken\/ce\:gz\\000ip\;do_gzip",
    459	=> "broken\/data\:Content\\000\-encoding\:gzip\\015\\012\;do_gzip",
    460	=> "broken\/ce\\000\:gzip\;do_gzip",
    461	=> "broken\/ce\\015\\012\\040\:gzip\;do_gzip",
    462	=> "broken\/ce\\015\\012\\040\:\\015\\012\\040gzip\;do_gzip",
    463	=> "broken\/ce\\013\:gzip\;do_gzip",
    464	=> "broken\/ce\\014\:gzip\;do_gzip",
    465	=> "broken\/ce\:\,gzip\;do_gzip",
    466	=> "broken\/ce\:\\073gzip\;do_gzip",
    467	=> "broken\/ce\:\\000gzip\;do_gzip",
    468	=> "broken\/ce\:\\013gzip\;do_gzip",
    469	=> "broken\/ce\:\\014gzip\;do_gzip",
    470	=> "broken\/ce\:\\240gzip\;do_gzip",
    471	=> "broken\/ce\:\\012\\000gzip\;do_gzip",
    472	=> "broken\/ce\:\\012\\013gzip\;do_gzip",
    473	=> "broken\/ce\:\\012\\014gzip\;do_gzip",
    474	=> "broken\/ce\:\\012\\240gzip\;do_gzip",
    475	=> "broken\/ce\:gzip\,\;do_gzip",
    476	=> "broken\/ce\:gzip\\073\;do_gzip",
    477	=> "broken\/ce\:gzip\\000\;do_gzip",
    478	=> "broken\/ce\:gzip\\013\;do_gzip",
    479	=> "broken\/ce\:gzip\\014\;do_gzip",
    480	=> "broken\/ce\:gzip\\240\;do_gzip",
    481	=> "broken\/ce\:def\\000late\;do_deflate",
    482	=> "broken\/data\:Content\\000\-encoding\:deflate\\015\\012\;do_deflate",
    483	=> "broken\/ce\\000\:deflate\;do_deflate",
    484	=> "broken\/ce\\015\\012\\040\:deflate\;do_deflate",
    485	=> "broken\/ce\\015\\012\\040\:\\015\\012\\040deflate\;do_deflate",
    486	=> "broken\/ce\\013\:deflate\;do_deflate",
    487	=> "broken\/ce\\014\:deflate\;do_deflate",
    488	=> "broken\/ce\:\,deflate\;do_deflate",
    489	=> "broken\/ce\:\\073deflate\;do_deflate",
    490	=> "broken\/ce\:\\000deflate\;do_deflate",
    491	=> "broken\/ce\:\\013deflate\;do_deflate",
    492	=> "broken\/ce\:\\014deflate\;do_deflate",
    493	=> "broken\/ce\:\\240deflate\;do_deflate",
    494	=> "broken\/ce\:deflate\,\;do_deflate",
    495	=> "broken\/ce\:\\012\\000deflate\;do_deflate",
    496	=> "broken\/ce\:\\012\\013deflate\;do_deflate",
    497	=> "broken\/ce\:\\012\\014deflate\;do_deflate",
    498	=> "broken\/ce\:\\012\\240deflate\;do_deflate",
    499	=> "broken\/ce\:deflate\\073\;do_deflate",
    500	=> "broken\/ce\:deflate\\000\;do_deflate",
    501	=> "broken\/ce\:deflate\\013\;do_deflate",
    502	=> "broken\/ce\:deflate\\014\;do_deflate",
    503	=> "broken\/ce\:deflate\\240\;do_deflate",
    504	=> "broken\/emptycont",
    505	=> "broken\/8bitkey",
    506	=> "broken\/colon",
    507	=> "broken\/data\:\\000",
    508	=> "broken\/177",
    509	=> "broken\/177\;only",
    510	=> "broken\/junkline",
    511	=> "broken\/spacehdr",
    512	=> "broken\/cr",
    513	=> "broken\/lf",
    514	=> "broken\/crcr",
    515	=> "broken\/lfcr",
    516	=> "broken\/code\-only",
    517	=> "broken\/http\-lower",
    518	=> "broken\/proto\:HTTP\/0\.9",
    519	=> "broken\/proto\:HTTP\/1\.10",
    520	=> "broken\/proto\:HTTP\/1\.00",
    521	=> "broken\/proto\:HTTP\/1\.01",
    522	=> "broken\/proto\:HTTP\/1\.2",
    523	=> "broken\/proto\:HTTP\/2\.0",
    524	=> "broken\/proto\:HTTP\/1\.1\-space",
    525	=> "broken\/proto\:HTTP\/1\.1\-tab",
    526	=> "broken\/proto\:HTTP\/1\.1\-cr",
    527	=> "broken\/proto\:HTTP\/1\.1\-lf",
    528	=> "broken\/proto\:space\-HTTP\/1\.1",
    529	=> "broken\/proto\:FTP\/1\.1",
    530	=> "broken\/proto\:ICY",
    531	=> "broken\/proto\:ICY\;gzip",
    532	=> "broken\/proto\:HTTP\\1\.1",
    533	=> "broken\/proto\:HTTP\/1\.010\;chunked",
    534	=> "broken\/proto\:HTTP\/1\.010\;chunked\;do_clen",
    535	=> "broken\/proto\:HTTP\/\+1\.\+1\;chunked",
    536	=> "broken\/proto\:HTTP\/\+1\.\+1\;chunked\;do_clen",
    537	=> "broken\/proto\:HTTP\/1A\.1B\;chunked",
    538	=> "broken\/proto\:HTTP\/1A\.1B\;chunked\;do_clen",
    539	=> "broken\/proto\:HTTP\/2\.B\;chunked",
    540	=> "broken\/proto\:HTTP\/2\.B\;chunked\;do_clen",
    541	=> "broken\/proto\:HTTP\/9\.\-1\;chunked",
    542	=> "broken\/proto\:HTTP\/9\.\-1\;chunked\;do_clen",
    543	=> "broken\/proto\:HTTP\/1\\040\.1\;chunked",
    544	=> "broken\/proto\:HTTP\/1\\040\.1\;chunked\;do_clen",
    545	=> "broken\/proto\:HTTP\/A\.B\;gzip",
    546	=> "broken\/status\:HTTP\/1\.1",
    547	=> "broken\/status\:HTTP\/1\.1\(cr\)Transfer\-Encoding\:chunked\;do_clen",
    548	=> "broken\/status\:HTTP\/1\.1\(cr\)Transfer\-Encoding\:chunked\;do_chunked",
    549	=> "broken\/status\:HTTP\/1\.1\(lf\)Transfer\-Encoding\:chunked\;do_clen",
    550	=> "broken\/status\:HTTP\/1\.1\(lf\)Transfer\-Encoding\:chunked\;do_chunked",
    551	=> "broken\/status\:HTTP\/1\.1\(cr\)\(lf\)Transfer\-Encoding\:chunked\;do_clen",
    552	=> "broken\/status\:HTTP\/1\.1\(cr\)\(lf\)Transfer\-Encoding\:chunked\;do_chunked",
    553	=> "broken\/status\:HTTP\/1\.1\(space\)200\(cr\)Transfer\-Encoding\:chunked\;do_clen",
    554	=> "broken\/status\:HTTP\/1\.1\(space\)200\(cr\)Transfer\-Encoding\:chunked\;do_chunked",
    555	=> "broken\/status\:HTTP\/1\.1\(space\)200\(lf\)Transfer\-Encoding\:chunked\;do_clen",
    556	=> "broken\/status\:HTTP\/1\.1\(space\)200\(lf\)Transfer\-Encoding\:chunked\;do_chunked",
    557	=> "broken\/status\:HTTP\/1\.1\(space\)200\(space\)\(cr\)Transfer\-Encoding\:chunked\;do_clen",
    558	=> "broken\/status\:HTTP\/1\.1\(space\)200\(space\)\(cr\)Transfer\-Encoding\:chunked\;do_chunked",
    559	=> "broken\/status\:HTTP\/1\.1\(space\)200\(space\)\(lf\)Transfer\-Encoding\:chunked\;do_clen",
    560	=> "broken\/status\:HTTP\/1\.1\(space\)200\(space\)\(lf\)Transfer\-Encoding\:chunked\;do_chunked",
    561	=> "broken\/status\:HTTP\/1\.1\(space\)200\(space\)ok\(cr\)Transfer\-Encoding\:chunked\;do_clen",
    562	=> "broken\/status\:HTTP\/1\.1\(space\)200\(space\)ok\(cr\)Transfer\-Encoding\:chunked\;do_chunked",
    563	=> "broken\/status\:HTTP\/1\.1\(space\)200\(space\)ok\(lf\)Transfer\-Encoding\:chunked\;do_clen",
    564	=> "broken\/status\:HTTP\/1\.1\(space\)200\(space\)ok\(lf\)Transfer\-Encoding\:chunked\;do_chunked",
    565	=> "broken\/status\:\\000HTTP\/1\.1\(space\)200\(space\)ok\;chunked",
    566	=> "broken\/status\:HTT\\000P\/1\.1\(space\)200\(space\)ok\;chunked",
    567	=> "broken\/status\:HTTP\/1\\000\.1\(space\)200\(space\)ok\;chunked",
    568	=> "broken\/status\:HTTP\/1\.1\\000\(space\)200\(space\)ok\;chunked",
    569	=> "broken\/status\:HTTP\/1\.1\(space\)2\\00000\(space\)ok\;chunked",
    570	=> "broken\/status\:HTTP\/1\.1\(space\)200\\000\(space\)ok\;chunked",
    571	=> "broken\/status\:HTTP\/1\.1\\000200\\000ok\;chunked",
    572	=> "broken\/status\:HTTP\/1\.1\\013200\\013ok\;chunked",
    573	=> "broken\/status\:HTTP\/1\.1\(space\)\-65336\(space\)\;chunked",
    574	=> "broken\/status\:HTTP\/1\.1foobar\;chunked",
    575	=> "broken\/status\:HTTP\/1\.1foobar\(cr\)Transfer\-Encoding\:chunked\;do_chunked",
    576	=> "broken\/status\:HTTP\/1\.foobar\;chunked",
    577	=> "broken\/status\:HTTP\/1foobar\;chunked",
    578	=> "broken\/status\:HTTP\/foobar\;chunked",
    579	=> "broken\/status\:HTTP\/\;chunked",
    580	=> "broken\/status\:HTTP\;chunked",
    581	=> "broken\/status\:HTTP\/1\.1\\011204\(space\)ok\;chunked",
    582	=> "broken\/status\:HTTP\/1\.1\\011304\(space\)ok\;chunked",
    583	=> "broken\/status\:HTTP\/1\.1\\040\\040\\040\\040204\(space\)ok\;chunked",
    584	=> "broken\/status\:HTTP\/1\.1\\040\\040\\040\\040304\(space\)ok\;chunked",
    585	=> "broken\/status\:HTTP\\1\.1\(space\)200\(space\)ok\;chunked",
    586	=> "broken\/status\:Transfer\-Encoding\:chunked\;do_clen",
    587	=> "broken\/status\:Transfer\-Encoding\:chunked\;do_chunked",
    588	=> "broken\/cr\-no\-crlf",
    589	=> "broken\/cr\-no\-crlf\;end\-crlflf",
    590	=> "broken\/cr\-no\-crlf\;end\-crlfcrlf",
    591	=> "broken\/lf\-no\-crlf",
    592	=> "broken\/crcr\-no\-crlf",
    593	=> "broken\/lfcr\-no\-crlf",
    594	=> "broken\/cr\\000lf\-no\-crlf",
    595	=> "broken\/chunked\;cr\-no\-crlf",
    596	=> "broken\/chunked\;cr\-no\-crlf\;end\-crlflf",
    597	=> "broken\/chunked\;cr\-no\-crlf\;end\-crlfcrlf",
    598	=> "broken\/chunked\;lf\-no\-crlf",
    599	=> "broken\/chunked\;crcr\-no\-crlf",
    600	=> "broken\/chunked\;crcr\-no\-crlf\;end\-crlfcrlf",
    601	=> "broken\/chunked\;lfcr\-no\-crlf",
    602	=> "broken\/chunked\;lfcr\-no\-crlf\;end\-crlfcrlf",
    603	=> "broken\/chunked\;cr\\000lf\-no\-crlf",
    604	=> "broken\/chunked\;lfcrcrlf\-no\-crlf\;end\-crlfcrlf",
    605	=> "broken\/end\-crcr",
    606	=> "broken\/end\-lflf",
    607	=> "broken\/end\-crlf\\000crlf",
    608	=> "broken\/end\-cr\\000crlf",
    609	=> "broken\/end\-lfcrlf",
    610	=> "broken\/end\-lfcrlf\;chunked",
    611	=> "broken\/end\-lfcrlf\;gzip",
    612	=> "broken\/end\-lfcrcrlf",
    613	=> "broken\/end\-lfcrcrlf\;chunked",
    614	=> "broken\/end\-lfcrcrlf\;gzip",
    615	=> "broken\/end\-lfcrcrlfcrlf",
    616	=> "broken\/end\-lfcrcrlfcrlf\;chunked",
    617	=> "broken\/end\-lfcrcrlfcrlf\;gzip",
    618	=> "broken\/end\-lf\\040lf",
    619	=> "broken\/end\-lf\\040lflf",
    620	=> "broken\/end\-crlf\\040crlfcrlf",
    621	=> "broken\/chunked\;end\-lf\\040lf",
    622	=> "broken\/chunked\;end\-lf\\040lflf",
    623	=> "broken\/chunked\;end\-crlf\\040crlfcrlf",
    624	=> "broken\/gzip\;end\-lf\\040lf",
    625	=> "broken\/gzip\;end\-lf\\040lflf",
    626	=> "broken\/gzip\;end\-crlf\\040crlfcrlf",
    627	=> "broken\/end\-lf\\040\.lf",
    628	=> "broken\/end\-lf\\011lf",
    629	=> "broken\/end\-lf\\011lflf",
    630	=> "broken\/end\-crlf\\011crlfcrlf",
    631	=> "broken\/chunked\;end\-lf\\011lf",
    632	=> "broken\/chunked\;end\-lf\\011lflf",
    633	=> "broken\/chunked\;end\-crlf\\011crlfcrlf",
    634	=> "broken\/gzip\;end\-lf\\011lf",
    635	=> "broken\/gzip\;end\-lf\\011lflf",
    636	=> "broken\/gzip\;end\-crlf\\011crlfcrlf",
    637	=> "broken\/end\-lf\\013lf",
    638	=> "broken\/end\-lf\\013lflf",
    639	=> "broken\/end\-crlf\\013crlfcrlf",
    640	=> "broken\/chunked\;end\-lf\\013lf",
    641	=> "broken\/chunked\;end\-lf\\013lflf",
    642	=> "broken\/chunked\;end\-crlf\\013crlfcrlf",
    643	=> "broken\/gzip\;end\-lf\\013lf",
    644	=> "broken\/gzip\;end\-lf\\013lflf",
    645	=> "broken\/gzip\;end\-crlf\\013crlfcrlf",
    646	=> "broken\/300",
    647	=> "broken\/301",
    648	=> "broken\/302",
    649	=> "broken\/303",
    650	=> "broken\/305",
    651	=> "broken\/307",
    652	=> "broken\/308",
    653	=> "broken\/100",
    654	=> "broken\/101",
    655	=> "broken\/102",
    656	=> "broken\/204",
    657	=> "broken\/205",
    658	=> "broken\/206",
    659	=> "broken\/304",
    660	=> "broken\/401",
    661	=> "broken\/407",
    662	=> "broken\/400",
    663	=> "broken\/403",
    664	=> "broken\/404",
    665	=> "broken\/406",
    666	=> "broken\/500",
    667	=> "broken\/502",
    668	=> "broken\/100\+",
    669	=> "broken\/100\+b",
    670	=> "broken\/16\-100\+",
    671	=> "broken\/16\-100\+b",
    672	=> "broken\/000",
    673	=> "broken\/600",
    674	=> "broken\/700",
    675	=> "broken\/800",
    676	=> "broken\/900",
    677	=> "broken\/2xx",
    678	=> "broken\/20x",
    679	=> "broken\/2",
    680	=> "broken\/20",
    681	=> "broken\/2000",
    682	=> "broken\/0200",
    683	=> "broken\/space\-200",
    684	=> "broken\/tab\-200",
    685	=> "broken\/299",
    686	=> "broken\/204\;chunked",
    687	=> "broken\/0204",
    688	=> "broken\/2040",
    689	=> "broken\/304\;chunked",
    690	=> "broken\/0304",
    691	=> "broken\/3040",
    692	=> "broken\/crlf\-header\;chunked",
    693	=> "broken\/crlf\-crlf\-header\;chunked",
    694	=> "broken\/space\-crlf\-header\;chunked",
    695	=> "broken\/space\-tab\-crlf\-header\;chunked",
    696	=> "broken\/space\-crlf\-tab\-crlf\-header\;chunked",
    697	=> "broken\/space\-tab\-cr\-crlf\-header\;chunked",
    698	=> "broken\/foobar\-crlf\-header\;chunked",
    699	=> "broken\/SIP\/2\.0\-space\-200\-space\-ok\-crlf\-header\;chunked",
    700	=> "broken\/space\-foobar\-crlf\-header\;chunked",
    701	=> "broken\/space\-SIP\/2\.0\-space\-200\-space\-ok\-crlf\-header\;chunked",
    702	=> "broken\/cr\-header\;chunked",
    703	=> "broken\/cr\-cr\-header\;chunked",
    704	=> "broken\/space\-cr\-header\;chunked",
    705	=> "broken\/lf\-header\;chunked",
    706	=> "broken\/lf\-lf\-header\;chunked",
    707	=> "broken\/space\-lf\-header\;chunked",
    708	=> "broken\/lfcr\-header\;chunked",
    709	=> "broken\/H\-header\;chunked",
    710	=> "broken\/HT\-header\;chunked",
    711	=> "broken\/HTT\-header\;chunked",
    712	=> "broken\/HTTX\-header\;chunked",
    713	=> "broken\/HTTXY\-header\;chunked",
    714	=> "mime\/single",
    715	=> "mime\/single\,ct64",
    716	=> "mime\/single\,ct64\,base64",
    717	=> "mime\/mixed",
    718	=> "mime\/mixed\,ct64\,base64",
    719	=> "mime\/related",
    720	=> "mime\/related\,ct64\,base64",
    721	=> "mime\/related\,mhtml",
    722	=> "mime\/mixed\,mhtml",
    723	=> "mime\/multi\-plain\,mhtml",
    724	=> "mime\/related\,mhtml\,base64",
    725	=> "mime\/mixed\,mhtml\,base64",
    726	=> "mime\/multi\-plain\,mhtml\,base64",
    727	=> "messagerfc822\/ok",
    728	=> "messagerfc822\/ce\:gzip",
    729	=> "messagerfc822\/rfc822",
    730	=> "messagerfc822\/cte\:base64\;rfc822",
    731	=> "messagerfc822\/ce\:gzip\;rfc822",
    732	=> "range\/full",
    733	=> "range\/range\,full",
    734	=> "range\/range",
    735	=> "range\/range\,incomplete",
    736	=> "chunked\/xte\,chunked\,xte\,do_clen",
    737	=> "chunked\/xte\,chunked\,xte\,clen\,do_clen",
    738	=> "broken\/data\:foo\:b\\001ar\\015\\012\;chunked",
    739	=> "broken\/data\:foo\:b\\001ar\\015\\012\;chunked\;do_clen",
    740	=> "broken\/data\:foo\:b\\000ar\\015\\012\;chunked",
    741	=> "broken\/data\:foo\:b\\000ar\\015\\012\;chunked\;do_clen",
    742	=> "broken\/data\:foo\:b\\200ar\\015\\012\;chunked",
    743	=> "broken\/data\:foo\:b\\200ar\\015\\012\;chunked\;do_clen",
    744	=> "broken\/conthdr\;chunked",
    745	=> "broken\/conthdr\;chunked\;do_clen",
    746	=> "broken\/end\-lflf\;chunked",
    747	=> "broken\/end\-lflf\;gzip",
    748	=> "broken\/te\:chu\\015\\012\\040nked\;do_chunked",
    749	=> "broken\/te\:chu\\015\\012\\040nked\;do_clen",
    750	=> "broken\/te\:chu\\015\\012nked\;do_chunked",
    751	=> "broken\/te\:chu\\015\\012nked\;do_clen",

}};

1;
