use strict;
use warnings;
use Test::More tests => 68;
use Digest::SHAvite3 qw(shavite3_224 shavite3_224_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::SHAvite3->new(224)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            shavite3_224_hex($data), $digest,
            "shavite3_224_hex: $len bits of $msg"
        );
        ok(
            shavite3_224($data) eq pack('H*', $digest),
            "shavite3_224: $len bits of $msg"
        );
    }

    my $md = Digest::SHAvite3->new(224)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

__DATA__
00|B33F761F0D3A86BB1051905AEC7A691BD0B5A24C3721F67D8E48D839
00|D4773C6DAFE49604B4DF73725512483DB17578CD209C27ABB39782D8
C0|15D9174CBD4D22F8C49FE874F45EBBF23806DEEC190B20BC67945833
C0|262C26AD4EDCD692FFB1B859CE729AD61BA67D6FA72AC7A7509D92E8
80|6FBD09FCE4600327A97540BFF4DF7A99DA7C13F8CB13FA39838EC010
48|7BDFCB04DDADB87D0DAA090BD7E7D218B6A339B4626830A9EEE5136C
50|A6FD948B4925FE0989984B2E67F370A5B9B5A0E84F7B176AF29FFC7F
98|1909DBD71D275AB4B217ACC7AE11045D09C024AC3AFC68D6DE9AD7DE
CC|47B8FEE436662CF2A3D3DA3AAE797319946CD3CDC31654F09217DC9C
9800|55D7EA1C0587E2404A30C083A18EF5349B8247C9E2F62465D4B3842E
9D40|437C66F9ABF8CB2F76011CDDAD29474CBA9C0055665273573D38B3FD
AA80|02D3679D11F4C5809E568EDB15FD6EF68B53E3CA29B0E4AF1E5ADBCD
9830|FAC99000D41E12C3D6AC7C24275E8CC620DA8178EFBF10B624117031
5030|343B462FA44E1E12F3EB72F90883E46C6E8BE92A9EF4C02B39369A03
4D24|D2817315CFF39BA98B5398C35BADABA7BFE79839BB17ADDB3B37B99A
CBDE|E43728694C2255F0E5E05F224CC9D1941B4B66CCEC388A8BE12997FB
41FB|3B94EB733AB02A2F7D590F8169FDE875C39A54648229F54E59087CC0
4FF400|C93E74C07F8CBB795865437DA775EE2B1A5C8BC8EA0DC85D7FE82A24
FD0440|4BEEB40DF12185F81E11D56A6CB1FE377D18426B3A6723483F0EF57F
424D00|FFD6A0199C047B793D2C1AA6FB9F7497D85CB64FF9836E496EC04D4A
3FDEE0|6ADF6DA6656DCE06201CC659CEC89703F04513CA6BD5C034429D0183
335768|CFE8321D32A7E290AAB0648CDA95A350990B9B8EA0966366AC0BEDD9
051E7C|EEC8DD6855B55EB6662A768ACA6D2583CD2DC5423FACEE974B5932BF
717F8C|931FA13C480D92306D9313315CB3AAA12411FA1C2E16B786CC7A4BF3
1F877C|623A1F7C9FA33D3A481C996C55E70F44EAA5DE42A58174BA5220D6D3
EB35CF80|FA13D4443DAEC866B8D679155C835D15A11782D2103528D932FFD867
B406C480|4979C3D2CA6E4A491D76BDD74E8D4E0D0DB5D0B9139A9B70F126A57A
CEE88040|3336B6124A787B17B1D38BCF76455FC3E148393CB9D89F31E053E562
C584DB70|C1E76353CDB31D8FA0881F5BB6D571F140BBD94EB983E2CDA320CB5C
53587BC8|5F7DB7B70ACD1F0E99115FE01B6D99CC95C3B514FE2F5EF585B517BB
69A305B0|283D97B75F0C46E76A73B2C0B484AFE4409E83FE50D302A29F4EFDB2
C9375ECE|1A449F9792A4DCD934D02DD7E61046022B27682801ED7D58EAFE1CAA
C1ECFDFC|E087F1B577D82808012C85E30192E37798E33023E4B3F066C034C836
8D73E8A280|E167AC7F485E1C057CCED2AD8D4B11EAD8E00E2D43430FD9F30523A2
06F2522080|B3868305B89D0B04C2452A11684C842243B6316041F23C3F4697D85E
3EF6C36F20|6E9BF84CB9366FA2A0BB05920721E287E352CE11D0EC458F3D23C48B
0127A1D340|0D8A93930B12BAEB2135A3EF376A17B789A90602484136517AC683AF
6A6AB6C210|8E53183EC67604319CACA5DF1FEC1181704E67720F78724925543BAD
AF3175E160|0FC108EE76D4378D0511FA3D9D70184045869045648140066B3FBD67
B66609ED86|544068E49374E2D987E54EAD59BF01C231AE946FEA67B416D0DC3080
21F134AC57|3343C5BF55A3435C21201BBFB5B4D7822A14ECADF8B9CBBBDC7E5F21
3DC2AADFFC80|84E113A1F81AEBFD959A97A7DFE19E4BDDAEF64B64306C7B24615229
9202736D2240|E5718D4BDD88002D51309A6BC32F78DBBAD6A57D51542CD8A5F1E335
F219BD629820|87072287E8B8294F780FF89C5F53E13D99E0EDFA76AFD6D791D58F0C
F3511EE2C4B0|2F011D5AF1B9839BEB22DCF8E5B9C6A208879ABDD68A248BE425A857
3ECAB6BF7720|59493B5CB447A4F153EB2564E6D7683892940AA886105F53560B3CED
CD62F688F498|351AC9F56294775853AA0145AB6DBB01A9F9E303D15686B72D4E52F7
C2CBAA33A9F8|EFE20751ABC06BDD5FB1D0F5D6B0F059DFC67D3C886698402832FCF7
C6F50BB74E29|A17B9E3495A5BE49CA3135E68AD769E1580165F24E12B4103D04B7CC
79F1B4CCC62A00|098BFB8DB888778A66EC356438C3DB90662285109F37F873F8D69A28
