# Generated by default/object.tt
package Paws::TimestreamQuery::Type;
  use Moose;
  has ArrayColumnInfo => (is => 'ro', isa => 'Paws::TimestreamQuery::ColumnInfo');
  has RowColumnInfo => (is => 'ro', isa => 'ArrayRef[Paws::TimestreamQuery::ColumnInfo]');
  has ScalarType => (is => 'ro', isa => 'Str');
  has TimeSeriesMeasureValueColumnInfo => (is => 'ro', isa => 'Paws::TimestreamQuery::ColumnInfo');

1;

### main pod documentation begin ###

=head1 NAME

Paws::TimestreamQuery::Type

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::TimestreamQuery::Type object:

  $service_obj->Method(Att1 => { ArrayColumnInfo => $value, ..., TimeSeriesMeasureValueColumnInfo => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::TimestreamQuery::Type object:

  $result = $service_obj->Method(...);
  $result->Att1->ArrayColumnInfo

=head1 DESCRIPTION

Contains the data type of a column in a query result set. The data type
can be scalar or complex. The supported scalar data types are integers,
boolean, string, double, timestamp, date, time, and intervals. The
supported complex data types are arrays, rows, and timeseries.

=head1 ATTRIBUTES


=head2 ArrayColumnInfo => L<Paws::TimestreamQuery::ColumnInfo>

Indicates if the column is an array.


=head2 RowColumnInfo => ArrayRef[L<Paws::TimestreamQuery::ColumnInfo>]

Indicates if the column is a row.


=head2 ScalarType => Str

Indicates if the column is of type string, integer, boolean, double,
timestamp, date, time.


=head2 TimeSeriesMeasureValueColumnInfo => L<Paws::TimestreamQuery::ColumnInfo>

Indicates if the column is a timeseries data type.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::TimestreamQuery>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

