# Generated by default/object.tt
package Paws::CodeGuruProfiler::Channel;
  use Moose;
  has EventPublishers => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'eventPublishers', traits => ['NameInRequest'], required => 1);
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest']);
  has Uri => (is => 'ro', isa => 'Str', request_name => 'uri', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeGuruProfiler::Channel

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeGuruProfiler::Channel object:

  $service_obj->Method(Att1 => { EventPublishers => $value, ..., Uri => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeGuruProfiler::Channel object:

  $result = $service_obj->Method(...);
  $result->Att1->EventPublishers

=head1 DESCRIPTION

Notification medium for users to get alerted for events that occur in
application profile. We support SNS topic as a notification channel.

=head1 ATTRIBUTES


=head2 B<REQUIRED> EventPublishers => ArrayRef[Str|Undef]

List of publishers for different type of events that may be detected in
an application from the profile. Anomaly detection is the only event
publisher in Profiler.


=head2 Id => Str

Unique identifier for each C<Channel> in the notification configuration
of a Profiling Group. A random UUID for channelId is used when adding a
channel to the notification configuration if not specified in the
request.


=head2 B<REQUIRED> Uri => Str

Unique arn of the resource to be used for notifications. We support a
valid SNS topic arn as a channel uri.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeGuruProfiler>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

