/*
 * Decompiled with CFR 0.152.
 */
package be.fivebyfive.lingua.stanfordcorenlp;

import be.fivebyfive.lingua.stanfordcorenlp.PipelineCoreference;
import be.fivebyfive.lingua.stanfordcorenlp.PipelineDependency;
import be.fivebyfive.lingua.stanfordcorenlp.PipelineDependencyList;
import be.fivebyfive.lingua.stanfordcorenlp.PipelineSentence;
import be.fivebyfive.lingua.stanfordcorenlp.PipelineSentenceList;
import be.fivebyfive.lingua.stanfordcorenlp.PipelineToken;
import be.fivebyfive.lingua.stanfordcorenlp.PipelineTokenList;
import edu.stanford.nlp.dcoref.CorefChain;
import edu.stanford.nlp.dcoref.CorefCoreAnnotations;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.semgraph.SemanticGraph;
import edu.stanford.nlp.trees.semgraph.SemanticGraphCoreAnnotations;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Pipeline {
    private StanfordCoreNLP pipeline = null;
    private boolean bidirectionalCorefs = false;
    private Properties props = null;

    public StanfordCoreNLP getPipeline() {
        return this.pipeline;
    }

    public Pipeline() {
        this(false);
    }

    public Pipeline(boolean bl) {
        this(bl, new Properties());
    }

    public Pipeline(boolean bl, Properties properties) {
        this.bidirectionalCorefs = bl;
        this.props = properties;
        if (this.props.isEmpty()) {
            properties.put("annotators", "tokenize, ssplit, pos, lemma, ner, parse, dcoref");
        }
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setProperties(Properties properties) {
        this.props = properties;
    }

    public void initPipeline() {
        this.pipeline = new StanfordCoreNLP(this.props, false);
    }

    public PipelineSentenceList process(String string) {
        ArrayList arrayList;
        List<PipelineToken> list;
        if (this.pipeline == null) {
            this.initPipeline();
        }
        PipelineSentenceList pipelineSentenceList = new PipelineSentenceList();
        Annotation annotation = new Annotation(string);
        if (annotation == null) {
            return null;
        }
        this.pipeline.annotate(annotation);
        for (Object object : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            String string2;
            String string4 = (String)object.get(CoreAnnotations.TextAnnotation.class);
            list = new PipelineTokenList();
            arrayList = new PipelineDependencyList();
            for (CoreLabel coreLabel : (List)object.get(CoreAnnotations.TokensAnnotation.class)) {
                String string3 = (String)coreLabel.get(CoreAnnotations.TextAnnotation.class);
                string2 = (String)coreLabel.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                String n = (String)coreLabel.get(CoreAnnotations.NamedEntityTagAnnotation.class);
                String n2 = (String)coreLabel.get(CoreAnnotations.LemmaAnnotation.class);
                ((ArrayList)list).add(new PipelineToken(string3, string2, n, n2));
            }
            SemanticGraph semanticGraph = (SemanticGraph)object.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class);
            if (semanticGraph != null) {
                for (String string3 : semanticGraph.edgeListSorted()) {
                    string2 = string3.getRelation();
                    int n = string3.getGovernor().index() - 1;
                    int n2 = string3.getDependent().index() - 1;
                    if (n >= 0 && n2 >= 0 && n < ((ArrayList)list).size() && n2 < ((ArrayList)list).size()) {
                        arrayList.add(new PipelineDependency((PipelineToken)((ArrayList)list).get(n), (PipelineToken)((ArrayList)list).get(n2), n, n2, (GrammaticalRelation)string2));
                        continue;
                    }
                    System.err.println("Index of " + string3.toString() + " out of range!");
                }
            }
            pipelineSentenceList.add(new PipelineSentence(string4, (PipelineTokenList)list, (PipelineDependencyList)arrayList));
        }
        Map map = (Map)annotation.get(CorefCoreAnnotations.CorefChainAnnotation.class);
        if (map != null) {
            for (String string4 : map.values()) {
                list = string4.getMentionsInTextualOrder();
                arrayList = new ArrayList();
                for (CorefChain.CorefMention n3 : list) {
                    arrayList.add(new int[]{n3.sentNum, n3.headIndex});
                }
                if (arrayList.size() <= 1) continue;
                int n = ((int[])arrayList.get(0))[0] - 1;
                int n3 = ((int[])arrayList.get(0))[1] - 1;
                int n4 = ((int[])arrayList.get(1))[0] - 1;
                int n5 = ((int[])arrayList.get(1))[1] - 1;
                if (n < 0 || n4 < 0 || n3 < 0 || n5 < 0 || n >= pipelineSentenceList.size() || n4 >= pipelineSentenceList.size() || n3 >= ((PipelineSentence)pipelineSentenceList.get(n)).getTokens().size() || n5 >= ((PipelineSentence)pipelineSentenceList.get(n4)).getTokens().size()) continue;
                ((PipelineSentence)pipelineSentenceList.get(n)).addCoreference(new PipelineCoreference(n, n4, n3, n5, (PipelineToken)((PipelineSentence)pipelineSentenceList.get(n)).getTokens().get(n3), (PipelineToken)((PipelineSentence)pipelineSentenceList.get(n4)).getTokens().get(n5)));
                if (!this.bidirectionalCorefs || n4 == n) continue;
                ((PipelineSentence)pipelineSentenceList.get(n4)).addCoreference(new PipelineCoreference(n4, n, n5, n3, (PipelineToken)((PipelineSentence)pipelineSentenceList.get(n4)).getTokens().get(n5), (PipelineToken)((PipelineSentence)pipelineSentenceList.get(n)).getTokens().get(n3)));
            }
        }
        return pipelineSentenceList;
    }
}

