/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.dcoref.Document;
import java.text.DecimalFormat;
import java.util.logging.Logger;

public abstract class CorefScorer {
    double precisionNumSum = 0.0;
    double precisionDenSum = 0.0;
    double recallNumSum = 0.0;
    double recallDenSum = 0.0;
    ScoreType scoreType;

    CorefScorer() {
    }

    public double getScore(SubScoreType subScoreType) {
        switch (subScoreType) {
            case Precision: {
                return this.getPrecision();
            }
            case Recall: {
                return this.getRecall();
            }
            case F1: {
                return this.getF1();
            }
        }
        throw new IllegalArgumentException("Unsupported subScoreType: " + (Object)((Object)subScoreType));
    }

    public double getPrecision() {
        return this.precisionNumSum / this.precisionDenSum;
    }

    public double getRecall() {
        return this.recallNumSum / this.recallDenSum;
    }

    public double getF1() {
        double p = this.getPrecision();
        double r = this.getRecall();
        return 2.0 * p * r / (p + r);
    }

    public void calculateScore(Document doc) {
        this.calculatePrecision(doc);
        this.calculateRecall(doc);
    }

    protected abstract void calculatePrecision(Document var1);

    protected abstract void calculateRecall(Document var1);

    public void printF1(Logger logger, boolean printF1First) {
        DecimalFormat nf = new DecimalFormat("0.000000");
        double r = this.getRecall();
        double p = this.getPrecision();
        double f1 = this.getF1();
        String R = nf.format(r);
        String P = nf.format(p);
        String F1 = nf.format(f1);
        DecimalFormat nf2 = new DecimalFormat("00.0");
        String RR = nf2.format(r * 100.0);
        String PP = nf2.format(p * 100.0);
        String F1F1 = nf2.format(f1 * 100.0);
        if (printF1First) {
            String str = "F1 = " + F1 + ", P = " + P + " (" + (int)this.precisionNumSum + "/" + (int)this.precisionDenSum + "), R = " + R + " (" + (int)this.recallNumSum + "/" + (int)this.recallDenSum + ")";
            if (this.scoreType == ScoreType.Pairwise) {
                logger.fine("Pairwise " + str);
            } else if (this.scoreType == ScoreType.BCubed) {
                logger.fine("B cube " + str);
            } else {
                logger.fine("MUC " + str);
            }
        } else {
            logger.fine("& " + PP + " & " + RR + " & " + F1F1);
        }
    }

    public void printF1(Logger logger) {
        this.printF1(logger, true);
    }

    static enum ScoreType {
        MUC,
        BCubed,
        Pairwise;

    }

    static enum SubScoreType {
        Recall,
        Precision,
        F1;

    }
}

