/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex.types;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.tokensregex.types.Value;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Tags
implements Serializable {
    Map<String, Value> tags;
    private static final long serialVersionUID = 2L;

    public Tags(String ... tags) {
        if (tags != null) {
            this.tags = new HashMap<String, Value>();
            for (String tag : tags) {
                this.tags.put(tag, null);
            }
        }
    }

    public Collection<String> getTags() {
        return this.tags.keySet();
    }

    public boolean hasTag(String tag) {
        return this.tags != null ? this.tags.containsKey(tag) : false;
    }

    public void addTag(String tag) {
        this.addTag(tag, null);
    }

    public void addTag(String tag, Value v) {
        if (this.tags == null) {
            this.tags = new HashMap<String, Value>(1);
        }
        this.tags.put(tag, v);
    }

    public void removeTag(String tag) {
        if (this.tags != null) {
            this.tags.remove(tag);
        }
    }

    public Value getTag(String tag) {
        return this.tags != null ? this.tags.get(tag) : null;
    }

    public static class TagsAnnotation
    implements CoreAnnotation<Tags> {
        @Override
        public Class<Tags> getType() {
            return Tags.class;
        }
    }
}

