/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.objectbank.TokenizerFactory;
import edu.stanford.nlp.process.AbstractTokenizer;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.process.WhitespaceTokenizer;
import edu.stanford.nlp.process.WordSegmenter;
import java.io.Reader;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public class WordSegmentingTokenizer
extends AbstractTokenizer<HasWord> {
    private Iterator<HasWord> wordIter;
    private Tokenizer<CoreLabel> tok;
    private WordSegmenter wordSegmenter;

    public WordSegmentingTokenizer(WordSegmenter segmenter, Reader r) {
        this(segmenter, WhitespaceTokenizer.newCoreLabelWhitespaceTokenizer(r));
    }

    public WordSegmentingTokenizer(WordSegmenter segmenter, Tokenizer<CoreLabel> tokenizer) {
        this.wordSegmenter = segmenter;
        this.tok = tokenizer;
    }

    @Override
    protected HasWord getNext() {
        while (this.wordIter == null || !this.wordIter.hasNext()) {
            if (!this.tok.hasNext()) {
                return null;
            }
            String s = this.tok.next().word();
            if (s == null) {
                return null;
            }
            List<HasWord> se = this.wordSegmenter.segment(s);
            this.wordIter = se.iterator();
        }
        return this.wordIter.next();
    }

    public static TokenizerFactory<HasWord> factory(WordSegmenter wordSegmenter) {
        return new WordSegmentingTokenizerFactory(wordSegmenter);
    }

    private static class WordSegmentingTokenizerFactory
    implements TokenizerFactory<HasWord>,
    Serializable {
        private static final long serialVersionUID = -4697961121607489828L;
        private WordSegmenter segmenter;

        public WordSegmentingTokenizerFactory(WordSegmenter wordSegmenter) {
            this.segmenter = wordSegmenter;
        }

        @Override
        public Iterator<HasWord> getIterator(Reader r) {
            return this.getTokenizer(r);
        }

        @Override
        public Tokenizer<HasWord> getTokenizer(Reader r) {
            return new WordSegmentingTokenizer(this.segmenter, r);
        }

        @Override
        public Tokenizer<HasWord> getTokenizer(Reader r, String extraOptions) {
            this.setOptions(extraOptions);
            return this.getTokenizer(r);
        }

        @Override
        public void setOptions(String options) {
        }
    }
}

