/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.arabic;

import edu.stanford.nlp.international.arabic.ArabicMorphoFeatureSpecification;
import edu.stanford.nlp.international.arabic.process.ArabicTokenizer;
import edu.stanford.nlp.international.morph.MorphoFeatureSpecification;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.objectbank.TokenizerFactory;
import edu.stanford.nlp.trees.AbstractTreebankLanguagePack;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.international.arabic.ArabicHeadFinder;
import edu.stanford.nlp.trees.international.arabic.ArabicTreeReaderFactory;

public class ArabicTreebankLanguagePack
extends AbstractTreebankLanguagePack {
    private static final long serialVersionUID = 9081305982861675328L;
    private static final String[] collinsPunctTags = new String[]{"PUNC"};
    private static final String[] pennPunctTags = new String[]{"PUNC"};
    private static final String[] pennPunctWords = new String[]{".", "\"", ",", "-LRB-", "-RRB-", "-", ":", "/", "?", "_", "*", "%", "!", ">", "-PLUS-", "...", ";", "..", "&", "=", "\u0631", "'", "\\", "`", "......"};
    private static final String[] pennSFPunctTags = new String[]{"PUNC"};
    private static final String[] pennSFPunctWords = new String[]{".", "!", "?"};
    private static final char[] annotationIntroducingChars = new char[]{'-', '=', '|', '#', '^', '~'};
    private static final String[] pennStartSymbols = new String[]{"ROOT"};
    private TokenizerFactory<? extends HasWord> tf = ArabicTokenizer.atbFactory();

    @Override
    public String[] punctuationTags() {
        return pennPunctTags;
    }

    @Override
    public String[] punctuationWords() {
        return pennPunctWords;
    }

    @Override
    public String[] sentenceFinalPunctuationTags() {
        return pennSFPunctTags;
    }

    @Override
    public String[] sentenceFinalPunctuationWords() {
        return pennSFPunctWords;
    }

    @Override
    public String[] evalBIgnoredPunctuationTags() {
        return collinsPunctTags;
    }

    @Override
    public char[] labelAnnotationIntroducingCharacters() {
        return annotationIntroducingChars;
    }

    @Override
    public String[] startSymbols() {
        return pennStartSymbols;
    }

    @Override
    public TokenizerFactory<? extends HasWord> getTokenizerFactory() {
        return this.tf;
    }

    @Override
    public String treebankFileExtension() {
        return "tree";
    }

    @Override
    public TreeReaderFactory treeReaderFactory() {
        return new ArabicTreeReaderFactory();
    }

    public String toString() {
        return "ArabicTreebankLanguagePack";
    }

    @Override
    public HeadFinder headFinder() {
        return new ArabicHeadFinder(this);
    }

    @Override
    public HeadFinder typedDependencyHeadFinder() {
        return new ArabicHeadFinder(this);
    }

    @Override
    public MorphoFeatureSpecification morphFeatureSpec() {
        return new ArabicMorphoFeatureSpecification();
    }

    public static void main(String[] args) {
        String[] strs;
        PennTreebankLanguagePack tlp = new PennTreebankLanguagePack();
        System.out.println("Start symbol: " + tlp.startSymbol());
        String start = tlp.startSymbol();
        System.out.println("Should be true: " + tlp.isStartSymbol(start));
        for (String str : strs = new String[]{"-", "-LLB-", "NP-2", "NP=3", "NP-LGS", "NP-TMP=3"}) {
            System.out.println("String: " + str + " basic: " + tlp.basicCategory(str) + " basicAndFunc: " + tlp.categoryAndFunction(str));
        }
    }
}

