package Graphics::Grid::ViewportLike;

# ABSTRACT: Role for Viewport and ViewportTree

use Graphics::Grid::Role;

our $VERSION = '0.001'; # VERSION

use Types::Standard qw(Str);

use Graphics::Grid::Types qw(:all);
use Graphics::Grid::Unit;



has name => (
    is      => 'ro',
    isa     => Str,
    lazy    => 1,
    builder => '_build_name',
);

with qw(
  Graphics::Grid::HasGPar
);

method _uid($prefix='GRID.VP') {
    state $idx = 0;
    my $name = "$prefix.$idx";
    $idx++;
    return $name;
}

method _build_name() {
    return $self->_uid('GRID.VP');
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Graphics::Grid::ViewportLike - Role for Viewport and ViewportTree

=head1 VERSION

version 0.001

=head1 DESCRIPTION

This module is a role used by Viewport and ViewportTree.

=head1 ATTRIBUTES

=head2 gp

An object of L<Graphics::Grid::GPar>. Default is an empty gpar object.

=head2 name

A string to uniquely identify the viewport once it has been pushed onto the
viewport tree. If not specified, it would be assigned automatically.

=head1 SEE ALSO

L<Graphics::Grid>

=head1 AUTHOR

Stephan Loyd <sloyd@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018-2023 by Stephan Loyd.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
