/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import opennlp.common.parse.Rule;
import opennlp.common.parse.RuleGroup;
import opennlp.common.synsem.Category;
import opennlp.grok.expression.CatReader;
import opennlp.grok.expression.VarCat;
import opennlp.grok.grammar.BackwardApplication;
import opennlp.grok.grammar.BackwardComposition;
import opennlp.grok.grammar.BackwardTypeRaising;
import opennlp.grok.grammar.CustomRuleGroup;
import opennlp.grok.grammar.ForwardApplication;
import opennlp.grok.grammar.ForwardComposition;
import opennlp.grok.grammar.ForwardTypeRaising;
import opennlp.grok.grammar.GenericRule;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class RuleReader {
    public static RuleGroup getRules(String filename) {
        try {
            if (filename == null) {
                return new CustomRuleGroup();
            }
            return RuleReader.getRules(new URL(filename).openStream());
        }
        catch (IOException e) {
            System.out.println("Problem loading rules file: " + filename);
            e.printStackTrace();
            return new CustomRuleGroup();
        }
    }

    public static RuleGroup getRules(InputStream istr) {
        CustomRuleGroup rules = new CustomRuleGroup();
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(istr);
            List entries = doc.getRootElement().getChildren();
            int i = 0;
            while (i < entries.size()) {
                Element ruleEl = (Element)entries.get(i);
                String active = ruleEl.getAttributeValue("active");
                if (active == null || active.equals("true")) {
                    String dir;
                    String type = ruleEl.getName();
                    if (type.equals("application")) {
                        dir = ruleEl.getAttributeValue("dir");
                        if (dir.equals("forward")) {
                            rules.addRule(new ForwardApplication());
                        } else {
                            rules.addRule(new BackwardApplication());
                        }
                    } else if (type.equals("composition")) {
                        dir = ruleEl.getAttributeValue("dir");
                        String harmonic = ruleEl.getAttributeValue("harmonic");
                        boolean isHarmonic = new Boolean(harmonic);
                        if (dir.equals("forward")) {
                            rules.addRule(new ForwardComposition(isHarmonic));
                        } else {
                            rules.addRule(new BackwardComposition(isHarmonic));
                        }
                    } else if (type.equals("typeraising")) {
                        VarCat argVar = (VarCat)CatReader.getCat((Element)ruleEl.getChild("argVar").getChildren().get(0));
                        VarCat resultVar = (VarCat)CatReader.getCat((Element)ruleEl.getChild("resultVar").getChildren().get(0));
                        String dir2 = ruleEl.getAttributeValue("dir");
                        if (dir2.equals("forward")) {
                            rules.addRule(new ForwardTypeRaising(argVar, resultVar));
                        } else {
                            rules.addRule(new BackwardTypeRaising(argVar, resultVar));
                        }
                    } else if (type.equals("rule")) {
                        rules.addRule(RuleReader.getRule(ruleEl));
                    } else {
                        throw new JDOMException("Invalid element in rules: " + type);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return rules;
        }
        return rules;
    }

    private static Rule getRule(Element el) {
        String rname = el.getAttributeValue("name");
        List arguments = el.getChild("args").getChildren();
        Category[] args = new Category[arguments.size()];
        int i = 0;
        while (i < args.length) {
            args[i] = CatReader.getCat((Element)arguments.get(i));
            ++i;
        }
        Category result = CatReader.getCat((Element)el.getChild("result").getChildren().get(0));
        return new GenericRule(args, result, rname);
    }
}

