/*
 * Decompiled with CFR 0.152.
 */
package gma;

import gma.AxisTick;

public class MapPoint
implements Comparable {
    private AxisTick xAxisTick = null;
    private AxisTick yAxisTick = null;
    private double displacement = Double.NaN;

    public MapPoint(AxisTick xAxisTick, AxisTick yAxisTick) {
        this.xAxisTick = xAxisTick;
        this.yAxisTick = yAxisTick;
    }

    public AxisTick getXAxisTick() {
        return this.xAxisTick;
    }

    public AxisTick getYAxisTick() {
        return this.yAxisTick;
    }

    public boolean isConflict(MapPoint pointToCompare) {
        if (this.xAxisTick.equals(pointToCompare.getXAxisTick()) && this.yAxisTick.equals(pointToCompare.getYAxisTick())) {
            return false;
        }
        return this.xAxisTick.equals(pointToCompare.getXAxisTick()) || this.yAxisTick.equals(pointToCompare.getYAxisTick());
    }

    public int isMaxMapPoint(MapPoint mapPoint, boolean xAxisCompare) {
        if (xAxisCompare) {
            return this.xAxisTick.isMaxAxisTick(mapPoint.getXAxisTick());
        }
        return this.yAxisTick.isMaxAxisTick(mapPoint.getYAxisTick());
    }

    public void computeDisplacement(double slope) {
        double ratio = Math.sin(Math.atan(slope));
        this.displacement = ((double)this.yAxisTick.getPosition() / slope - (double)this.xAxisTick.getPosition()) * ratio;
    }

    public double getDisplacement() {
        return this.displacement;
    }

    public int compareTo(Object mapPoint) {
        return this.isMaxMapPoint((MapPoint)mapPoint, true);
    }

    public boolean equals(Object compareMapPoint) {
        return this.xAxisTick.equals(((MapPoint)compareMapPoint).getXAxisTick()) && this.yAxisTick.equals(((MapPoint)compareMapPoint).getYAxisTick());
    }

    public String toString() {
        return this.xAxisTick.toString() + " " + this.yAxisTick.toString();
    }
}

