/*
 * THIS FILE IS AUTO-GENERATED BY ExtUtils::XSOne
 * DO NOT EDIT DIRECTLY - edit files in lib/Acme/ExtUtils/XSOne/Test/ instead
 *
 * Generated from:
 *   _header.xs
 *   Calculator/Basic.xs
 *   Calculator/Memory.xs
 *   Calculator/Scientific.xs
 *   Calculator/Trig.xs
 *   _footer.xs
 */

/* ========== COMBINED C PREAMBLE ========== */

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include <math.h>
#include <stdlib.h>

#define PERL_NO_GET_CONTEXT
#define MAX_MEMORY_SLOTS 10
#define MAX_HISTORY 100

/* C code from: _header.xs */
#line 1 "lib/Acme/ExtUtils/XSOne/Test/_header.xs"
/*
 * Acme::ExtUtils::XSOne::Test::Calculator - A demonstration of ExtUtils::XSOne
 *
 * This header file contains shared state and helper functions
 * accessible from all Calculator submodules.
 */



/* ========== Shared State ========== */

/* Memory for storing calculation results */
static double memory_slots[MAX_MEMORY_SLOTS];
static int memory_initialized = 0;

/* Calculation history */
typedef struct {
    char operation;     /* +, -, *, /, ^, r (root), etc. */
    double operand1;
    double operand2;
    double result;
} HistoryEntry;

static HistoryEntry history[MAX_HISTORY];
static int history_count = 0;

/* Last result (ANS functionality) */
static double last_result = 0.0;

/* ========== Helper Functions ========== */

static void init_memory(void) {
    if (!memory_initialized) {
        for (int i = 0; i < MAX_MEMORY_SLOTS; i++) {
            memory_slots[i] = 0.0;
        }
        memory_initialized = 1;
    }
}

static void add_to_history(char op, double a, double b, double result) {
    if (history_count < MAX_HISTORY) {
        history[history_count].operation = op;
        history[history_count].operand1 = a;
        history[history_count].operand2 = b;
        history[history_count].result = result;
        history_count++;
    }
    last_result = result;
}

static double get_last_result(void) {
    return last_result;
}

static int store_memory(int slot, double value) {
    init_memory();
    if (slot < 0 || slot >= MAX_MEMORY_SLOTS) {
        return 0;
    }
    memory_slots[slot] = value;
    return 1;
}

static double recall_memory(int slot) {
    init_memory();
    if (slot < 0 || slot >= MAX_MEMORY_SLOTS) {
        return 0.0;
    }
    return memory_slots[slot];
}

static void clear_all_memory(void) {
    for (int i = 0; i < MAX_MEMORY_SLOTS; i++) {
        memory_slots[i] = 0.0;
    }
    history_count = 0;
    last_result = 0.0;
}

/* ========== Generic Import Helper ========== */

/*
 * export_sub - Export a subroutine from source package to caller's namespace
 * src_pkg: source package name (e.g., "Acme::ExtUtils::XSOne::Test::Calculator::Basic")
 * name: function name (e.g., "add")
 * caller: caller's package name
 */
static void export_sub(pTHX_ const char *src_pkg, const char *name, const char *caller) {
    GV *src_gv;
    GV *dst_gv;
    CV *cv;
    SV *src_name;
    SV *dst_name;

    /* Build fully qualified source name */
    src_name = newSVpvf("%s::%s", src_pkg, name);

    /* Get the source CV */
    src_gv = gv_fetchpv(SvPV_nolen(src_name), 0, SVt_PVCV);
    SvREFCNT_dec(src_name);

    if (!src_gv || !GvCV(src_gv)) {
        croak("\"%s\" is not defined in package %s", name, src_pkg);
    }
    cv = GvCV(src_gv);

    /* Build fully qualified destination name */
    dst_name = newSVpvf("%s::%s", caller, name);

    /* Install in caller's namespace */
    dst_gv = gv_fetchpv(SvPV_nolen(dst_name), GV_ADD, SVt_PVCV);
    SvREFCNT_dec(dst_name);

    if (dst_gv) {
        SvREFCNT_inc((SV*)cv);
        GvCV_set(dst_gv, cv);
    }
}

/*
 * do_import - Generic import handler
 * pkg: the package being imported from
 * exports: array of exportable function names
 * export_count: number of exports
 * items: number of arguments to import()
 * ax: argument stack offset
 *
 * Call from import() like:
 *   static const char *basic_exports[] = {"add", "subtract", ...};
 *   do_import(aTHX_ "...::Basic", basic_exports, 10, items, ax);
 */
static void do_import(pTHX_ const char *pkg, const char **exports, int export_count, I32 items, I32 ax) {
    const char *caller;
    int i, j;

    /* Get caller's package name */
    caller = CopSTASHPV(PL_curcop);
    if (!caller || !*caller) {
        caller = "main";
    }

    /* Process import list (skip first arg which is the package name) */
    for (i = 1; i < items; i++) {
        SV *arg = ST(i);
        const char *name;
        STRLEN name_len;
        int found = 0;

        name = SvPV(arg, name_len);

        /* Find the export */
        for (j = 0; j < export_count; j++) {
            if (strcmp(name, exports[j]) == 0) {
                export_sub(aTHX_ pkg, name, caller);
                found = 1;
                break;
            }
        }

        if (!found) {
            croak("\"%s\" is not exported by the %s module", name, pkg);
        }
    }
}
/* C code from: Calculator/Basic.xs */
#line 1 "lib/Acme/ExtUtils/XSOne/Test/Calculator/Basic.xs"
/*
 * Acme::ExtUtils::XSOne::Test::Calculator::Basic - Basic arithmetic operations
 */


/* C helper functions for Basic package */
static double basic_safe_divide(double a, double b, int *error) {
    if (b == 0.0) {
        *error = 1;
        return 0.0;
    }
    *error = 0;
    return a / b;
}

static double basic_clamp(double value, double min_val, double max_val) {
    if (value < min_val) return min_val;
    if (value > max_val) return max_val;
    return value;
}

static double basic_percent(double value, double percent) {
    return value * percent / 100.0;
}
/* C code from: Calculator/Memory.xs */
#line 1 "lib/Acme/ExtUtils/XSOne/Test/Calculator/Memory.xs"
/*
 * Acme::ExtUtils::XSOne::Test::Calculator::Memory - Memory and history functions
 *
 * This module accesses the shared state defined in _header.xs
 */

/* Memory package helpers - need access to memory_slots */
static int mem_is_valid_slot(int slot) {
    return (slot >= 0 && slot < MAX_MEMORY_SLOTS);
}

static int mem_get_used_slots(void) {
    int count = 0;
    for (int i = 0; i < MAX_MEMORY_SLOTS; i++) {
        if (memory_slots[i] != 0.0) count++;
    }
    return count;
}

static double mem_sum_all(void) {
    double sum = 0.0;
    for (int i = 0; i < MAX_MEMORY_SLOTS; i++) {
        sum += memory_slots[i];
    }
    return sum;
}

static void mem_add_to_slot(int slot, double value) {
    if (mem_is_valid_slot(slot)) {
        memory_slots[slot] += value;
    }
}
/* C code from: Calculator/Scientific.xs */
#line 1 "lib/Acme/ExtUtils/XSOne/Test/Calculator/Scientific.xs"
/*
 * Acme::ExtUtils::XSOne::Test::Calculator::Scientific - Scientific/advanced operations
 */


/* C helper functions for Scientific package */
static double sci_safe_log(double a, int *error) {
    if (a <= 0.0) {
        *error = 1;
        return 0.0;
    }
    *error = 0;
    return log(a);
}

static double sci_safe_sqrt(double a, int *error) {
    if (a < 0.0) {
        *error = 1;
        return 0.0;
    }
    *error = 0;
    return sqrt(a);
}

static double sci_ipow(double base, int exp) {
    /* Integer power - faster than pow() for integer exponents */
    if (exp == 0) return 1.0;
    int neg = 0;
    if (exp < 0) {
        neg = 1;
        exp = -exp;
    }
    double result = 1.0;
    while (exp > 0) {
        if (exp & 1) result *= base;
        base *= base;
        exp >>= 1;
    }
    return neg ? 1.0 / result : result;
}

static double sci_combination(int n, int r) {
    if (r > n || r < 0) return 0.0;
    if (r == 0 || r == n) return 1.0;
    double result = 1.0;
    for (int i = 0; i < r; i++) {
        result = result * (n - i) / (i + 1);
    }
    return result;
}
/* C code from: Calculator/Trig.xs */
#line 1 "lib/Acme/ExtUtils/XSOne/Test/Calculator/Trig.xs"
/*
 * Acme::ExtUtils::XSOne::Test::Calculator::Trig - Trigonometric functions
 */


/* C helper functions for Trig package */
static double trig_normalize_angle(double radians) {
    /* Normalize angle to [-PI, PI] */
    while (radians > M_PI) radians -= 2.0 * M_PI;
    while (radians < -M_PI) radians += 2.0 * M_PI;
    return radians;
}

static int trig_is_valid_asin_arg(double x) {
    return (x >= -1.0 && x <= 1.0);
}

static double trig_sec(double x) {
    return 1.0 / cos(x);
}

static double trig_csc(double x) {
    return 1.0 / sin(x);
}

static double trig_cot(double x) {
    return cos(x) / sin(x);
}
/* C code from: _footer.xs */
#line 1 "lib/Acme/ExtUtils/XSOne/Test/_footer.xs"
/*
 * Acme::ExtUtils::XSOne::Test::Calculator - Main module and BOOT section
 */
/* ========== END COMBINED C PREAMBLE ========== */

MODULE = Acme::ExtUtils::XSOne::Test::Calculator    PACKAGE = Acme::ExtUtils::XSOne::Test::Calculator::Basic

PROTOTYPES: DISABLE

double
add(a, b)
    double a
    double b
CODE:
    RETVAL = a + b;
    add_to_history('+', a, b, RETVAL);
OUTPUT:
    RETVAL

double
subtract(a, b)
    double a
    double b
CODE:
    RETVAL = a - b;
    add_to_history('-', a, b, RETVAL);
OUTPUT:
    RETVAL

double
multiply(a, b)
    double a
    double b
CODE:
    RETVAL = a * b;
    add_to_history('*', a, b, RETVAL);
OUTPUT:
    RETVAL

double
divide(a, b)
    double a
    double b
CODE:
    if (b == 0.0) {
        croak("Division by zero");
    }
    RETVAL = a / b;
    add_to_history('/', a, b, RETVAL);
OUTPUT:
    RETVAL

double
modulo(a, b)
    double a
    double b
CODE:
    if (b == 0.0) {
        croak("Modulo by zero");
    }
    RETVAL = fmod(a, b);
    add_to_history('%', a, b, RETVAL);
OUTPUT:
    RETVAL

double
negate(a)
    double a
CODE:
    RETVAL = -a;
    add_to_history('n', a, 0, RETVAL);
OUTPUT:
    RETVAL

double
absolute(a)
    double a
CODE:
    RETVAL = fabs(a);
    add_to_history('a', a, 0, RETVAL);
OUTPUT:
    RETVAL

double
safe_divide(a, b)
    double a
    double b
CODE:
    int error;
    RETVAL = basic_safe_divide(a, b, &error);
    if (error) {
        RETVAL = 0.0;  /* Return 0 instead of croak */
    }
    add_to_history('/', a, b, RETVAL);
OUTPUT:
    RETVAL

double
clamp(value, min_val, max_val)
    double value
    double min_val
    double max_val
CODE:
    RETVAL = basic_clamp(value, min_val, max_val);
OUTPUT:
    RETVAL

double
percent(value, pct)
    double value
    double pct
CODE:
    RETVAL = basic_percent(value, pct);
    add_to_history('%', value, pct, RETVAL);
OUTPUT:
    RETVAL

void
import(...)
CODE:
{
    static const char *basic_exports[] = {
        "add", "subtract", "multiply", "divide", "modulo",
        "negate", "absolute", "safe_divide", "clamp", "percent"
    };
    do_import(aTHX_ "Acme::ExtUtils::XSOne::Test::Calculator::Basic",
              basic_exports, 10, items, ax);
}


MODULE = Acme::ExtUtils::XSOne::Test::Calculator    PACKAGE = Acme::ExtUtils::XSOne::Test::Calculator::Memory

PROTOTYPES: DISABLE

int
store(slot, value)
    int slot
    double value
CODE:
    RETVAL = store_memory(slot, value);
    if (!RETVAL) {
        warn("Invalid memory slot %d (valid: 0-%d)", slot, MAX_MEMORY_SLOTS - 1);
    }
OUTPUT:
    RETVAL

double
recall(slot)
    int slot
CODE:
    if (slot < 0 || slot >= MAX_MEMORY_SLOTS) {
        warn("Invalid memory slot %d (valid: 0-%d)", slot, MAX_MEMORY_SLOTS - 1);
        RETVAL = 0.0;
    } else {
        RETVAL = recall_memory(slot);
    }
OUTPUT:
    RETVAL

void
clear()
CODE:
    clear_all_memory();

double
ans()
CODE:
    RETVAL = get_last_result();
OUTPUT:
    RETVAL

int
history_count()
CODE:
    RETVAL = history_count;
OUTPUT:
    RETVAL

void
get_history_entry(index)
    int index
PPCODE:
    if (index < 0 || index >= history_count) {
        croak("Invalid history index %d (valid: 0-%d)", index, history_count - 1);
    }
    EXTEND(SP, 4);
    PUSHs(sv_2mortal(newSVpvf("%c", history[index].operation)));
    PUSHs(sv_2mortal(newSVnv(history[index].operand1)));
    PUSHs(sv_2mortal(newSVnv(history[index].operand2)));
    PUSHs(sv_2mortal(newSVnv(history[index].result)));

int
max_memory_slots()
CODE:
    RETVAL = MAX_MEMORY_SLOTS;
OUTPUT:
    RETVAL

int
max_history_entries()
CODE:
    RETVAL = MAX_HISTORY;
OUTPUT:
    RETVAL

int
is_valid_slot(slot)
    int slot
CODE:
    RETVAL = mem_is_valid_slot(slot);
OUTPUT:
    RETVAL

int
used_slots()
CODE:
    RETVAL = mem_get_used_slots();
OUTPUT:
    RETVAL

double
sum_all_slots()
CODE:
    RETVAL = mem_sum_all();
OUTPUT:
    RETVAL

void
add_to(slot, value)
    int slot
    double value
CODE:
    mem_add_to_slot(slot, value);

void
import(...)
CODE:
{
    static const char *memory_exports[] = {
        "store", "recall", "clear", "ans",
        "history_count", "get_history_entry",
        "max_memory_slots", "max_history_entries",
        "is_valid_slot", "used_slots", "sum_all_slots", "add_to"
    };
    do_import(aTHX_ "Acme::ExtUtils::XSOne::Test::Calculator::Memory",
              memory_exports, 12, items, ax);
}


MODULE = Acme::ExtUtils::XSOne::Test::Calculator    PACKAGE = Acme::ExtUtils::XSOne::Test::Calculator::Scientific

PROTOTYPES: DISABLE

double
power(base, exp)
    double base
    double exp
CODE:
    RETVAL = pow(base, exp);
    add_to_history('^', base, exp, RETVAL);
OUTPUT:
    RETVAL

double
sqrt_val(a)
    double a
CODE:
    if (a < 0.0) {
        croak("Cannot take square root of negative number");
    }
    RETVAL = sqrt(a);
    add_to_history('r', a, 0.5, RETVAL);
OUTPUT:
    RETVAL

double
cbrt_val(a)
    double a
CODE:
    RETVAL = cbrt(a);
    add_to_history('r', a, 1.0/3.0, RETVAL);
OUTPUT:
    RETVAL

double
nth_root(a, n)
    double a
    double n
CODE:
    if (n == 0.0) {
        croak("Cannot take 0th root");
    }
    if (a < 0.0 && fmod(n, 2.0) == 0.0) {
        croak("Cannot take even root of negative number");
    }
    RETVAL = pow(a, 1.0/n);
    add_to_history('r', a, n, RETVAL);
OUTPUT:
    RETVAL

double
log_natural(a)
    double a
CODE:
    if (a <= 0.0) {
        croak("Cannot take log of non-positive number");
    }
    RETVAL = log(a);
    add_to_history('l', a, M_E, RETVAL);
OUTPUT:
    RETVAL

double
log10_val(a)
    double a
CODE:
    if (a <= 0.0) {
        croak("Cannot take log of non-positive number");
    }
    RETVAL = log10(a);
    add_to_history('L', a, 10, RETVAL);
OUTPUT:
    RETVAL

double
log_base(a, base)
    double a
    double base
CODE:
    if (a <= 0.0 || base <= 0.0 || base == 1.0) {
        croak("Invalid logarithm arguments");
    }
    RETVAL = log(a) / log(base);
    add_to_history('L', a, base, RETVAL);
OUTPUT:
    RETVAL

double
exp_val(a)
    double a
CODE:
    RETVAL = exp(a);
    add_to_history('e', a, 0, RETVAL);
OUTPUT:
    RETVAL

double
factorial(n)
    int n
CODE:
    if (n < 0) {
        croak("Cannot take factorial of negative number");
    }
    if (n > 170) {
        croak("Factorial overflow (max 170)");
    }
    RETVAL = 1.0;
    for (int i = 2; i <= n; i++) {
        RETVAL *= i;
    }
    add_to_history('!', (double)n, 0, RETVAL);
OUTPUT:
    RETVAL

double
ipow(base, exp)
    double base
    int exp
CODE:
    RETVAL = sci_ipow(base, exp);
    add_to_history('^', base, (double)exp, RETVAL);
OUTPUT:
    RETVAL

double
safe_sqrt(a)
    double a
CODE:
    int error;
    RETVAL = sci_safe_sqrt(a, &error);
    if (!error) {
        add_to_history('r', a, 0.5, RETVAL);
    }
OUTPUT:
    RETVAL

double
safe_log(a)
    double a
CODE:
    int error;
    RETVAL = sci_safe_log(a, &error);
    if (!error) {
        add_to_history('l', a, M_E, RETVAL);
    }
OUTPUT:
    RETVAL

double
combination(n, r)
    int n
    int r
CODE:
    RETVAL = sci_combination(n, r);
    add_to_history('C', (double)n, (double)r, RETVAL);
OUTPUT:
    RETVAL

double
permutation(n, r)
    int n
    int r
CODE:
    if (r > n || r < 0 || n < 0) {
        RETVAL = 0.0;
    } else {
        RETVAL = sci_combination(n, r);
        for (int i = 2; i <= r; i++) {
            RETVAL *= i;
        }
    }
    add_to_history('P', (double)n, (double)r, RETVAL);
OUTPUT:
    RETVAL

void
import(...)
CODE:
{
    static const char *scientific_exports[] = {
        "power", "sqrt_val", "cbrt_val", "nth_root",
        "log_natural", "log10_val", "log_base", "exp_val",
        "factorial", "ipow", "safe_sqrt", "safe_log",
        "combination", "permutation"
    };
    do_import(aTHX_ "Acme::ExtUtils::XSOne::Test::Calculator::Scientific",
              scientific_exports, 14, items, ax);
}


MODULE = Acme::ExtUtils::XSOne::Test::Calculator    PACKAGE = Acme::ExtUtils::XSOne::Test::Calculator::Trig

PROTOTYPES: DISABLE

double
sin_val(a)
    double a
CODE:
    RETVAL = sin(a);
    add_to_history('s', a, 0, RETVAL);
OUTPUT:
    RETVAL

double
cos_val(a)
    double a
CODE:
    RETVAL = cos(a);
    add_to_history('c', a, 0, RETVAL);
OUTPUT:
    RETVAL

double
tan_val(a)
    double a
CODE:
    RETVAL = tan(a);
    add_to_history('t', a, 0, RETVAL);
OUTPUT:
    RETVAL

double
asin_val(a)
    double a
CODE:
    if (a < -1.0 || a > 1.0) {
        croak("asin argument must be in [-1, 1]");
    }
    RETVAL = asin(a);
    add_to_history('S', a, 0, RETVAL);
OUTPUT:
    RETVAL

double
acos_val(a)
    double a
CODE:
    if (a < -1.0 || a > 1.0) {
        croak("acos argument must be in [-1, 1]");
    }
    RETVAL = acos(a);
    add_to_history('C', a, 0, RETVAL);
OUTPUT:
    RETVAL

double
atan_val(a)
    double a
CODE:
    RETVAL = atan(a);
    add_to_history('T', a, 0, RETVAL);
OUTPUT:
    RETVAL

double
atan2_val(y, x)
    double y
    double x
CODE:
    RETVAL = atan2(y, x);
    add_to_history('A', y, x, RETVAL);
OUTPUT:
    RETVAL

double
deg_to_rad(degrees)
    double degrees
CODE:
    RETVAL = degrees * M_PI / 180.0;
OUTPUT:
    RETVAL

double
rad_to_deg(radians)
    double radians
CODE:
    RETVAL = radians * 180.0 / M_PI;
OUTPUT:
    RETVAL

double
hypot_val(a, b)
    double a
    double b
CODE:
    RETVAL = hypot(a, b);
    add_to_history('h', a, b, RETVAL);
OUTPUT:
    RETVAL

double
normalize_angle(radians)
    double radians
CODE:
    RETVAL = trig_normalize_angle(radians);
OUTPUT:
    RETVAL

double
sec_val(a)
    double a
CODE:
    RETVAL = trig_sec(a);
    add_to_history('E', a, 0, RETVAL);
OUTPUT:
    RETVAL

double
csc_val(a)
    double a
CODE:
    RETVAL = trig_csc(a);
    add_to_history('O', a, 0, RETVAL);
OUTPUT:
    RETVAL

double
cot_val(a)
    double a
CODE:
    RETVAL = trig_cot(a);
    add_to_history('G', a, 0, RETVAL);
OUTPUT:
    RETVAL

int
is_valid_asin_arg(x)
    double x
CODE:
    RETVAL = trig_is_valid_asin_arg(x);
OUTPUT:
    RETVAL

void
import(...)
CODE:
{
    static const char *trig_exports[] = {
        "sin_val", "cos_val", "tan_val",
        "asin_val", "acos_val", "atan_val", "atan2_val",
        "deg_to_rad", "rad_to_deg", "hypot_val",
        "normalize_angle", "sec_val", "csc_val", "cot_val",
        "is_valid_asin_arg"
    };
    do_import(aTHX_ "Acme::ExtUtils::XSOne::Test::Calculator::Trig",
              trig_exports, 15, items, ax);
}


MODULE = Acme::ExtUtils::XSOne::Test::Calculator    PACKAGE = Acme::ExtUtils::XSOne::Test::Calculator

PROTOTYPES: DISABLE

double
pi()
CODE:
    RETVAL = M_PI;
OUTPUT:
    RETVAL

double
e()
CODE:
    RETVAL = M_E;
OUTPUT:
    RETVAL

const char *
version()
CODE:
    RETVAL = "0.01";
OUTPUT:
    RETVAL

BOOT:
    /* Initialize memory on module load */
    init_memory();

