/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CyclicCoreLabel;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.LabeledWord;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.trees.Constituent;
import edu.stanford.nlp.trees.ConstituentFactory;
import edu.stanford.nlp.trees.Dependency;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Labeled;
import edu.stanford.nlp.trees.LabeledScoredTreeReaderFactory;
import edu.stanford.nlp.trees.NamedDependency;
import edu.stanford.nlp.trees.SimpleConstituentFactory;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.UnnamedDependency;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Filters;
import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.MutableInteger;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Scored;
import edu.stanford.nlp.util.StringUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Tree
extends AbstractCollection<Tree>
implements Label,
Labeled,
Scored,
Serializable,
Iterable<Tree> {
    private static final long serialVersionUID = 5441849457648722744L;
    private double score = Double.NaN;
    public static final Tree[] EMPTY_TREE_ARRAY = new Tree[0];
    private static final int initialPrintStringBuilderSize = 500;
    private static final int indentIncr = 2;
    public static boolean DISPLAY_SCORES = true;

    public boolean isLeaf() {
        Tree[] kids = this.children();
        return kids.length == 0;
    }

    public int numChildren() {
        return this.children().length;
    }

    public boolean isUnaryRewrite() {
        return this.numChildren() == 1;
    }

    public boolean isPreTerminal() {
        Tree[] kids = this.children();
        return kids.length == 1 && kids[0].isLeaf();
    }

    public boolean isPrePreTerminal() {
        Tree[] kids = this.children();
        if (kids.length == 0) {
            return false;
        }
        for (Tree kid : kids) {
            if (kid.isPreTerminal()) continue;
            return false;
        }
        return true;
    }

    public boolean isPhrasal() {
        Tree[] kids = this.children();
        return kids != null && kids.length != 0 && (kids.length != 1 || !kids[0].isLeaf());
    }

    @Override
    public boolean equals(Object o) {
        Tree[] theirkids;
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tree)) {
            return false;
        }
        Tree t = (Tree)o;
        if (!this.label().equals(t.label())) {
            return false;
        }
        Tree[] mykids = this.children();
        if (mykids.length != (theirkids = t.children()).length) {
            return false;
        }
        for (int i = 0; i < mykids.length; ++i) {
            if (mykids[i].equals(theirkids[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        Label l = this.label();
        int hc = l == null ? 1 : l.hashCode();
        Tree[] kids = this.children();
        for (int i = 0; i < kids.length; ++i) {
            l = kids[i].label();
            int hc2 = l == null ? i : l.hashCode();
            hc ^= hc2 << i;
        }
        return hc;
    }

    public int indexOf(Tree tree) {
        Tree[] kids = this.children();
        for (int i = 0; i < kids.length; ++i) {
            if (!kids[i].equals(tree)) continue;
            return i;
        }
        return -1;
    }

    public abstract Tree[] children();

    public List<Tree> getChildrenAsList() {
        return new ArrayList<Tree>(Arrays.asList(this.children()));
    }

    public void setChildren(Tree[] children) {
        throw new UnsupportedOperationException();
    }

    public void setChildren(List<? extends Tree> childTreesList) {
        if (childTreesList == null || childTreesList.isEmpty()) {
            this.setChildren(EMPTY_TREE_ARRAY);
        } else {
            int leng = childTreesList.size();
            Tree[] childTrees = new Tree[leng];
            childTreesList.toArray(childTrees);
            this.setChildren(childTrees);
        }
    }

    @Override
    public Label label() {
        return null;
    }

    @Override
    public void setLabel(Label label) {
    }

    @Override
    public double score() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public Tree firstChild() {
        Tree[] kids = this.children();
        if (kids.length == 0) {
            return null;
        }
        return kids[0];
    }

    public Tree lastChild() {
        Tree[] kids = this.children();
        if (kids.length == 0) {
            return null;
        }
        return kids[kids.length - 1];
    }

    public Tree upperMostUnary(Tree root) {
        Tree parent = this.parent(root);
        if (parent == null) {
            return this;
        }
        if (parent.numChildren() > 1) {
            return this;
        }
        return parent.upperMostUnary(root);
    }

    public void setSpans() {
        this.constituentsNodes(0);
    }

    public IntPair getSpan() {
        return (IntPair)((CyclicCoreLabel)this.label()).get(CoreAnnotations.SpanAnnotation.class);
    }

    public Set<Constituent> constituents() {
        return this.constituents(new SimpleConstituentFactory());
    }

    public Set<Constituent> constituents(ConstituentFactory cf) {
        return this.constituents(cf, false);
    }

    public Set<Constituent> constituents(ConstituentFactory cf, boolean charLevel) {
        HashSet<Constituent> constituentsSet = new HashSet<Constituent>();
        this.constituents(constituentsSet, 0, cf, charLevel);
        return constituentsSet;
    }

    private int constituentsNodes(int left) {
        if (this.isLeaf()) {
            CyclicCoreLabel l = (CyclicCoreLabel)this.label();
            l.set(CoreAnnotations.SpanAnnotation.class, new IntPair(left, left));
            return left + 1;
        }
        int position = left;
        Tree[] kids = this.children();
        for (int i = 0; i < kids.length; ++i) {
            position = kids[i].constituentsNodes(position);
        }
        CyclicCoreLabel l = (CyclicCoreLabel)this.label();
        l.set(CoreAnnotations.SpanAnnotation.class, new IntPair(left, position - 1));
        return position;
    }

    private int constituents(Set<Constituent> constituentsSet, int left, ConstituentFactory cf, boolean charLevel) {
        if (this.isPreTerminal()) {
            return left + (charLevel ? this.firstChild().label().value().length() : 1);
        }
        int position = left;
        Tree[] kids = this.children();
        for (int i = 0; i < kids.length; ++i) {
            position = kids[i].constituents(constituentsSet, position, cf, charLevel);
        }
        constituentsSet.add(cf.newConstituent(left, position - 1, this.label(), this.score()));
        return position;
    }

    public Tree localTree() {
        Tree[] kids = this.children();
        Tree[] newKids = new Tree[kids.length];
        TreeFactory tf = this.treeFactory();
        int n = kids.length;
        for (int i = 0; i < n; ++i) {
            newKids[i] = tf.newTreeNode(kids[i].label(), Arrays.asList(EMPTY_TREE_ARRAY));
        }
        return tf.newTreeNode(this.label(), Arrays.asList(newKids));
    }

    public Set<Tree> localTrees() {
        HashSet<Tree> set = new HashSet<Tree>();
        for (Tree st : this) {
            if (!st.isPhrasal()) continue;
            set.add(st.localTree());
        }
        return set;
    }

    public String toStructureDebugString() {
        String leafLabels = null;
        String tagLabels = null;
        String phraseLabels = null;
        String leaves = null;
        String nodes = null;
        for (Tree st : this) {
            Label lab;
            if (st.isPhrasal()) {
                if (nodes == null) {
                    nodes = StringUtils.getShortClassName(st);
                } else if (!nodes.equals(StringUtils.getShortClassName(st))) {
                    nodes = "mixed";
                }
                lab = st.label();
                if (phraseLabels == null) {
                    if (lab == null) {
                        phraseLabels = "null";
                        continue;
                    }
                    phraseLabels = StringUtils.getShortClassName(lab);
                    continue;
                }
                if (phraseLabels.equals(StringUtils.getShortClassName(lab))) continue;
                phraseLabels = "mixed";
                continue;
            }
            if (st.isPreTerminal()) {
                if (nodes == null) {
                    nodes = StringUtils.getShortClassName(st);
                } else if (!nodes.equals(StringUtils.getShortClassName(st))) {
                    nodes = "mixed";
                }
                lab = st.label();
                if (tagLabels == null) {
                    if (lab == null) {
                        tagLabels = "null";
                        continue;
                    }
                    tagLabels = StringUtils.getShortClassName(lab);
                    continue;
                }
                if (tagLabels.equals(StringUtils.getShortClassName(lab))) continue;
                tagLabels = "mixed";
                continue;
            }
            if (st.isLeaf()) {
                if (leaves == null) {
                    leaves = StringUtils.getShortClassName(st);
                } else if (!leaves.equals(StringUtils.getShortClassName(st))) {
                    leaves = "mixed";
                }
                lab = st.label();
                if (leafLabels == null) {
                    if (lab == null) {
                        leafLabels = "null";
                        continue;
                    }
                    leafLabels = StringUtils.getShortClassName(lab);
                    continue;
                }
                if (leafLabels.equals(StringUtils.getShortClassName(lab))) continue;
                leafLabels = "mixed";
                continue;
            }
            throw new IllegalStateException("Bad tree: " + this);
        }
        return "Tree with " + nodes + " interior nodes and " + leaves + " leaves, and " + phraseLabels + " phrase labels, " + tagLabels + " tag labels, and " + leafLabels + " leaf labels.";
    }

    public StringBuilder toStringBuilder(StringBuilder sb) {
        return this.toStringBuilder(sb, false);
    }

    public StringBuilder toStringBuilder(StringBuilder sb, boolean printOnlyLabelValue) {
        Tree[] kids;
        sb.append('(');
        if (this.label() != null) {
            if (printOnlyLabelValue) {
                sb.append(this.label().value());
            } else {
                sb.append(this.label());
            }
        }
        if ((kids = this.children()) != null) {
            for (Tree kid : kids) {
                sb.append(' ');
                kid.toStringBuilder(sb, printOnlyLabelValue);
            }
        }
        return sb.append(')');
    }

    @Override
    public String toString() {
        return this.toStringBuilder(new StringBuilder(500)).toString();
    }

    private static String makeIndentString(int indent) {
        StringBuilder sb = new StringBuilder(indent);
        for (int i = 0; i < 2; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public void printLocalTree() {
        this.printLocalTree(new PrintWriter(System.out, true));
    }

    public void printLocalTree(PrintWriter pw) {
        pw.print("(" + this.label() + ' ');
        for (Tree kid : this.children()) {
            pw.print("(");
            pw.print(kid.label());
            pw.print(") ");
        }
        pw.println(")");
    }

    public void indentedListPrint() {
        this.indentedListPrint(new PrintWriter(System.out, true), false);
    }

    public void indentedListPrint(PrintWriter pw, boolean printScores) {
        this.indentedListPrint("", Tree.makeIndentString(2), pw, printScores);
    }

    private void indentedListPrint(String indent, String pad, PrintWriter pw, boolean printScores) {
        StringBuilder sb = new StringBuilder(indent);
        Label label = this.label();
        if (label != null) {
            sb.append(((Object)label).toString());
        }
        if (printScores) {
            sb.append("  ");
            sb.append(this.score());
        }
        pw.println(sb.toString());
        Tree[] children = this.children();
        String newIndent = indent + pad;
        int n = children.length;
        for (int i = 0; i < n; ++i) {
            children[i].indentedListPrint(newIndent, pad, pw, printScores);
        }
    }

    private static void displayChildren(Tree[] trChildren, int indent, boolean parentLabelNull, PrintWriter pw) {
        boolean firstSibling = true;
        boolean leftSibIsPreTerm = true;
        for (Tree currentTree : trChildren) {
            currentTree.display(indent, parentLabelNull, firstSibling, leftSibIsPreTerm, false, pw);
            leftSibIsPreTerm = currentTree.isPreTerminal();
            if (currentTree.label() != null && ((Object)currentTree.label()).toString() != null && ((Object)currentTree.label()).toString().startsWith("CC")) {
                leftSibIsPreTerm = false;
            }
            firstSibling = false;
        }
    }

    public String nodeString() {
        if (this.label() != null && ((Object)this.label()).toString() != null) {
            return ((Object)this.label()).toString();
        }
        return "";
    }

    private void display(int indent, boolean parentLabelNull, boolean firstSibling, boolean leftSiblingPreTerminal, boolean topLevel, PrintWriter pw) {
        boolean suppressIndent;
        boolean bl = suppressIndent = parentLabelNull || firstSibling && this.isPreTerminal() || leftSiblingPreTerminal && this.isPreTerminal() && (this.label() == null || !((Object)this.label()).toString().startsWith("CC"));
        if (suppressIndent) {
            pw.print(" ");
        } else {
            if (!topLevel) {
                pw.println();
            }
            for (int i = 0; i < indent; ++i) {
                pw.print("  ");
            }
        }
        if (this.isLeaf() || this.isPreTerminal()) {
            pw.print(this.toString());
            pw.flush();
            return;
        }
        pw.print("(");
        pw.print(this.nodeString());
        Tree.displayChildren(this.children(), indent + 1, this.label() == null || ((Object)this.label()).toString() == null, pw);
        pw.print(")");
        pw.flush();
    }

    public void pennPrint(PrintWriter pw) {
        this.display(0, false, false, false, true, pw);
        pw.println();
        pw.flush();
    }

    public void pennPrint(PrintStream ps) {
        this.pennPrint(new PrintWriter((Writer)new OutputStreamWriter(ps), true));
    }

    public String pennString() {
        StringWriter sw = new StringWriter();
        this.pennPrint(new PrintWriter(sw));
        return sw.toString();
    }

    public void pennPrint() {
        this.pennPrint(System.out);
    }

    public int depth() {
        Tree[] kids;
        if (this.isLeaf()) {
            return 0;
        }
        int maxDepth = 0;
        for (Tree kid : kids = this.children()) {
            int curDepth = kid.depth();
            if (curDepth <= maxDepth) continue;
            maxDepth = curDepth;
        }
        return maxDepth + 1;
    }

    public int depth(Tree node) {
        Tree p = node.parent(this);
        if (this == node) {
            return 0;
        }
        if (p == null) {
            return -1;
        }
        int depth = 1;
        while (this != p) {
            p = p.parent(this);
            ++depth;
        }
        return depth;
    }

    public Tree headTerminal(HeadFinder hf, Tree parent) {
        if (this.isLeaf()) {
            return this;
        }
        Tree head = hf.determineHead(this, parent);
        if (head != null) {
            return head.headTerminal(hf, parent);
        }
        System.err.println("Head is null: " + this);
        return null;
    }

    public Tree headTerminal(HeadFinder hf) {
        return this.headTerminal(hf, null);
    }

    public Tree headPreTerminal(HeadFinder hf) {
        if (this.isPreTerminal()) {
            return this;
        }
        if (this.isLeaf()) {
            throw new IllegalArgumentException("Called headPreTerminal on a leaf: " + this);
        }
        Tree head = hf.determineHead(this);
        if (head != null) {
            return head.headPreTerminal(hf);
        }
        System.err.println("Head preterminal is null: " + this);
        return null;
    }

    public void percolateHeads(HeadFinder hf) {
        Label cwt = this.label();
        if (this.isLeaf()) {
            HasWord w;
            if (cwt instanceof HasWord && (w = (HasWord)((Object)cwt)).word() == null) {
                w.setWord(cwt.value());
            }
        } else {
            Tree[] kids = this.children();
            for (int i = 0; i < kids.length; ++i) {
                kids[i].percolateHeads(hf);
            }
            Tree head = hf.determineHead(this);
            if (head != null) {
                Label headCwt = head.label();
                String headTag = null;
                if (headCwt instanceof HasTag) {
                    headTag = ((HasTag)((Object)headCwt)).tag();
                }
                if (headTag == null && head.isLeaf()) {
                    headTag = cwt.value();
                }
                String headWord = null;
                if (headCwt instanceof HasWord) {
                    headWord = ((HasWord)((Object)headCwt)).word();
                }
                if (headWord == null && head.isLeaf()) {
                    headWord = headCwt.value();
                }
                if (cwt instanceof HasWord) {
                    ((HasWord)((Object)cwt)).setWord(headWord);
                }
                if (cwt instanceof HasTag) {
                    ((HasTag)((Object)cwt)).setTag(headTag);
                }
            } else {
                System.err.println("Head is null: " + this);
            }
        }
    }

    public Set<Dependency<Label, Label, Object>> dependencies() {
        return this.dependencies(Filters.<Dependency<Label, Label, Object>>acceptFilter());
    }

    public Set<Dependency<Label, Label, Object>> dependencies(Filter<Dependency<Label, Label, Object>> f) {
        return this.dependencies(f, null);
    }

    public Set<Dependency<Label, Label, Object>> dependencies(HeadFinder hf) {
        return this.dependencies(Filters.<Dependency<Label, Label, Object>>acceptFilter(), hf);
    }

    public Set<Dependency<Label, Label, Object>> dependencies(Filter<Dependency<Label, Label, Object>> f, HeadFinder hf) {
        HashSet<Dependency<Label, Label, Object>> deps = new HashSet<Dependency<Label, Label, Object>>();
        for (Tree node : this.subTrees()) {
            if (node.isLeaf() || node.children().length < 2) continue;
            Label l = node.label();
            Word w = null;
            if (hf != null) {
                Tree hwt = node.headTerminal(hf);
                if (hwt != null) {
                    w = new Word(hwt.label());
                }
            } else if (l instanceof HasWord) {
                w = new Word(((HasWord)((Object)l)).word());
            }
            Tree[] kids = node.children();
            boolean seenHead = false;
            for (int cNum = 0; cNum < kids.length; ++cNum) {
                Tree child = kids[cNum];
                Label dl = child.label();
                Word dw = null;
                if (hf != null) {
                    Tree dwt = child.headTerminal(hf);
                    if (dwt != null) {
                        dw = new Word(dwt.label());
                    }
                } else if (dl instanceof HasWord) {
                    dw = new Word(((HasWord)((Object)dl)).word());
                }
                if (w != null && w.word() != null && dw != null && w.word().equals(dw.word()) && !seenHead) {
                    seenHead = true;
                    continue;
                }
                UnnamedDependency p = new UnnamedDependency(w, dw);
                if (!f.accept(p)) continue;
                deps.add(p);
            }
        }
        return deps;
    }

    public Set<Dependency<Label, Label, Object>> taggedDependencies() {
        return this.taggedDependencies(Filters.<Dependency<Label, Label, Object>>acceptFilter());
    }

    public Set<Dependency<Label, Label, Object>> taggedDependencies(Filter<Dependency<Label, Label, Object>> f) {
        HashSet<Dependency<Label, Label, Object>> deps = new HashSet<Dependency<Label, Label, Object>>();
        for (Tree node : this) {
            if (node.isLeaf() || node.children().length < 2) continue;
            Label l = node.label();
            TaggedWord tw = null;
            if (l instanceof HasWord && l instanceof HasTag) {
                tw = new TaggedWord(((HasWord)((Object)l)).word(), ((HasTag)((Object)l)).tag());
            }
            boolean seenHead = false;
            for (Tree child : node.children()) {
                Label dl = child.label();
                Word dtw = null;
                if (dl instanceof HasWord && dl instanceof HasTag) {
                    dtw = new TaggedWord(((HasWord)((Object)dl)).word(), ((HasTag)((Object)dl)).tag());
                }
                if (tw != null && tw.word() != null && dtw != null && tw.word().equals(dtw.word()) && tw.tag().equals(((TaggedWord)dtw).tag()) && !seenHead) {
                    seenHead = true;
                    continue;
                }
                UnnamedDependency p = new UnnamedDependency(tw, dtw);
                if (!f.accept(p)) continue;
                deps.add(p);
            }
        }
        return deps;
    }

    public Set<Dependency<Label, Label, Object>> taggedDependencies(HeadFinder hf) {
        return this.taggedDependencies(Filters.<Dependency<Label, Label, Object>>acceptFilter(), hf);
    }

    public Set<Dependency<Label, Label, Object>> taggedDependencies(Filter<Dependency<Label, Label, Object>> f, HeadFinder hf) {
        HashSet<Dependency<Label, Label, Object>> deps = new HashSet<Dependency<Label, Label, Object>>();
        for (Tree node : this) {
            if (node.isLeaf() || node.children().length < 2) continue;
            Label l = node.label();
            TaggedWord w = null;
            if (hf != null) {
                Tree hwt = node.headPreTerminal(hf);
                if (hwt != null) {
                    w = new TaggedWord(hwt.children()[0].label(), hwt.label());
                }
            } else if (l instanceof HasWord && l instanceof HasTag) {
                w = new TaggedWord(((HasWord)((Object)l)).word(), ((HasTag)((Object)l)).tag());
            }
            boolean seenHead = false;
            for (Tree child : node.children()) {
                Label dl = child.label();
                TaggedWord dw = null;
                if (hf != null) {
                    Tree dwt = child.headPreTerminal(hf);
                    if (dwt != null) {
                        dw = new TaggedWord(dwt.children()[0].label(), dwt.label());
                    }
                } else if (dl instanceof HasWord && dl instanceof HasTag) {
                    dw = new TaggedWord(((HasWord)((Object)dl)).word(), ((HasTag)((Object)dl)).tag());
                }
                if (w != null && w.word() != null && w.tag() != null && dw != null && w.word().equals(dw.word()) && w.tag().equals(dw.tag()) && !seenHead) {
                    seenHead = true;
                    continue;
                }
                UnnamedDependency p = new UnnamedDependency(w, dw);
                if (!f.accept(p)) continue;
                deps.add(p);
            }
        }
        return deps;
    }

    public Set<Dependency<Label, Label, Object>> mapDependencies(Filter<Dependency<Label, Label, Object>> f, HeadFinder hf) {
        if (hf == null) {
            throw new IllegalArgumentException("mapDependencies: need headfinder");
        }
        HashSet<Dependency<Label, Label, Object>> deps = new HashSet<Dependency<Label, Label, Object>>();
        for (Tree node : this) {
            if (node.isLeaf() || node.children().length < 2) continue;
            Tree hwt = node.headTerminal(hf);
            if (hwt == null) {
                throw new IllegalStateException("mapDependencies: headFinder failed!");
            }
            for (Tree child : node.children()) {
                UnnamedDependency p;
                Tree dwt = child.headTerminal(hf);
                if (dwt == null) {
                    throw new IllegalStateException("mapDependencies: headFinder failed!");
                }
                if (dwt == hwt || !f.accept(p = new UnnamedDependency(hwt.label(), dwt.label()))) continue;
                deps.add(p);
            }
        }
        return deps;
    }

    public Set<Dependency<Label, Label, Object>> mapDependencies(Filter<Dependency<Label, Label, Object>> f, HeadFinder hf, String rootName) {
        Set<Dependency<Label, Label, Object>> deps = this.mapDependencies(f, hf);
        if (rootName != null) {
            Label hl = this.headTerminal(hf).label();
            CyclicCoreLabel rl = new CyclicCoreLabel();
            rl.set(CoreAnnotations.WordAnnotation.class, rootName);
            rl.set(CoreAnnotations.IndexAnnotation.class, 0);
            deps.add(new NamedDependency(rl, hl, (Object)rootName));
        }
        return deps;
    }

    public <X extends HasWord> Sentence<X> yield() {
        return this.yield(new Sentence());
    }

    public <X extends HasWord> Sentence<X> yield(Sentence<X> y) {
        if (this.isLeaf()) {
            Label lab = this.label();
            if (lab instanceof HasWord) {
                y.add((HasWord)((Object)lab));
            } else {
                y.add(new Word(lab));
            }
        } else {
            Tree[] kids = this.children();
            for (int i = 0; i < kids.length; ++i) {
                kids[i].yield(y);
            }
        }
        return y;
    }

    public <T> List<T> yield(List<T> y) {
        if (this.isLeaf()) {
            y.add(this.label());
        } else {
            Tree[] kids = this.children();
            for (int i = 0; i < kids.length; ++i) {
                kids[i].yield(y);
            }
        }
        return y;
    }

    public Sentence<TaggedWord> taggedYield() {
        return this.taggedYield(new Sentence());
    }

    public List<LabeledWord> labeledYield() {
        return this.labeledYield(new ArrayList<LabeledWord>());
    }

    public <X extends List<TaggedWord>> X taggedYield(X ty) {
        Tree[] kids = this.children();
        if (kids.length == 1 && kids[0].isLeaf()) {
            ty.add((TaggedWord)new TaggedWord(kids[0].label(), this.label()));
        } else {
            for (Tree kid : kids) {
                kid.taggedYield(ty);
            }
        }
        return ty;
    }

    public List<LabeledWord> labeledYield(List<LabeledWord> ty) {
        Tree[] kids = this.children();
        if (kids.length == 1 && kids[0].isLeaf()) {
            ty.add(new LabeledWord(kids[0].label(), this.label()));
        } else {
            for (Tree kid : kids) {
                kid.labeledYield(ty);
            }
        }
        return ty;
    }

    public List<Label> preTerminalYield() {
        return this.preTerminalYield(new ArrayList<Label>());
    }

    public List<Label> preTerminalYield(List<Label> y) {
        if (this.isPreTerminal()) {
            y.add(this.label());
        } else {
            Tree[] kids = this.children();
            for (int i = 0; i < kids.length; ++i) {
                kids[i].preTerminalYield(y);
            }
        }
        return y;
    }

    public List<Tree> getLeaves() {
        return this.getLeaves(new ArrayList<Tree>());
    }

    public List<Tree> getLeaves(List<Tree> list) {
        if (this.isLeaf()) {
            list.add(this);
        } else {
            for (Tree kid : this.children()) {
                kid.getLeaves(list);
            }
        }
        return list;
    }

    @Override
    public Collection<Label> labels() {
        HashSet<Label> n = new HashSet<Label>();
        n.add(this.label());
        Tree[] kids = this.children();
        for (int i = 0; i < kids.length; ++i) {
            n.addAll(kids[i].labels());
        }
        return n;
    }

    @Override
    public void setLabels(Collection<Label> c) {
        throw new UnsupportedOperationException("Can't set Tree labels");
    }

    public Tree flatten() {
        return this.flatten(this.treeFactory());
    }

    public Tree flatten(TreeFactory tf) {
        if (this.isLeaf() || this.isPreTerminal()) {
            return this;
        }
        Tree[] kids = this.children();
        ArrayList<Tree> newChildren = new ArrayList<Tree>(kids.length);
        for (int c = 0; c < kids.length; ++c) {
            Tree child = kids[c];
            if (child.isLeaf() || child.isPreTerminal()) {
                newChildren.add(child);
                continue;
            }
            Tree newChild = child.flatten(tf);
            if (this.label().equals(newChild.label())) {
                newChildren.addAll(newChild.getChildrenAsList());
                continue;
            }
            newChildren.add(newChild);
        }
        return tf.newTreeNode(this.label(), newChildren);
    }

    public Set<Tree> subTrees() {
        return this.subTrees(new HashSet());
    }

    public List<Tree> subTreeList() {
        return this.subTrees(new ArrayList());
    }

    public <T extends Collection<Tree>> T subTrees(T n) {
        n.add((Tree)this);
        Tree[] kids = this.children();
        for (int i = 0; i < kids.length; ++i) {
            kids[i].subTrees(n);
        }
        return n;
    }

    public Tree deeperCopy() {
        return this.deeperCopy(this.treeFactory());
    }

    public Tree deeperCopy(TreeFactory tf) {
        return this.deeperCopy(tf, this.label().labelFactory());
    }

    public Tree deeperCopy(TreeFactory tf, LabelFactory lf) {
        Label label = lf.newLabel(this.label());
        if (this.isLeaf()) {
            return tf.newLeaf(label);
        }
        Tree[] kids = this.children();
        ArrayList<Tree> newKids = new ArrayList<Tree>(kids.length);
        for (Tree kid : kids) {
            newKids.add(kid.deeperCopy(tf, lf));
        }
        return tf.newTreeNode(label, newKids);
    }

    public Tree deepCopy() {
        return this.deepCopy(this.treeFactory());
    }

    public Tree deepCopy(TreeFactory tf) {
        Tree t;
        if (this.isLeaf()) {
            t = tf.newLeaf(this.label());
        } else {
            Tree[] kids = this.children();
            ArrayList<Tree> newKids = new ArrayList<Tree>(kids.length);
            int n = kids.length;
            for (int i = 0; i < n; ++i) {
                newKids.add(kids[i].deepCopy(tf));
            }
            t = tf.newTreeNode(this.label(), newKids);
        }
        return t;
    }

    public Tree transform(TreeTransformer transformer) {
        return this.transform(transformer, this.treeFactory());
    }

    public Tree transform(TreeTransformer transformer, TreeFactory tf) {
        Tree t;
        if (this.isLeaf()) {
            t = tf.newLeaf(this.label());
        } else {
            Tree[] kids = this.children();
            ArrayList<Tree> newKids = new ArrayList<Tree>(kids.length);
            for (Tree kid : kids) {
                newKids.add(kid.transform(transformer, tf));
            }
            t = tf.newTreeNode(this.label(), newKids);
        }
        return transformer.transformTree(t);
    }

    public Tree spliceOut(Filter<Tree> nodeFilter) {
        return this.spliceOut(nodeFilter, this.treeFactory());
    }

    public Tree spliceOut(Filter<Tree> nodeFilter, TreeFactory tf) {
        List<Tree> l = this.spliceOutHelper(nodeFilter, tf);
        if (l.isEmpty()) {
            return null;
        }
        if (l.size() == 1) {
            return l.get(0);
        }
        return tf.newTreeNode((Label)null, l);
    }

    private List<Tree> spliceOutHelper(Filter<Tree> nodeFilter, TreeFactory tf) {
        Tree[] kids = this.children();
        ArrayList<Tree> l = new ArrayList<Tree>();
        for (int i = 0; i < kids.length; ++i) {
            l.addAll(kids[i].spliceOutHelper(nodeFilter, tf));
        }
        if (nodeFilter.accept(this)) {
            Tree t = !l.isEmpty() ? tf.newTreeNode(this.label(), l) : tf.newLeaf(this.label());
            l = new ArrayList(1);
            l.add(t);
            return l;
        }
        return l;
    }

    public Tree prune(Filter<Tree> filter) {
        return this.prune(filter, this.treeFactory());
    }

    public Tree prune(Filter<Tree> filter, TreeFactory tf) {
        if (!filter.accept(this)) {
            return null;
        }
        ArrayList<Tree> l = new ArrayList<Tree>();
        Tree[] kids = this.children();
        for (int i = 0; i < kids.length; ++i) {
            Tree prunedChild = kids[i].prune(filter, tf);
            if (prunedChild == null) continue;
            l.add(prunedChild);
        }
        if (l.isEmpty() && kids.length != 0) {
            return null;
        }
        if (this.isLeaf()) {
            return tf.newLeaf(this.label());
        }
        return tf.newTreeNode(this.label(), l);
    }

    public Tree skipRoot() {
        if (!this.isUnaryRewrite()) {
            return this;
        }
        String lab = this.label().value();
        return lab == null || "ROOT".equals(lab) || "".equals(lab) ? this.firstChild() : this;
    }

    public abstract TreeFactory treeFactory();

    public Tree parent() {
        return null;
    }

    public Tree parent(Tree root) {
        Tree[] kids = root.children();
        return Tree.parentHelper(root, kids, this);
    }

    private static Tree parentHelper(Tree parent, Tree[] kids, Tree node) {
        int n = kids.length;
        for (int i = 0; i < n; ++i) {
            if (kids[i] == node) {
                return parent;
            }
            Tree ret = node.parent(kids[i]);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public int size() {
        int size = 1;
        Tree[] kids = this.children();
        int n = kids.length;
        for (int i = 0; i < n; ++i) {
            size += kids[i].size();
        }
        return size;
    }

    public Tree ancestor(int height, Tree root) {
        if (height < 0) {
            throw new IllegalArgumentException("ancestor: height cannot be negative");
        }
        if (height == 0) {
            return this;
        }
        Tree par = this.parent(root);
        if (par == null) {
            return null;
        }
        return par.ancestor(height - 1, root);
    }

    @Override
    public Iterator<Tree> iterator() {
        return new TreeIterator(this);
    }

    public List<Tree> postOrderNodeList() {
        ArrayList<Tree> nodes = new ArrayList<Tree>();
        Tree.postOrderRecurse(this, nodes);
        return nodes;
    }

    private static void postOrderRecurse(Tree t, List<Tree> nodes) {
        for (Tree c : t.children()) {
            Tree.postOrderRecurse(c, nodes);
        }
        nodes.add(t);
    }

    public List<Tree> preOrderNodeList() {
        ArrayList<Tree> nodes = new ArrayList<Tree>();
        Tree.preOrderRecurse(this, nodes);
        return nodes;
    }

    private static void preOrderRecurse(Tree t, List<Tree> nodes) {
        nodes.add(t);
        for (Tree c : t.children()) {
            Tree.preOrderRecurse(c, nodes);
        }
    }

    public static Tree valueOf(String str) {
        return Tree.valueOf(str, new LabeledScoredTreeReaderFactory());
    }

    public static Tree valueOf(String str, TreeReaderFactory trf) {
        try {
            return trf.newTreeReader(new StringReader(str)).readTree();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Tree.valueOf() tree construction failed", ioe);
        }
    }

    public Tree getChild(int i) {
        Tree[] kids = this.children();
        return kids[i];
    }

    public Tree removeChild(int i) {
        Tree[] kids = this.children();
        Tree kid = kids[i];
        Tree[] newKids = new Tree[kids.length - 1];
        for (int j = 0; j < newKids.length; ++j) {
            newKids[j] = j < i ? kids[j] : kids[j + 1];
        }
        this.setChildren(newKids);
        return kid;
    }

    public void addChild(int i, Tree t) {
        Tree[] kids = this.children();
        Tree[] newKids = new Tree[kids.length + 1];
        if (i != 0) {
            System.arraycopy(kids, 0, newKids, 0, i);
        }
        newKids[i] = t;
        if (i != kids.length) {
            System.arraycopy(kids, i, newKids, i + 1, kids.length - i);
        }
        this.setChildren(newKids);
    }

    public void addChild(Tree t) {
        this.addChild(this.children().length, t);
    }

    public Tree setChild(int i, Tree t) {
        Tree[] kids = this.children();
        Tree old = kids[i];
        kids[i] = t;
        return old;
    }

    public boolean dominates(Tree t) {
        return this.dominationPath(t) != null;
    }

    public List<Tree> dominationPath(Tree t) {
        Tree[] result = this.dominationPath(t, 0);
        if (result == null) {
            return null;
        }
        return Arrays.asList(result);
    }

    private Tree[] dominationPathHelper(Tree t, int depth) {
        Tree[] kids = this.children();
        for (int i = kids.length - 1; i >= 0; --i) {
            Tree t1 = kids[i];
            if (t1 == null) {
                return null;
            }
            Tree[] result = t1.dominationPath(t, depth + 1);
            if (result == null) continue;
            result[depth] = this;
            return result;
        }
        return null;
    }

    private Tree[] dominationPath(Tree t, int depth) {
        if (this == t) {
            Tree[] result = new Tree[depth + 1];
            result[depth] = this;
            return result;
        }
        return this.dominationPathHelper(t, depth);
    }

    public List<Tree> pathNodeToNode(Tree t1, Tree t2) {
        if (!this.contains(t1) || !this.contains(t2)) {
            return null;
        }
        if (t1 == t2) {
            return Collections.singletonList(t1);
        }
        if (t1.dominates(t2)) {
            return t1.dominationPath(t2);
        }
        if (t2.dominates(t1)) {
            List<Tree> path = t2.dominationPath(t1);
            Collections.reverse(path);
            return path;
        }
        Tree joinNode = this.joinNode(t1, t2);
        if (joinNode == null) {
            return null;
        }
        List<Tree> t1DomPath = joinNode.dominationPath(t1);
        List<Tree> t2DomPath = joinNode.dominationPath(t2);
        if (t1DomPath == null || t2DomPath == null) {
            return null;
        }
        ArrayList<Tree> path = new ArrayList<Tree>();
        path.addAll(t1DomPath);
        Collections.reverse(path);
        path.remove(joinNode);
        path.addAll(t2DomPath);
        return path;
    }

    public Tree joinNode(Tree t1, Tree t2) {
        Tree n2;
        Tree n1;
        if (!this.contains(t1) || !this.contains(t2)) {
            return null;
        }
        if (this == t1 || this == t2) {
            return this;
        }
        Tree joinNode = null;
        List<Tree> t1DomPath = this.dominationPath(t1);
        List<Tree> t2DomPath = this.dominationPath(t2);
        if (t1DomPath == null || t2DomPath == null) {
            return null;
        }
        Iterator<Tree> it1 = t1DomPath.iterator();
        Iterator<Tree> it2 = t2DomPath.iterator();
        while (it1.hasNext() && it2.hasNext() && (n1 = it1.next()) == (n2 = it2.next())) {
            joinNode = n1;
        }
        return joinNode;
    }

    public boolean cCommands(Tree t1, Tree t2) {
        List<Tree> sibs = t1.siblings(this);
        if (sibs == null) {
            return false;
        }
        for (Tree sib : sibs) {
            if (sib != t2 && !sib.contains(t2)) continue;
            return true;
        }
        return false;
    }

    public List<Tree> siblings(Tree root) {
        Tree parent = this.parent(root);
        if (parent == null) {
            return null;
        }
        List<Tree> siblings = parent.getChildrenAsList();
        siblings.remove(this);
        return siblings;
    }

    public void insertDtr(Tree dtr, int position) {
        int i;
        Tree[] kids = this.children();
        if (position > kids.length) {
            throw new IllegalArgumentException("Can't insert tree after the " + position + "th daughter in " + this + "; only " + kids.length + " daughters exist!");
        }
        Tree[] newKids = new Tree[kids.length + 1];
        for (i = 0; i < position; ++i) {
            newKids[i] = kids[i];
        }
        newKids[i] = dtr;
        while (i < kids.length) {
            newKids[i + 1] = kids[i];
            ++i;
        }
        this.setChildren(newKids);
    }

    @Override
    public String value() {
        Label lab = this.label();
        if (lab == null) {
            return null;
        }
        return lab.value();
    }

    @Override
    public void setValue(String value) {
        Label lab = this.label();
        if (lab != null) {
            lab.setValue(value);
        }
    }

    @Override
    public void setFromString(String labelStr) {
        Label lab = this.label();
        if (lab != null) {
            lab.setFromString(labelStr);
        }
    }

    @Override
    public LabelFactory labelFactory() {
        Label lab = this.label();
        if (lab == null) {
            return null;
        }
        return lab.labelFactory();
    }

    public int leftCharEdge(Tree node) {
        MutableInteger i = new MutableInteger(0);
        if (this.leftCharEdge(node, i)) {
            return i.intValue();
        }
        return -1;
    }

    private boolean leftCharEdge(Tree node, MutableInteger i) {
        if (this == node) {
            return true;
        }
        if (this.isLeaf()) {
            i.set(i.intValue() + this.value().length());
            return false;
        }
        for (Tree child : this.children()) {
            if (!child.leftCharEdge(node, i)) continue;
            return true;
        }
        return false;
    }

    public int rightCharEdge(Tree node) {
        List<Tree> s = this.getLeaves();
        int length = 0;
        for (Tree leaf : s) {
            length += leaf.label().value().length();
        }
        MutableInteger i = new MutableInteger(length);
        if (this.rightCharEdge(node, i)) {
            return i.intValue();
        }
        return -1;
    }

    private boolean rightCharEdge(Tree node, MutableInteger i) {
        if (this == node) {
            return true;
        }
        if (this.isLeaf()) {
            i.set(i.intValue() - this.label().value().length());
            return false;
        }
        for (int j = this.children().length - 1; j >= 0; --j) {
            if (!this.children()[j].rightCharEdge(node, i)) continue;
            return true;
        }
        return false;
    }

    public int nodeNumber(Tree root) {
        MutableInteger i = new MutableInteger(1);
        if (this.nodeNumberHelper(root, i)) {
            return i.intValue();
        }
        return -1;
    }

    private boolean nodeNumberHelper(Tree t, MutableInteger i) {
        if (this == t) {
            return true;
        }
        i.incValue(1);
        for (int j = 0; j < t.children().length; ++j) {
            if (!this.nodeNumberHelper(t.children()[j], i)) continue;
            return true;
        }
        return false;
    }

    public Tree getNodeNumber(int i) {
        return this.getNodeNumberHelper(new MutableInteger(1), i);
    }

    private Tree getNodeNumberHelper(MutableInteger i, int target) {
        int i1 = i.intValue();
        if (i1 == target) {
            return this;
        }
        if (i1 > target) {
            throw new IndexOutOfBoundsException("Error -- tree does not contain " + i + " nodes.");
        }
        i.incValue(1);
        for (int j = 0; j < this.children().length; ++j) {
            Tree temp = this.children()[j].getNodeNumberHelper(i, target);
            if (temp == null) continue;
            return temp;
        }
        return null;
    }

    public void indexLeaves() {
        this.indexLeaves(1);
    }

    private int indexLeaves(int startIndex) {
        if (this.isLeaf()) {
            CoreMap afl = (CoreMap)((Object)this.label());
            Integer oldIndex = (Integer)afl.get(CoreAnnotations.IndexAnnotation.class);
            if (oldIndex != null && oldIndex >= 0) {
                startIndex = oldIndex;
            } else {
                afl.set(CoreAnnotations.IndexAnnotation.class, startIndex);
            }
            ++startIndex;
        } else {
            for (Tree kid : this.children()) {
                startIndex = kid.indexLeaves(startIndex);
            }
        }
        return startIndex;
    }

    public void indexSpans(int startIndex) {
        this.indexSpans(new MutableInteger(startIndex));
    }

    public Pair<Integer, Integer> indexSpans(MutableInteger startIndex) {
        int start = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        if (this.isLeaf()) {
            start = startIndex.intValue();
            end = startIndex.intValue() + 1;
            startIndex.incValue(1);
        } else {
            for (Tree kid : this.children()) {
                Pair<Integer, Integer> span = kid.indexSpans(startIndex);
                if ((Integer)span.first < start) {
                    start = (Integer)span.first;
                }
                if ((Integer)span.second <= end) continue;
                end = (Integer)span.second;
            }
        }
        CoreMap afl = (CoreMap)((Object)this.label());
        afl.set(CoreAnnotations.BeginIndexAnnotation.class, start);
        afl.set(CoreAnnotations.EndIndexAnnotation.class, end);
        return new Pair<Integer, Integer>(start, end);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeIterator
    implements Iterator<Tree> {
        private List<Tree> treeStack = new ArrayList<Tree>();
        private boolean preorder;

        protected TreeIterator(Tree t, boolean preorder) {
            this.treeStack.add(t);
            this.preorder = preorder;
        }

        protected TreeIterator(Tree t) {
            this(t, true);
        }

        @Override
        public boolean hasNext() {
            return !this.treeStack.isEmpty();
        }

        @Override
        public Tree next() {
            int lastIndex = this.treeStack.size() - 1;
            if (lastIndex < 0) {
                throw new NoSuchElementException("TreeIterator exhausted");
            }
            Tree tr = this.treeStack.remove(lastIndex);
            Tree[] kids = tr.children();
            for (int i = kids.length - 1; i >= 0; --i) {
                this.treeStack.add(kids[i]);
            }
            return tr;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "TreeIterator";
        }
    }
}

