
use strict;
use warnings;

use 5.008;

use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Modules that LESPEA uses on a daily basis",
  "AUTHOR" => "Adam Lesperance <lespea\@gmail.com>",
  "BUILD_REQUIRES" => {
    "File::Find" => 0,
    "File::Temp" => 0,
    "Module::Build" => "0.3601",
    "Test::More" => "0.88"
  },
  "CONFIGURE_REQUIRES" => {
    "Module::Build" => "0.3601"
  },
  "DISTNAME" => "Task-BeLike-LESPEA",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "Task::BeLike::LESPEA",
  "PREREQ_PM" => {
    "Any::Moose" => "0.000000",
    "AnyEvent" => "0.000000",
    "Async::Interrupt" => "0.000000",
    "Coro" => "0.000000",
    "DBD::CSV" => "0.000000",
    "DBI" => "0.000000",
    "Data::Printer" => "0.000000",
    "Date::Calc" => "0.000000",
    "Date::Manip" => "0.000000",
    "DateTime" => "0.000000",
    "DateTime::Format::DB2" => "0.000000",
    "DateTime::Format::DBI" => "0.000000",
    "DateTime::Format::DateManip" => "0.000000",
    "DateTime::Format::DateParse" => "0.000000",
    "DateTime::Format::Duration" => "0.000000",
    "DateTime::Format::Duration::DurationString" => "0.000000",
    "DateTime::Format::Duration::XSD" => "0.000000",
    "DateTime::Format::Epoch" => "0.000000",
    "DateTime::Format::Epoch::ActiveDirectory" => "0.000000",
    "DateTime::Format::Epoch::DotNet" => "0.000000",
    "DateTime::Format::Epoch::JD" => "0.000000",
    "DateTime::Format::Epoch::Lilian" => "0.000000",
    "DateTime::Format::Epoch::MJD" => "0.000000",
    "DateTime::Format::Epoch::MacOS" => "0.000000",
    "DateTime::Format::Epoch::RJD" => "0.000000",
    "DateTime::Format::Epoch::RataDie" => "0.000000",
    "DateTime::Format::Epoch::TAI64" => "0.000000",
    "DateTime::Format::Epoch::TJD" => "0.000000",
    "DateTime::Format::Epoch::Unix" => "0.000000",
    "DateTime::Format::Excel" => "0.000000",
    "DateTime::Format::Flexible" => "0.000000",
    "DateTime::Format::HTTP" => "0.000000",
    "DateTime::Format::Human" => "0.000000",
    "DateTime::Format::Human::Duration" => "0.000000",
    "DateTime::Format::ICal" => "0.000000",
    "DateTime::Format::ISO8601" => "0.000000",
    "DateTime::Format::MSSQL" => "0.000000",
    "DateTime::Format::MySQL" => "0.000000",
    "DateTime::Format::Natural" => "0.000000",
    "DateTime::Format::Natural::Aliases" => "0.000000",
    "DateTime::Format::Natural::Calc" => "0.000000",
    "DateTime::Format::Natural::Compat" => "0.000000",
    "DateTime::Format::Natural::Duration" => "0.000000",
    "DateTime::Format::Natural::Duration::Checks" => "0.000000",
    "DateTime::Format::Natural::Expand" => "0.000000",
    "DateTime::Format::Natural::Extract" => "0.000000",
    "DateTime::Format::Natural::Formatted" => "0.000000",
    "DateTime::Format::Natural::Helpers" => "0.000000",
    "DateTime::Format::Natural::Lang::Base" => "0.000000",
    "DateTime::Format::Natural::Lang::EN" => "0.000000",
    "DateTime::Format::Natural::Rewrite" => "0.000000",
    "DateTime::Format::Natural::Test" => "0.000000",
    "DateTime::Format::Natural::Utils" => "0.000000",
    "DateTime::Format::Natural::Wrappers" => "0.000000",
    "DateTime::Format::Oracle" => "0.000000",
    "DateTime::Format::Pg" => "0.000000",
    "DateTime::Format::RFC3339" => "0.000000",
    "DateTime::Format::RFC3501" => "0.000000",
    "DateTime::Format::RSS" => "0.000000",
    "DateTime::Format::Roman" => "0.000000",
    "DateTime::Format::SQLite" => "0.000000",
    "DateTime::Format::Strptime" => "0.000000",
    "DateTime::Format::Sybase" => "0.000000",
    "DateTime::Format::Variant" => "0.000000",
    "DateTime::Format::W3CDTF" => "0.000000",
    "DateTime::Format::WindowsFileTime" => "0.000000",
    "DateTime::Format::XMLTV" => "0.000000",
    "DateTime::Format::XSD" => "0.000000",
    "DateTime::Format::x509" => "0.000000",
    "Devel::Cover" => "0.000000",
    "Devel::NYTProf" => "0.000000",
    "Devel::REPL" => "0.000000",
    "Devel::REPL::Plugin::DataPrinter" => "0.000000",
    "Dist::Zilla" => "0.000000",
    "Dist::Zilla::App::Command::cover" => "0.000000",
    "Dist::Zilla::App::Command::perltidy" => "0.000000",
    "Dist::Zilla::App::Command::shell" => "0.000000",
    "Dist::Zilla::PluginBundle::Author::LESPEA" => "1.003000",
    "Dist::Zilla::Shell" => "0.000000",
    "EV" => "0.000000",
    "Encode" => "0.000000",
    "Event" => "0.000000",
    "Excel::Writer::XLSX" => "0.000000",
    "Exporter::Easy" => "0.000000",
    "File::HomeDir" => "0.000000",
    "File::Next" => "0.000000",
    "File::ShareDir" => "0.000000",
    "File::Slurp" => "0.000000",
    "Getopt::Long::Descriptive" => "0.000000",
    "Guard" => "0.000000",
    "HTML::Entities" => "0.000000",
    "HTML::Tree" => "0.000000",
    "HTML::TreeBuilder::XPath" => "0.000000",
    "IO::Scalar" => "0.000000",
    "JSON" => "0.000000",
    "JSON::Any" => "0.000000",
    "JSON::XS" => "0.000000",
    "LWP" => "0.000000",
    "LWP::Protocol::https" => "0.000000",
    "List::AllUtils" => "0.000000",
    "List::Gen" => "0.000000",
    "List::MoreUtils" => "0.000000",
    "Locale::US" => "0.000000",
    "Math::Big" => "0.000000",
    "Math::Big::Factors" => "0.000000",
    "Modern::Perl" => "1.201205",
    "Module::Build" => "0.000000",
    "Module::Install" => "0.000000",
    "Module::Install::AuthorTests" => "0.000000",
    "Module::Install::ExtraTests" => "0.000000",
    "Module::Refresh" => "0.000000",
    "Module::Reload" => "0.000000",
    "Moose" => "0.000000",
    "Moose::Meta::Attribute::Native" => "0.000000",
    "MooseX::Aliases" => "0.000000",
    "MooseX::App" => "0.000000",
    "MooseX::App::Cmd" => "0.000000",
    "MooseX::Log::Log4perl" => "0.000000",
    "MooseX::Method::Signatures" => "0.000000",
    "MooseX::Singleton" => "0.000000",
    "MooseX::StrictConstructor" => "0.000000",
    "MooseX::Types" => "0.000000",
    "MooseX::Types::Common" => "0.000000",
    "MooseX::Types::Common::Numeric" => "0.000000",
    "MooseX::Types::Common::String" => "0.000000",
    "MooseX::Types::DateTime::ButMaintained" => "0.000000",
    "MooseX::Types::Email" => "0.000000",
    "MooseX::Types::IPv4" => "0.000000",
    "MooseX::Types::JSON" => "0.000000",
    "MooseX::Types::NetAddr::IP" => "0.000000",
    "MooseX::Types::PortNumber" => "0.000000",
    "MooseX::Types::Structured" => "0.000000",
    "MooseX::Types::URI" => "0.000000",
    "MooseX::Types::UUID" => "0.000000",
    "MouseX::Types" => "0.000000",
    "Net::CIDR::Lite" => "0.000000",
    "Net::DNS" => "0.000000",
    "Net::IP" => "0.000000",
    "Net::Netmask" => "0.000000",
    "Net::Ping" => "0.000000",
    "PPI::HTML" => "0.000000",
    "Perl::Critic" => "0.000000",
    "Perl::Tidy" => "0.000000",
    "Readonly::XS" => "0.000000",
    "Regexp::Common" => "0.000000",
    "Scalar::Util" => "0.000000",
    "Spreadsheet::ParseExcel" => "0.000000",
    "Spreadsheet::Read" => "0.000000",
    "Spreadsheet::WriteExcel" => "0.000000",
    "Spreadsheet::XLSX" => "0.000000",
    "Task::Weaken" => "0.000000",
    "Template" => "0.000000",
    "Test::Fatal" => "0.000000",
    "Test::File" => "0.000000",
    "Test::LeakTrace" => "0.000000",
    "Test::Memory::Cycle" => "0.000000",
    "Test::Most" => "0.000000",
    "Test::Output" => "0.000000",
    "Test::Perl::Critic" => "0.000000",
    "Test::Pod" => "0.000000",
    "Test::Pod::Coverage" => "0.000000",
    "Test::Taint" => "0.000000",
    "Text::CSV_XS" => "0.000000",
    "Text::Trim" => "0.000000",
    "Try::Tiny" => "0.000000",
    "WWW::Mechanize" => "0.000000",
    "XML::LibXML" => "0.000000",
    "XML::SAX" => "0.000000",
    "XML::Simple" => "0.000000",
    "XML::Twig" => "0.000000",
    "YAML" => "0.000000",
    "YAML::Any" => "0.000000",
    "YAML::Syck" => "0.000000",
    "YAML::XS" => "0.000000",
    "autodie" => "0.000000",
    "autovivification" => "0.000000",
    "namespace::autoclean" => "0.000000",
    "strict" => 0,
    "utf8" => 0,
    "warnings" => 0
  },
  "VERSION" => "2.002001",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



