use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME              => 'RPi::WiringPi',
    VERSION_FROM      => 'lib/RPi/WiringPi.pm',
    ($] >= 5.005 ?
      (ABSTRACT_FROM  => 'lib/RPi/WiringPi.pm',
       AUTHOR         => 'Steve Bertrand <steveb@cpan.org>') : ()),
    LIBS              => [],
    DEFINE            => '',
    INC               => '-I.',
    EXE_FILES         => [ map "bin/$_", qw(
            pinmap 
            pidentify
            pimeta
            pimetaerase
        )
    ],
    META_MERGE => {
        'meta-spec' => { version => 2 },
        resources   => {
            bugtracker => {
                web => 'https://github.com/stevieb9/rpi-wiringpi/issues',
            },
            repository => {
                type => 'git',
                url => 'https://github.com/stevieb9/rpi-wiringpi.git',
                web => 'https://github.com/stevieb9/rpi-wiringpi',
            },
        },
    },
    MIN_PERL_VERSION   => 5.010,
    LICENSE => 'perl_5',
    CONFIGURE_REQUIRES => {
        'ExtUtils::MakeMaker'   => 6.72,
    },
    PREREQ_PM         => {
        'parent'                    => 0,
        'File::Touch'               => 0,
        'GPSD::Parse'               => 1.03,
        'IPC::ShareLite'            => 0,
        'JSON::XS'                  => 0,
        'RPi::ADC::ADS'             => 1.02,
        'RPi::ADC::MCP3008'         => 2.3605,
        'RPi::Const'                => 1.04,
        'RPi::BMP180'               => 2.3604,
        'RPi::DAC::MCP4922'         => 2.3605,
        'RPi::DigiPot::MCP4XXXX'    => 2.3604,
        'RPi::DHT11'                => 1.04,
        'RPi::EEPROM::AT24C32'      => 0.01,
        'RPi::GPIOExpander::MCP23017' => 1.02,
        'RPi::HCSR04'               => 2.3604,
        'RPi::I2C'                  => 2.3607,
        'RPi::LCD'                  => 2.3604,
        'RPi::OLED::SSD1306::128_64'=> 2.3602,
        'RPi::Pin'                  => 2.3608,
        'RPi::RTC::DS3231'          => 0.01,
        'RPi::Serial'               => 3.00,
        'RPi::SPI'                  => 2.3609,
        'RPi::StepperMotor'         => 2.3605,
        'RPi::SysInfo'              => 1.00,
        'WiringPi::API'             => 2.3616,
    },
);
