# This Makefile.PL for DateTime was generated by
# Dist::Zilla::Plugin::DROLSKY::MakeMaker 1.20
# and Dist::Zilla::Plugin::MakeMaker::Awesome 0.49.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.008004;
use ExtUtils::MakeMaker;
check_conflicts();

my %WriteMakefileArgs = (
  "ABSTRACT" => "A date and time object for Perl",
  "AUTHOR" => "Dave Rolsky <autarch\@urth.org>",
  "CONFIGURE_REQUIRES" => {
    "Dist::CheckConflicts" => "0.02",
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "DateTime",
  "LICENSE" => "artistic_2",
  "MIN_PERL_VERSION" => "5.008004",
  "NAME" => "DateTime",
  "PREREQ_PM" => {
    "Carp" => 0,
    "DateTime::Locale" => "1.06",
    "DateTime::TimeZone" => "2.44",
    "Dist::CheckConflicts" => "0.02",
    "POSIX" => 0,
    "Params::ValidationCompiler" => "0.26",
    "Scalar::Util" => 0,
    "Specio" => "0.18",
    "Specio::Declare" => 0,
    "Specio::Exporter" => 0,
    "Specio::Library::Builtins" => 0,
    "Specio::Library::Numeric" => 0,
    "Specio::Library::String" => 0,
    "Specio::Subs" => 0,
    "Try::Tiny" => 0,
    "XSLoader" => 0,
    "base" => 0,
    "integer" => 0,
    "namespace::autoclean" => "0.19",
    "overload" => 0,
    "parent" => 0,
    "strict" => 0,
    "warnings" => 0,
    "warnings::register" => 0
  },
  "TEST_REQUIRES" => {
    "CPAN::Meta::Check" => "0.011",
    "CPAN::Meta::Requirements" => 0,
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "Storable" => 0,
    "Test::Fatal" => 0,
    "Test::More" => "0.96",
    "Test::Warnings" => "0.005",
    "Test::Without::Module" => 0,
    "utf8" => 0
  },
  "VERSION" => "1.58",
  "test" => {
    "TESTS" => "t/*.t"
  }
);
my $gcc_warnings = $ENV{AUTHOR_TESTING} && $] >= 5.008008 ? q{ -Wall -Werror} : q{};
$WriteMakefileArgs{DEFINE}
    = ( $WriteMakefileArgs{DEFINE} || q{} ) . $gcc_warnings;

my %FallbackPrereqs = (
  "CPAN::Meta::Check" => "0.011",
  "CPAN::Meta::Requirements" => 0,
  "Carp" => 0,
  "DateTime::Locale" => "1.06",
  "DateTime::TimeZone" => "2.44",
  "Dist::CheckConflicts" => "0.02",
  "ExtUtils::MakeMaker" => 0,
  "File::Spec" => 0,
  "POSIX" => 0,
  "Params::ValidationCompiler" => "0.26",
  "Scalar::Util" => 0,
  "Specio" => "0.18",
  "Specio::Declare" => 0,
  "Specio::Exporter" => 0,
  "Specio::Library::Builtins" => 0,
  "Specio::Library::Numeric" => 0,
  "Specio::Library::String" => 0,
  "Specio::Subs" => 0,
  "Storable" => 0,
  "Test::Fatal" => 0,
  "Test::More" => "0.96",
  "Test::Warnings" => "0.005",
  "Test::Without::Module" => 0,
  "Try::Tiny" => 0,
  "XSLoader" => 0,
  "base" => 0,
  "integer" => 0,
  "namespace::autoclean" => "0.19",
  "overload" => 0,
  "parent" => 0,
  "strict" => 0,
  "utf8" => 0,
  "warnings" => 0,
  "warnings::register" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

sub check_conflicts {
    if ( eval { require './lib/DateTime/Conflicts.pm'; 1; } ) {
        if ( eval { DateTime::Conflicts->check_conflicts; 1 } ) {
            return;
        }
        else {
            my $err = $@;
            $err =~ s/^/    /mg;
            warn "***\n$err***\n";
        }
    }
    else {
        print <<'EOF';
***
    Your toolchain doesn't support configure_requires, so Dist::CheckConflicts
    hasn't been installed yet. You should check for conflicting modules
    manually by examining the list of conflicts in DateTime::Conflicts once the installation
    finishes.
***
EOF
    }

    return if $ENV{AUTOMATED_TESTING} || $ENV{NONINTERACTIVE_TESTING};

    # More or less copied from Module::Build
    return if $ENV{PERL_MM_USE_DEFAULT};
    return unless -t STDIN && ( -t STDOUT || !( -f STDOUT || -c STDOUT ) );

    sleep 4;
}
