# Generated by default/object.tt
package Paws::FMS::NetworkFirewallPolicyModifiedViolation;
  use Moose;
  has CurrentPolicyDescription => (is => 'ro', isa => 'Paws::FMS::NetworkFirewallPolicyDescription');
  has ExpectedPolicyDescription => (is => 'ro', isa => 'Paws::FMS::NetworkFirewallPolicyDescription');
  has ViolationTarget => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::FMS::NetworkFirewallPolicyModifiedViolation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FMS::NetworkFirewallPolicyModifiedViolation object:

  $service_obj->Method(Att1 => { CurrentPolicyDescription => $value, ..., ViolationTarget => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FMS::NetworkFirewallPolicyModifiedViolation object:

  $result = $service_obj->Method(...);
  $result->Att1->CurrentPolicyDescription

=head1 DESCRIPTION

Violation details for AWS Network Firewall for a firewall policy that
has a different NetworkFirewallPolicyDescription than is required by
the Firewall Manager policy.

=head1 ATTRIBUTES


=head2 CurrentPolicyDescription => L<Paws::FMS::NetworkFirewallPolicyDescription>

The policy that's currently in use in the individual account.


=head2 ExpectedPolicyDescription => L<Paws::FMS::NetworkFirewallPolicyDescription>

The policy that should be in use in the individual account in order to
be compliant.


=head2 ViolationTarget => Str

The ID of the AWS Network Firewall or VPC resource that's in violation.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

