use strict;
use warnings;

use Test::More tests => 157;

BEGIN { use_ok 'Range::Object::DigitString' };

my $tests = eval do { local $/; <DATA>; };
die "Data eval error: $@" if $@;

die "Nothing to test!" unless $tests;

require 't/tests.pl';

run_tests( $tests );

__DATA__
[
    'Range::Object::DigitString' => [
        # Custom code
        undef,

        # Invalid input
        [ '00*00', '12345678901234567', '', '&9999', 'foo', '%123',
          '*00123', '#9999', ],

        # Valid input
        [ '0', '01', '0000-0010', '1234', '157863', '1234567',
          '1234567890123456', ],

        # Valid in() items
        [ '0', '01', qw(0000 0001 0002 0003 0004 0005 0006 0007 0008
          0009 0010 1234 157863), '1234567', '1234567890123456', ],

        # Not in() input
        [ '1', '00', '02', '0011', '01234', '157862', '157864',
          '01234567', '1234566', '1234568', '1234567890123455',
          '1234567890123457', ],

        # Not in() output
        [ '1', '00', '02', '0011', '01234', '157862', '157863',
          '01234567', '1234566', '1234568', '1234567890123455',
          '1234567890123457', ],

        # List context range() output
        [  qw(0 0000 0001 0002 0003 0004 0005 0006 0007 0008
          0009 0010 01 1234 1234567 1234567890123456 157863), ],

        # Scalar context range() output
        '0,0000,0001,0002,0003,0004,0005,0006,0007,0008,0009,0010,01,'.
        '1234,1234567,1234567890123456,157863',

        # List context collapsed() output
        [ '0', 
          { start => '0000', end => '0010', count => 11 },
          qw(01 1234 1234567 1234567890123456 157863), ],

        # Scalar context collapsed() output
        '0,0000-0010,01,1234,1234567,1234567890123456,157863',

        # Initial range size()
        17,

        # add() input
        [ qw(1000-1003), '01-03' ],

        # Valid in() items after add()
        [ '0', '01', '02', '03',
          qw(0000 0001 0002 0003 0004 0005 0006 0007 0008 0009 0010
             1000 1001 1002 1003
             1234 157863 1234567 1234567890123456), ],

        # Not in() input
        [ '1', '00', '04', '0011', '0999', '1004', '01234', '157862',
          '157864',
          '01234567', '1234566', '1234568', '1234567890123455',
          '1234567890123457', ],

        # Not in() output
        [ '1', '00', '04', '0011', '0999', '1004', '01234', '157862',
          '157864',
          '01234567', '1234566', '1234568', '1234567890123455',
          '1234567890123457', ],


        # List context range() output after add()
        [ qw(0 0000 0001 0002 0003 0004 0005 0006 0007 0008 0009 0010
             01 02 03 1000 1001 1002 1003
             1234 1234567 1234567890123456 157863), ],

        # Scalar context range() output after add()
        '0,0000,0001,0002,0003,0004,0005,0006,0007,0008,'.
        '0009,0010,01,02,03,1000,1001,1002,1003,1234,1234567,'.
        '1234567890123456,157863',

        # List context collapsed() output after add()
        [ '0',
          { start => '0000', end => '0010', count => 11 },
          { start => '01',   end => '03',   count => 3  },
          { start => '1000', end => '1003', count => 4  },
          qw(1234 1234567 1234567890123456 157863), ],

        # Scalar context collapsed() output after add()
        '0,0000-0010,01-03,1000-1003,1234,1234567,1234567890123456,157863',

        # size() after add()
        23,

        # remove() input
        [ '00-02', '0001-0007', '0999-1010', '157863', '1234567890123456', ],

        # Valid in() items after remove()
        [ qw(0 03 0000 0008 0009 0010 1234 1234567), ],

        # Not in() input after remove()
        [ qw(00 01 02 04 0001 0002 0003 0004 0005 0006 0007 0011 1233
             1235 157862 157863 157864 1234567890123456), ],

        # Not in() output
        [ qw(00 01 02 04 0001 0002 0003 0004 0005 0006 0007 0011 1233
             1235 157862 157863 157864 1234567890123456), ],

        # List context range() output after remove()
        [ qw(0 0000 0008 0009 0010 03 1234 1234567), ],

        # Scalar context range() output after remove()
        '0,0000,0008,0009,0010,03,1234,1234567',

        # List context collapsed() output after remove()
        [ '0', '0000',
          { start => '0008',  end => '0010',  count => 3 },
          '03', '1234', '1234567', ],

        # Scalar context collapsed() output after remove()
        '0,0000,0008-0010,03,1234,1234567',

        # size() after remove()
        8,
    ],
]
