#!/usr/bin/perl

package eBay::API::XML::Call::GetAllBidders::GetAllBiddersRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetAllBiddersRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetAllBidders::GetAllBiddersRequestType

=head1 DESCRIPTION

Provides three modes for retrieving a list of the users that bid
on a listing. One of the modes is of particular value in support of
the Second Chance Offer feature. Includes the list of bidders for the
requested item as part of the general item listing data.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetAllBidders::GetAllBiddersRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::ItemIDType;
use eBay::API::XML::DataType::Enum::GetAllBiddersModeCodeType;


my @gaProperties = ( [ 'CallMode', 'ns:GetAllBiddersModeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::GetAllBiddersModeCodeType', '' ]
	, [ 'IncludeBiddingSummary', 'xs:boolean', '', '', '' ]
	, [ 'ItemID', 'ns:ItemIDType', ''
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCallMode()

Specifies which bidder information to return.

  RequiredInput: Yes
#    Argument: 'ns:GetAllBiddersModeCodeType'

=cut

sub setCallMode {
  my $self = shift;
  $self->{'CallMode'} = shift
}

=head2 getCallMode()

#    Returns: 'ns:GetAllBiddersModeCodeType'

=cut

sub getCallMode {
  my $self = shift;
  return $self->{'CallMode'};
}


=head2 setIncludeBiddingSummary()

Specifies whether return BiddingSummary container for each offer.

  RequiredInput: Conditionally
#    Argument: 'xs:boolean'

=cut

sub setIncludeBiddingSummary {
  my $self = shift;
  $self->{'IncludeBiddingSummary'} = shift
}

=head2 isIncludeBiddingSummary()

#    Returns: 'xs:boolean'

=cut

sub isIncludeBiddingSummary {
  my $self = shift;
  return $self->{'IncludeBiddingSummary'};
}


=head2 setItemID()

The item ID for which to retrieve the list of bidders.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Yes
#    Argument: 'ns:ItemIDType'

=cut

sub setItemID {
  my $self = shift;
  $self->{'ItemID'} = shift
}

=head2 getItemID()

#    Returns: 'ns:ItemIDType'

=cut

sub getItemID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemID'
		,'eBay::API::XML::DataType::ItemIDType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
