#!/usr/bin/perl

package eBay::API::XML::DataType::CalculatedShippingPreferencesType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. CalculatedShippingPreferencesType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::CalculatedShippingPreferencesType

=head1 DESCRIPTION

Calculated shipping preferences for the user.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::CalculatedShippingPreferencesType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::Enum::CalculatedShippingChargeOptionCodeType;
use eBay::API::XML::DataType::Enum::CalculatedShippingRateOptionCodeType;
use eBay::API::XML::DataType::Enum::InsuranceOptionCodeType;


my @gaProperties = ( [ 'CalculatedShippingAmountForEntireOrder', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'CalculatedShippingChargeOption', 'ns:CalculatedShippingChargeOptionCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::CalculatedShippingChargeOptionCodeType', '' ]
	, [ 'CalculatedShippingRateOption', 'ns:CalculatedShippingRateOptionCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::CalculatedShippingRateOptionCodeType', '' ]
	, [ 'InsuranceOption', 'ns:InsuranceOptionCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::InsuranceOptionCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCalculatedShippingAmountForEntireOrder()

The calculated shipping amount for the entire order.

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: 'ns:AmountType'

=cut

sub setCalculatedShippingAmountForEntireOrder {
  my $self = shift;
  $self->{'CalculatedShippingAmountForEntireOrder'} = shift
}

=head2 getCalculatedShippingAmountForEntireOrder()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: 'ns:AmountType'

=cut

sub getCalculatedShippingAmountForEntireOrder {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CalculatedShippingAmountForEntireOrder'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setCalculatedShippingChargeOption()

Specifies whether to charge the actual shipping and handling cost for the entire order
or for each item.

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: 'ns:CalculatedShippingChargeOptionCodeType'

=cut

sub setCalculatedShippingChargeOption {
  my $self = shift;
  $self->{'CalculatedShippingChargeOption'} = shift
}

=head2 getCalculatedShippingChargeOption()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: 'ns:CalculatedShippingChargeOptionCodeType'

=cut

sub getCalculatedShippingChargeOption {
  my $self = shift;
  return $self->{'CalculatedShippingChargeOption'};
}


=head2 setCalculatedShippingRateOption()

Specifies whether to calculate the actual rate shipping based on the combined item weight
or the individual item weight.

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: 'ns:CalculatedShippingRateOptionCodeType'

=cut

sub setCalculatedShippingRateOption {
  my $self = shift;
  $self->{'CalculatedShippingRateOption'} = shift
}

=head2 getCalculatedShippingRateOption()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: 'ns:CalculatedShippingRateOptionCodeType'

=cut

sub getCalculatedShippingRateOption {
  my $self = shift;
  return $self->{'CalculatedShippingRateOption'};
}


=head2 setInsuranceOption()

Whether the seller offers shipping insurance and, if
so, whether the insurance is optional or required. Flat and
calculated shipping.

  Calls: SetUserPreferences
  RequiredInput: No
  AllValuesExcept: NotOfferedOnSite

#    Argument: 'ns:InsuranceOptionCodeType'

=cut

sub setInsuranceOption {
  my $self = shift;
  $self->{'InsuranceOption'} = shift
}

=head2 getInsuranceOption()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: 'ns:InsuranceOptionCodeType'

=cut

sub getInsuranceOption {
  my $self = shift;
  return $self->{'InsuranceOption'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
