# Generated by default/object.tt
package Paws::AuditManager::URL;
  use Moose;
  has HyperlinkName => (is => 'ro', isa => 'Str', request_name => 'hyperlinkName', traits => ['NameInRequest']);
  has Link => (is => 'ro', isa => 'Str', request_name => 'link', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AuditManager::URL

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AuditManager::URL object:

  $service_obj->Method(Att1 => { HyperlinkName => $value, ..., Link => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AuditManager::URL object:

  $result = $service_obj->Method(...);
  $result->Att1->HyperlinkName

=head1 DESCRIPTION

A uniform resource locator, used as a unique identifier to locate a
resource on the internet.

=head1 ATTRIBUTES


=head2 HyperlinkName => Str

The name or word used as a hyperlink to the URL.


=head2 Link => Str

The unique identifier for the internet resource.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AuditManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

