/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.jpeg;

import com.drew.lang.annotations.Nullable;
import java.io.Serializable;

public class JpegComponent
implements Serializable {
    private static final long serialVersionUID = 61121257899091914L;
    private final int _componentId;
    private final int _samplingFactorByte;
    private final int _quantizationTableNumber;

    public JpegComponent(int componentId, int samplingFactorByte, int quantizationTableNumber) {
        this._componentId = componentId;
        this._samplingFactorByte = samplingFactorByte;
        this._quantizationTableNumber = quantizationTableNumber;
    }

    public int getComponentId() {
        return this._componentId;
    }

    @Nullable
    public String getComponentName() {
        switch (this._componentId) {
            case 1: {
                return "Y";
            }
            case 2: {
                return "Cb";
            }
            case 3: {
                return "Cr";
            }
            case 4: {
                return "I";
            }
            case 5: {
                return "Q";
            }
        }
        return null;
    }

    public int getQuantizationTableNumber() {
        return this._quantizationTableNumber;
    }

    public int getHorizontalSamplingFactor() {
        return this._samplingFactorByte & 0xF;
    }

    public int getVerticalSamplingFactor() {
        return this._samplingFactorByte >> 4 & 0xF;
    }
}

