/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.mdat;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.ChannelHelper;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CastUtils;
import com.coremedia.iso.boxes.ContainerBox;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public final class MediaDataBox
implements Box {
    public static final String TYPE = "mdat";
    ContainerBox parent;
    ByteBuffer header;
    ByteBuffer content;

    public ContainerBox getParent() {
        return this.parent;
    }

    public void setParent(ContainerBox parent) {
        this.parent = parent;
    }

    public String getType() {
        return TYPE;
    }

    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        this.header.rewind();
        this.content.rewind();
        writableByteChannel.write(this.header);
        writableByteChannel.write(this.content);
    }

    public long getSize() {
        return this.header.limit() + this.content.limit();
    }

    public void parse(ReadableByteChannel in, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        this.header = header;
        if (in instanceof FileChannel && contentSize > 0x100000L) {
            this.content = ((FileChannel)in).map(FileChannel.MapMode.READ_ONLY, ((FileChannel)in).position(), contentSize);
            ((FileChannel)in).position(((FileChannel)in).position() + contentSize);
        } else {
            this.content = ChannelHelper.readFully(in, CastUtils.l2i(contentSize));
        }
    }

    public ByteBuffer getContent() {
        return this.content;
    }

    public ByteBuffer getHeader() {
        return this.header;
    }
}

