#
# Patch given file with DATA hunks and print to STDOUT.
#
#
# Patch to:
#   - Fixup includes.
#   - Move to uuconfig.h.
#
use strict;
use warnings;
use Text::Patch 'patch';

my $in = $ARGV[0];

my ($txt, $patch);
{
    local $/;
    open my $fh, '<', $in or die "open: $in: $!";
    $txt   = <$fh>;
    $patch = <DATA>;
}

#print $txt;
#print $patch;
#exit;

my $out = patch( $txt, $patch, STYLE => 'Unified' );

print $out;
exit 0;

__END__
--- usrcP/uuid/compare.c	Sun Jan 14 15:29:17 2024
+++ ulib/uuid/compare.c	Sun Jan 14 15:45:41 2024
@@ -34,9 +34,8 @@
  * %End-Header%
  */
 
-#include "config.h"
-#include "uuidP.h"
-#include <string.h>
+#include "uuconfig.h"
+#include "uuid/uuidP.h"
 
 #define UUCMP(u1,u2) if (u1 != u2) return((u1 < u2) ? -1 : 1);
 

