#
# make sure many threads all get same default paths.
#
use strict;
use warnings;
use Config;

BEGIN {
    unless ($Config{useithreads}) {
        print "1..0 # SKIP no ithreads\n";
        exit 0;
    }
}

use threads;
use threads::shared;
use Test::More;
use Try::Tiny;

use vars qw(@OPTS);

BEGIN {
    @OPTS = qw(:persist=foo);
    ok 1, 'began';
}

use UUID @OPTS;

ok 1, 'loaded';

my $cnt = 0;
share($cnt);

sub t (&) {
    my $t = shift;
    my ($rv, $err);
    $rv = try { $t->() } catch { $err = $_; undef };
    return $rv, $err;
}

sub doit {
    note 'in doit()';
    my $c; { lock $cnt; $c = ++$cnt }
    note "c: $c";
    my ($rv,$er) = t{ UUID::_statepath };
    is $rv, 'foo', "path seems correct $cnt";
    is $er, undef, "path correct $cnt";
}

note 'spawn 1'; my $thr1 = threads->create(\&doit); $thr1->join;
note 'spawn 2'; my $thr2 = threads->create(\&doit); $thr2->join;
note 'spawn 3'; my $thr3 = threads->create(\&doit); $thr3->join;

note 'spawn 4'; my $thr4 = threads->create(\&doit);
note 'spawn 5'; my $thr5 = threads->create(\&doit);
note 'spawn 6'; my $thr6 = threads->create(\&doit);
$thr4->join;
$thr6->join;
$thr5->join;

done_testing;
