#ifdef __cplusplus
extern "C" {
#endif

#include "uulib/gen.h"
#include "uulib/chacha.h"
#include "uulib/clock.h"
#include "uulib/node.h"

#ifdef __cplusplus
}
#endif


/* randomize uu_node */
static void uu_gen_randomize(pUCXT) {
  cc_rand32(aUCXT, (U32*)&UCXT.gen_node[0]);
  cc_rand16(aUCXT, (U16*)&UCXT.gen_node[4]);
  UCXT.gen_node[0] |= 0x01; /* set mcast */
}

/* call at boot */
void uu_gen_init(pUCXT) {
  UCXT.gen_epoch = (((U64) 0x01B21DD2) << 32) | 0x13814000; /* unused */
  UCXT.gen_use_unique = 0;
  UCXT.gen_has_real_node = 0;
  UCXT.gen_node[0] = 0;;
  UCXT.gen_node[1] = 0;;
  UCXT.gen_node[2] = 0;;
  UCXT.gen_node[3] = 0;;
  UCXT.gen_node[4] = 0;;
  UCXT.gen_node[5] = 0;;
  UCXT.gen_real_node[0] = 0;
  UCXT.gen_real_node[1] = 0;
  UCXT.gen_real_node[2] = 0;
  UCXT.gen_real_node[3] = 0;
  UCXT.gen_real_node[4] = 0;
  UCXT.gen_real_node[5] = 0;

  cc_srand(aUCXT);
  /* get the real node or randomize it */
  if (uu_get_node_id(aUCXT, (U8*)&UCXT.gen_node) == 1) {
    UCXT.gen_has_real_node = 1;
    UCXT.gen_real_node[0] = UCXT.gen_node[0];
    UCXT.gen_real_node[1] = UCXT.gen_node[1];
    UCXT.gen_real_node[2] = UCXT.gen_node[2];
    UCXT.gen_real_node[3] = UCXT.gen_node[3];
    UCXT.gen_real_node[4] = UCXT.gen_node[4];
    UCXT.gen_real_node[5] = UCXT.gen_node[5];
  }
  else {
    UCXT.gen_has_real_node = 0;
    uu_gen_randomize(aUCXT);
  }
}

void uu_gen_setrand(pUCXT) {
  UCXT.gen_use_unique = 0;
  uu_gen_randomize(aUCXT);
}

void uu_gen_setuniq(pUCXT) {
  UCXT.gen_use_unique = 1;
}

/* returns 1 if has real node, or 0 */
int uu_realnode(pUCXT, struct uu *out) {
  uu_v0gen(aUCXT, out);
  out->node[0] = UCXT.gen_real_node[0];
  out->node[1] = UCXT.gen_real_node[1];
  out->node[2] = UCXT.gen_real_node[2];
  out->node[3] = UCXT.gen_real_node[3];
  out->node[4] = UCXT.gen_real_node[4];
  out->node[5] = UCXT.gen_real_node[5];
  return UCXT.gen_has_real_node;
}


void uu_v0gen(pUCXT, struct uu *out) {
  out->time_low = 0;
  out->time_mid = 0;
  out->time_high_and_version = 0;
  out->clock_seq_and_variant = 0;
  out->node[0] = 0;
  out->node[1] = 0;
  out->node[2] = 0;
  out->node[3] = 0;
  out->node[4] = 0;
  out->node[5] = 0;
}

void uu_v1gen(pUCXT, struct uu *out) {
  U64   clock_reg;
  U16   clock_seq;

  uu_clock(aUCXT, &clock_reg, &clock_seq);
  clock_reg += (((U64)0x01b21dd2) << 32) + 0x13814000;

  out->time_low              = (U32)clock_reg;
  out->time_mid              = (U16)(clock_reg >> 32 & 0xffff);
  out->time_high_and_version = (U16)(clock_reg >> 48 & 0x0fff | 0x1000);
  out->clock_seq_and_variant = clock_seq & 0x3fff | 0x8000;

  if (UCXT.gen_use_unique) uu_gen_randomize(aUCXT);
  out->node[0] = UCXT.gen_node[0];
  out->node[1] = UCXT.gen_node[1];
  out->node[2] = UCXT.gen_node[2];
  out->node[3] = UCXT.gen_node[3];
  out->node[4] = UCXT.gen_node[4];
  out->node[5] = UCXT.gen_node[5];
}

void uu_v4gen(pUCXT, struct uu4 *out) {
  U64 *cp = (U64*)out;

  cc_rand64(aUCXT, cp++);
  cc_rand64(aUCXT, cp);
  out->rand_b_and_version = out->rand_b_and_version & 0xffff0fff | 0x00004000;
  out->rand_c_and_variant = out->rand_c_and_variant & 0x3fffffff | 0x80000000;
}

void uu_v6gen(pUCXT, struct uu6 *out) {
  U64   clock_reg;
  U16   clock_seq;

  uu_clock(aUCXT, &clock_reg, &clock_seq);
  clock_reg += (((U64)0x01b21dd2) << 32) + 0x13814000;

  out->time_high             = (U32)(clock_reg >> 28);
  out->time_mid              = (U16)(clock_reg >> 12);
  out->time_low_and_version  = (U16)clock_reg & 0x0fff | 0x6000;
  out->clock_seq_and_variant = clock_seq & 0x3fff | 0x8000;

  /* use the same node as v1 */
  if (UCXT.gen_use_unique) uu_gen_randomize(aUCXT);
  out->node[0] = UCXT.gen_node[0];
  out->node[1] = UCXT.gen_node[1];
  out->node[2] = UCXT.gen_node[2];
  out->node[3] = UCXT.gen_node[3];
  out->node[4] = UCXT.gen_node[4];
  out->node[5] = UCXT.gen_node[5];
}

void uu_v7gen(pUCXT, struct uu7 *out) {
  U64   clock_reg;
  U16   clock_seq;

  uu_clock(aUCXT, &clock_reg, &clock_seq);
  clock_reg /= 10000;

  cc_rand16(aUCXT, &out->rand_a_and_version);
  cc_rand64(aUCXT, &out->rand_b_and_variant);
  out->time_high             = (U32)(clock_reg >> 16);
  out->time_low              = (U16)(clock_reg & 0xffff);
  out->rand_a_and_version = out->rand_a_and_version & 0x0fff | 0x7000;
  out->rand_b_and_variant = out->rand_b_and_variant
    & 0x3fffffffffffffffULL
    | 0x8000000000000000ULL;
}

/* ex:set ts=2 sw=2 itab=spaces: */
