/* === S Y N F I G ========================================================= */
/*!	\file widget_color.cpp
**	\brief Template File
**
**	$Id$
**
**	\legal
**	Copyright (c) 2002-2005 Robert B. Quattlebaum Jr., Adrian Bentley
**
**	This package is free software; you can redistribute it and/or
**	modify it under the terms of the GNU General Public License as
**	published by the Free Software Foundation; either version 2 of
**	the License, or (at your option) any later version.
**
**	This package is distributed in the hope that it will be useful,
**	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**	General Public License for more details.
**	\endlegal
*/
/* ========================================================================= */

/* === H E A D E R S ======================================================= */

#ifdef USING_PCH
#	include "pch.h"
#else
#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#include <cmath>

#include <gtkmm/drawingarea.h>

#include <synfig/general.h>

#include <gui/app.h>
#include <gui/canvasview.h>

#include "widget_color.h"

#include <gui/localization.h>

#include <gui/exception_guard.h>

#endif

/* === U S I N G =========================================================== */

using namespace std;
using namespace etl;
using namespace synfig;
using namespace studio;

/* === M A C R O S ========================================================= */

/* === G L O B A L S ======================================================= */

/* === P R O C E D U R E S ================================================= */

void
studio::render_color_to_window(const Cairo::RefPtr<Cairo::Context> &cr, const Gdk::Rectangle &ca, const synfig::Color &color)
{
	const int height(ca.get_height());
	const int width(ca.get_width());

	const int square_size(height/2);

	Gamma gamma = App::get_selected_canvas_gamma().get_inverted();
	
	if(color.get_alpha()!=1.0)
	{
		// In this case we need to render the alpha squares

		const Color bg1 = gamma.apply(
			Color::blend(color,Color(0.75, 0.75, 0.75),1.0).clamped() );
		const Color bg2 = gamma.apply(
			Color::blend(color,Color(0.5, 0.5, 0.5),1.0).clamped() );

		bool toggle(false);
		for(int i=0;i<width;i+=square_size)
		{
			const int square_width(min(square_size,width-i));

			if(toggle)
			{
		        cr->set_source_rgb(bg1.get_r(), bg1.get_g(), bg1.get_b());
		        cr->rectangle(ca.get_x()+i, ca.get_y(), square_width, square_size);
		        cr->fill();

		        cr->set_source_rgb(bg2.get_r(), bg2.get_g(), bg2.get_b());
		        cr->rectangle(ca.get_x()+i, ca.get_y()+square_size, square_width, square_size);
		        cr->fill();
				toggle=false;
			}
			else
			{
		        cr->set_source_rgb(bg2.get_r(), bg2.get_g(), bg2.get_b());
		        cr->rectangle(ca.get_x()+i, ca.get_y(), square_width, square_size);
		        cr->fill();

		        cr->set_source_rgb(bg1.get_r(), bg1.get_g(), bg1.get_b());
		        cr->rectangle(ca.get_x()+i, ca.get_y()+square_size, square_width, square_size);
		        cr->fill();
				toggle=true;
			}
		}
	}
	else
	{
		synfig::Color c = gamma.apply(color.clamped());
        cr->set_source_rgb(c.get_r(), c.get_g(), c.get_b());
        cr->rectangle(ca.get_x(), ca.get_y(), width-1, height-1);
        cr->fill();
	}

	cr->set_source_rgb(1.0, 1.0, 1.0);
    cr->rectangle(ca.get_x()+1, ca.get_y()+1, width-3, height-3);
    cr->stroke();

    cr->set_source_rgb(0.0, 0.0, 0.0);
    cr->rectangle(ca.get_x(), ca.get_y(), width-1, height-1);
    cr->stroke();
}

/* === C L A S S E S ======================================================= */


/* === M E T H O D S ======================================================= */

Widget_Color::Widget_Color()
{
	color=Color(0,0,0,0);
	set_size_request(-1,16);
	add_events(Gdk::BUTTON_PRESS_MASK | Gdk::BUTTON_RELEASE_MASK);
	App::signal_canvas_view_focus().connect(
		sigc::hide(sigc::mem_fun(*this,&studio::Widget_Color::queue_draw)) );
}

Widget_Color::~Widget_Color()
{
}

void
Widget_Color::set_value(const synfig::Color &x)
{
	assert(x.is_valid());
	color=x;
	queue_draw();
}

const synfig::Color &
Widget_Color::get_value() const
{
	assert(color.is_valid());
	return color;
}

bool
Widget_Color::on_event(GdkEvent *event)
{
	SYNFIG_EXCEPTION_GUARD_BEGIN()
	switch(event->type)
	{
	case GDK_BUTTON_PRESS:
		if(event->button.button==1)
		{
			signal_activate_();
			return true;
		}
		if(event->button.button==2)
		{
			signal_middle_click_();
			return true;
		}
		if(event->button.button==3)
		{
			signal_right_click_();
			return true;
		}
		break;

	default:
		break;
	}
	return false;
	SYNFIG_EXCEPTION_GUARD_END_BOOL(true)
}

bool
Widget_Color::on_draw(const Cairo::RefPtr<Cairo::Context> &cr)
{
	render_color_to_window(cr, Gdk::Rectangle(0,0,get_width(),get_height()), color);
	return true;
}
