#ifndef PWMDOC_H
#define PWMDOC_H

#include <set>
#include <vector>
#include <string>
#include <algorithm>
#include <map>
#include "tinyxml.h"

struct PWMNode {
	public:
		enum { ntUnknown, ntSeq, ntLi, ntDescription } nodeType;
		std::map<std::string, std::string> attrs;
		std::vector<PWMNode> children;

	public:
		PWMNode() {
			nodeType = ntUnknown;
		}
};

struct PWMDoc {
	public:
		PWMNode mainNode;
		std::string ns;

	public:
		std::string findNamespace(TiXmlHandle *docHandle) {
			std::string ns = "";
			TiXmlElement *defaultNode = docHandle->FirstChildElement("RDF:RDF").Element();
			if(defaultNode) {
				TiXmlAttribute *attrib = defaultNode->FirstAttribute();
				while(attrib) {
					if(!strcmp(attrib->Value(), "http://passwordmaker.mozdev.org/rdf#")) {
						ns = attrib->Name();
						ns.erase(ns.begin(), ns.begin() + (ns.find(':')+1));
						break;
					}
				}
			}

			return ns;
		}

		PWMDoc() {
		}

		TiXmlElement *findSeq(TiXmlHandle *docHandle, std::string about) {
			TiXmlElement *defaultNode = docHandle->FirstChildElement("RDF:RDF").FirstChildElement("RDF:Seq").Element();

			while(defaultNode) {
				if(about.compare(defaultNode->Attribute("RDF:about"))==0)
					break;
				defaultNode = defaultNode->NextSiblingElement("RDF:Seq");
			}

			return defaultNode;
		}

		bool load(std::string filepath) {
			TiXmlDocument document(filepath);
			document.LoadFile();
			if(document.Error()) {
				return false;
			}

			TiXmlHandle docHandle(&document);
			ns = findNamespace(&docHandle);
			if(ns.size()==0)
				return false;
		}

		PWMNode loadSeq(TiXmlHandle *docHandle, TiXmlElement *seqNode) {
			PWMNode node;

			node.nodeType = ntSeq;
			TiXmlAttribute *attrib = seqNode->FirstAttribute();
			while(attrib) {
				node.attrs[std::string(attrib->Name())] = std::string(attrib->Value());
				attrib = attrib->Next();
			}

		}

};

#endif
