# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
import json
from typing import Any, Callable, IO, Iterator, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core import PipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.polling import LROPoller, NoPolling, PollingMethod
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.arm_polling import ARMPolling

from .. import models as _models
from .._configuration import QuotaMgmtClientConfiguration
from .._utils.model_base import SdkJSONEncoder, _deserialize, _failsafe_deserialize
from .._utils.serialization import Deserializer, Serializer

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, dict[str, Any]], Any]]
JSON = MutableMapping[str, Any]
List = list

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_quota_operation_list_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/providers/Microsoft.Quota/operations"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_quota_request_status_get_request(id: str, scope: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/{scope}/providers/Microsoft.Quota/quotaRequests/{id}"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
        "scope": _SERIALIZER.url("scope", scope, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_quota_request_status_list_request(
    scope: str,
    *,
    filter: Optional[str] = None,
    top: Optional[int] = None,
    skiptoken: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/{scope}/providers/Microsoft.Quota/quotaRequests"
    path_format_arguments = {
        "scope": _SERIALIZER.url("scope", scope, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if top is not None:
        _params["$top"] = _SERIALIZER.query("top", top, "int")
    if skiptoken is not None:
        _params["$skiptoken"] = _SERIALIZER.query("skiptoken", skiptoken, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_group_quotas_get_request(management_group_id: str, group_quota_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}"
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
        "groupQuotaName": _SERIALIZER.url("group_quota_name", group_quota_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_group_quotas_create_or_update_request(  # pylint: disable=name-too-long
    management_group_id: str, group_quota_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}"
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
        "groupQuotaName": _SERIALIZER.url("group_quota_name", group_quota_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_group_quotas_update_request(management_group_id: str, group_quota_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}"
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
        "groupQuotaName": _SERIALIZER.url("group_quota_name", group_quota_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_group_quotas_delete_request(management_group_id: str, group_quota_name: str, **kwargs: Any) -> HttpRequest:
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    # Construct URL
    _url = "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}"
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
        "groupQuotaName": _SERIALIZER.url("group_quota_name", group_quota_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, **kwargs)


def build_group_quotas_list_request(management_group_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas"
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_group_quota_limits_request_list_request(  # pylint: disable=name-too-long
    management_group_id: str, group_quota_name: str, resource_provider_name: str, *, filter: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/groupQuotaRequests"
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
        "groupQuotaName": _SERIALIZER.url("group_quota_name", group_quota_name, "str"),
        "resourceProviderName": _SERIALIZER.url("resource_provider_name", resource_provider_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    _params["$filter"] = _SERIALIZER.query("filter", filter, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_group_quota_limits_request_update_request(  # pylint: disable=name-too-long
    management_group_id: str, group_quota_name: str, resource_provider_name: str, location: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/groupQuotaLimits/{location}"
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
        "groupQuotaName": _SERIALIZER.url("group_quota_name", group_quota_name, "str"),
        "resourceProviderName": _SERIALIZER.url("resource_provider_name", resource_provider_name, "str"),
        "location": _SERIALIZER.url("location", location, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_group_quota_limits_request_get_request(  # pylint: disable=name-too-long
    management_group_id: str, group_quota_name: str, request_id_parameter: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/groupQuotaRequests/{requestId}"
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
        "groupQuotaName": _SERIALIZER.url("group_quota_name", group_quota_name, "str"),
        "requestId": _SERIALIZER.url("request_id_parameter", request_id_parameter, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_group_quota_usages_list_request(
    management_group_id: str, group_quota_name: str, resource_provider_name: str, location: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/locationUsages/{location}"
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
        "groupQuotaName": _SERIALIZER.url("group_quota_name", group_quota_name, "str"),
        "resourceProviderName": _SERIALIZER.url("resource_provider_name", resource_provider_name, "str"),
        "location": _SERIALIZER.url("location", location, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_group_quota_subscriptions_get_request(  # pylint: disable=name-too-long
    management_group_id: str, group_quota_name: str, subscription_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/subscriptions/{subscriptionId}"
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
        "groupQuotaName": _SERIALIZER.url("group_quota_name", group_quota_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_group_quota_subscriptions_create_or_update_request(  # pylint: disable=name-too-long
    management_group_id: str, group_quota_name: str, subscription_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/subscriptions/{subscriptionId}"
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
        "groupQuotaName": _SERIALIZER.url("group_quota_name", group_quota_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_group_quota_subscriptions_update_request(  # pylint: disable=name-too-long
    management_group_id: str, group_quota_name: str, subscription_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/subscriptions/{subscriptionId}"
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
        "groupQuotaName": _SERIALIZER.url("group_quota_name", group_quota_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_group_quota_subscriptions_delete_request(  # pylint: disable=name-too-long
    management_group_id: str, group_quota_name: str, subscription_id: str, **kwargs: Any
) -> HttpRequest:
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    # Construct URL
    _url = "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/subscriptions/{subscriptionId}"
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
        "groupQuotaName": _SERIALIZER.url("group_quota_name", group_quota_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, **kwargs)


def build_group_quota_subscriptions_list_request(  # pylint: disable=name-too-long
    management_group_id: str, group_quota_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/subscriptions"
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
        "groupQuotaName": _SERIALIZER.url("group_quota_name", group_quota_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_group_quota_subscription_requests_get_request(  # pylint: disable=name-too-long
    management_group_id: str, group_quota_name: str, request_id_parameter: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/subscriptionRequests/{requestId}"
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
        "groupQuotaName": _SERIALIZER.url("group_quota_name", group_quota_name, "str"),
        "requestId": _SERIALIZER.url("request_id_parameter", request_id_parameter, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_group_quota_subscription_requests_list_request(  # pylint: disable=name-too-long
    management_group_id: str, group_quota_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/subscriptionRequests"
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
        "groupQuotaName": _SERIALIZER.url("group_quota_name", group_quota_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_group_quota_limits_list_request(
    management_group_id: str, group_quota_name: str, resource_provider_name: str, location: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/groupQuotaLimits/{location}"
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
        "groupQuotaName": _SERIALIZER.url("group_quota_name", group_quota_name, "str"),
        "resourceProviderName": _SERIALIZER.url("resource_provider_name", resource_provider_name, "str"),
        "location": _SERIALIZER.url("location", location, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_group_quota_subscription_allocation_list_request(  # pylint: disable=name-too-long
    management_group_id: str,
    group_quota_name: str,
    resource_provider_name: str,
    location: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/providers/Microsoft.Management/managementGroups/{managementGroupId}/subscriptions/{subscriptionId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/quotaAllocations/{location}"
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "groupQuotaName": _SERIALIZER.url("group_quota_name", group_quota_name, "str"),
        "resourceProviderName": _SERIALIZER.url("resource_provider_name", resource_provider_name, "str"),
        "location": _SERIALIZER.url("location", location, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_group_quota_subscription_allocation_request_update_request(  # pylint: disable=name-too-long
    management_group_id: str,
    group_quota_name: str,
    resource_provider_name: str,
    location: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/providers/Microsoft.Management/managementGroups/{managementGroupId}/subscriptions/{subscriptionId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/quotaAllocations/{location}"
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "groupQuotaName": _SERIALIZER.url("group_quota_name", group_quota_name, "str"),
        "resourceProviderName": _SERIALIZER.url("resource_provider_name", resource_provider_name, "str"),
        "location": _SERIALIZER.url("location", location, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_group_quota_subscription_allocation_request_get_request(  # pylint: disable=name-too-long
    management_group_id: str,
    group_quota_name: str,
    resource_provider_name: str,
    allocation_id: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/providers/Microsoft.Management/managementGroups/{managementGroupId}/subscriptions/{subscriptionId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/quotaAllocationRequests/{allocationId}"
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "groupQuotaName": _SERIALIZER.url("group_quota_name", group_quota_name, "str"),
        "resourceProviderName": _SERIALIZER.url("resource_provider_name", resource_provider_name, "str"),
        "allocationId": _SERIALIZER.url("allocation_id", allocation_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_group_quota_subscription_allocation_request_list_request(  # pylint: disable=name-too-long
    management_group_id: str,
    group_quota_name: str,
    resource_provider_name: str,
    subscription_id: str,
    *,
    filter: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/providers/Microsoft.Management/managementGroups/{managementGroupId}/subscriptions/{subscriptionId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/quotaAllocationRequests"
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "groupQuotaName": _SERIALIZER.url("group_quota_name", group_quota_name, "str"),
        "resourceProviderName": _SERIALIZER.url("resource_provider_name", resource_provider_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    _params["$filter"] = _SERIALIZER.query("filter", filter, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_group_quota_location_settings_get_request(  # pylint: disable=name-too-long
    management_group_id: str, group_quota_name: str, resource_provider_name: str, location: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/locationSettings/{location}"
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
        "groupQuotaName": _SERIALIZER.url("group_quota_name", group_quota_name, "str"),
        "resourceProviderName": _SERIALIZER.url("resource_provider_name", resource_provider_name, "str"),
        "location": _SERIALIZER.url("location", location, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_group_quota_location_settings_create_or_update_request(  # pylint: disable=name-too-long
    management_group_id: str, group_quota_name: str, resource_provider_name: str, location: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/locationSettings/{location}"
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
        "groupQuotaName": _SERIALIZER.url("group_quota_name", group_quota_name, "str"),
        "resourceProviderName": _SERIALIZER.url("resource_provider_name", resource_provider_name, "str"),
        "location": _SERIALIZER.url("location", location, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_group_quota_location_settings_update_request(  # pylint: disable=name-too-long
    management_group_id: str, group_quota_name: str, resource_provider_name: str, location: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/locationSettings/{location}"
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
        "groupQuotaName": _SERIALIZER.url("group_quota_name", group_quota_name, "str"),
        "resourceProviderName": _SERIALIZER.url("resource_provider_name", resource_provider_name, "str"),
        "location": _SERIALIZER.url("location", location, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_usages_get_request(resource_name: str, scope: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/{scope}/providers/Microsoft.Quota/usages/{resourceName}"
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "scope": _SERIALIZER.url("scope", scope, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_usages_list_request(scope: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/{scope}/providers/Microsoft.Quota/usages"
    path_format_arguments = {
        "scope": _SERIALIZER.url("scope", scope, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_quota_get_request(resource_name: str, scope: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/{scope}/providers/Microsoft.Quota/quotas/{resourceName}"
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "scope": _SERIALIZER.url("scope", scope, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_quota_create_or_update_request(resource_name: str, scope: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/{scope}/providers/Microsoft.Quota/quotas/{resourceName}"
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "scope": _SERIALIZER.url("scope", scope, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_quota_update_request(resource_name: str, scope: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/{scope}/providers/Microsoft.Quota/quotas/{resourceName}"
    path_format_arguments = {
        "resourceName": _SERIALIZER.url("resource_name", resource_name, "str"),
        "scope": _SERIALIZER.url("scope", scope, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_quota_list_request(scope: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-09-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/{scope}/providers/Microsoft.Quota/quotas"
    path_format_arguments = {
        "scope": _SERIALIZER.url("scope", scope, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


class QuotaOperationOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.quota.QuotaMgmtClient`'s
        :attr:`quota_operation` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: QuotaMgmtClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(self, **kwargs: Any) -> ItemPaged["_models.OperationResponse"]:
        """List the operations for the provider.

        :return: An iterator like instance of OperationResponse
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.quota.models.OperationResponse]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.OperationResponse]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_quota_operation_list_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.OperationResponse], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ExceptionResponse, response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)


class QuotaRequestStatusOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.quota.QuotaMgmtClient`'s
        :attr:`quota_request_status` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: QuotaMgmtClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def get(self, id: str, scope: str, **kwargs: Any) -> _models.QuotaRequestDetails:
        """Get the quota request details and status by quota request ID for the resources of the resource
        provider at a specific location. The quota request ID **id** is returned in the response of the
        PUT operation.

        :param id: Quota request ID. Required.
        :type id: str
        :param scope: The fully qualified Azure Resource manager identifier of the resource. Required.
        :type scope: str
        :return: QuotaRequestDetails. The QuotaRequestDetails is compatible with MutableMapping
        :rtype: ~azure.mgmt.quota.models.QuotaRequestDetails
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.QuotaRequestDetails] = kwargs.pop("cls", None)

        _request = build_quota_request_status_get_request(
            id=id,
            scope=scope,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ExceptionResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.QuotaRequestDetails, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list(
        self,
        scope: str,
        *,
        filter: Optional[str] = None,
        top: Optional[int] = None,
        skiptoken: Optional[str] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.QuotaRequestDetails"]:
        """For the specified scope, get the current quota requests for a one year period ending at the
        time is made. Use the **oData** filter to select quota requests.

        :param scope: The fully qualified Azure Resource manager identifier of the resource. Required.
        :type scope: str
        :keyword filter: | Field                    | Supported operators
         |---------------------|------------------------

         |requestSubmitTime | ge, le, eq, gt, lt
         |provisioningState eq {QuotaRequestState}
         |resourceName eq {resourceName}. Default value is None.
        :paramtype filter: str
        :keyword top: Number of records to return. Default value is None.
        :paramtype top: int
        :keyword skiptoken: The **Skiptoken** parameter is used only if a previous operation returned a
         partial result. If a previous response contains a **nextLink** element, its value includes a
         **skiptoken** parameter that specifies a starting point to use for subsequent calls. Default
         value is None.
        :paramtype skiptoken: str
        :return: An iterator like instance of QuotaRequestDetails
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.quota.models.QuotaRequestDetails]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.QuotaRequestDetails]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_quota_request_status_list_request(
                    scope=scope,
                    filter=filter,
                    top=top,
                    skiptoken=skiptoken,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.QuotaRequestDetails], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ExceptionResponse, response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)


class GroupQuotasOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.quota.QuotaMgmtClient`'s
        :attr:`group_quotas` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: QuotaMgmtClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def get(self, management_group_id: str, group_quota_name: str, **kwargs: Any) -> _models.GroupQuotasEntity:
        """Gets the GroupQuotas for the name passed. It will return the GroupQuotas properties only. The
        details on group quota can be access from the group quota APIs.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :return: GroupQuotasEntity. The GroupQuotasEntity is compatible with MutableMapping
        :rtype: ~azure.mgmt.quota.models.GroupQuotasEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.GroupQuotasEntity] = kwargs.pop("cls", None)

        _request = build_group_quotas_get_request(
            management_group_id=management_group_id,
            group_quota_name=group_quota_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.GroupQuotasEntity, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    def _create_or_update_initial(
        self,
        management_group_id: str,
        group_quota_name: str,
        group_quota_put_request_body: Optional[Union[_models.GroupQuotasEntity, JSON, IO[bytes]]] = None,
        **kwargs: Any
    ) -> Iterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if group_quota_put_request_body else None
        cls: ClsType[Iterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json" if group_quota_put_request_body else None
        _content = None
        if isinstance(group_quota_put_request_body, (IOBase, bytes)):
            _content = group_quota_put_request_body
        else:
            if group_quota_put_request_body is not None:
                _content = json.dumps(group_quota_put_request_body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_group_quotas_create_or_update_request(
            management_group_id=management_group_id,
            group_quota_name=group_quota_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            try:
                response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 201:
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    def begin_create_or_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        group_quota_put_request_body: Optional[_models.GroupQuotasEntity] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotasEntity]:
        """Creates a new GroupQuota for the name passed. A RequestId will be returned by the Service. The
        status can be polled periodically. The status Async polling is using standards defined at -
        `https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/async-api-reference.md#asynchronous-operations
        <https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/async-api-reference.md#asynchronous-operations>`_.
        Use the OperationsStatus URI provided in Azure-AsyncOperation header, the duration will be
        specified in retry-after header. Once the operation gets to terminal state - Succeeded |
        Failed, then the URI will change to Get URI and full details can be checked.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param group_quota_put_request_body: The GroupQuota body details for creation or update of a
         GroupQuota entity. Default value is None.
        :type group_quota_put_request_body: ~azure.mgmt.quota.models.GroupQuotasEntity
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns GroupQuotasEntity. The GroupQuotasEntity is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotasEntity]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_create_or_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        group_quota_put_request_body: Optional[JSON] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotasEntity]:
        """Creates a new GroupQuota for the name passed. A RequestId will be returned by the Service. The
        status can be polled periodically. The status Async polling is using standards defined at -
        `https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/async-api-reference.md#asynchronous-operations
        <https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/async-api-reference.md#asynchronous-operations>`_.
        Use the OperationsStatus URI provided in Azure-AsyncOperation header, the duration will be
        specified in retry-after header. Once the operation gets to terminal state - Succeeded |
        Failed, then the URI will change to Get URI and full details can be checked.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param group_quota_put_request_body: The GroupQuota body details for creation or update of a
         GroupQuota entity. Default value is None.
        :type group_quota_put_request_body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns GroupQuotasEntity. The GroupQuotasEntity is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotasEntity]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_create_or_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        group_quota_put_request_body: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotasEntity]:
        """Creates a new GroupQuota for the name passed. A RequestId will be returned by the Service. The
        status can be polled periodically. The status Async polling is using standards defined at -
        `https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/async-api-reference.md#asynchronous-operations
        <https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/async-api-reference.md#asynchronous-operations>`_.
        Use the OperationsStatus URI provided in Azure-AsyncOperation header, the duration will be
        specified in retry-after header. Once the operation gets to terminal state - Succeeded |
        Failed, then the URI will change to Get URI and full details can be checked.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param group_quota_put_request_body: The GroupQuota body details for creation or update of a
         GroupQuota entity. Default value is None.
        :type group_quota_put_request_body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns GroupQuotasEntity. The GroupQuotasEntity is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotasEntity]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_create_or_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        group_quota_put_request_body: Optional[Union[_models.GroupQuotasEntity, JSON, IO[bytes]]] = None,
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotasEntity]:
        """Creates a new GroupQuota for the name passed. A RequestId will be returned by the Service. The
        status can be polled periodically. The status Async polling is using standards defined at -
        `https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/async-api-reference.md#asynchronous-operations
        <https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/async-api-reference.md#asynchronous-operations>`_.
        Use the OperationsStatus URI provided in Azure-AsyncOperation header, the duration will be
        specified in retry-after header. Once the operation gets to terminal state - Succeeded |
        Failed, then the URI will change to Get URI and full details can be checked.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param group_quota_put_request_body: The GroupQuota body details for creation or update of a
         GroupQuota entity. Is one of the following types: GroupQuotasEntity, JSON, IO[bytes] Default
         value is None.
        :type group_quota_put_request_body: ~azure.mgmt.quota.models.GroupQuotasEntity or JSON or
         IO[bytes]
        :return: An instance of LROPoller that returns GroupQuotasEntity. The GroupQuotasEntity is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotasEntity]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if group_quota_put_request_body else None
        cls: ClsType[_models.GroupQuotasEntity] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._create_or_update_initial(
                management_group_id=management_group_id,
                group_quota_name=group_quota_name,
                group_quota_put_request_body=group_quota_put_request_body,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = _deserialize(_models.GroupQuotasEntity, response.json())
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, ARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[_models.GroupQuotasEntity].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[_models.GroupQuotasEntity](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    def _update_initial(
        self,
        management_group_id: str,
        group_quota_name: str,
        group_quotas_patch_request_body: Optional[Union[_models.GroupQuotasEntityPatch, JSON, IO[bytes]]] = None,
        **kwargs: Any
    ) -> Iterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if group_quotas_patch_request_body else None
        cls: ClsType[Iterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json" if group_quotas_patch_request_body else None
        _content = None
        if isinstance(group_quotas_patch_request_body, (IOBase, bytes)):
            _content = group_quotas_patch_request_body
        else:
            if group_quotas_patch_request_body is not None:
                _content = json.dumps(group_quotas_patch_request_body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_group_quotas_update_request(
            management_group_id=management_group_id,
            group_quota_name=group_quota_name,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    def begin_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        group_quotas_patch_request_body: Optional[_models.GroupQuotasEntityPatch] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotasEntity]:
        """Updates the GroupQuotas for the name passed. A GroupQuotas RequestId will be returned by the
        Service. The status can be polled periodically. The status Async polling is using standards
        defined at -
        `https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/async-api-reference.md#asynchronous-operations
        <https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/async-api-reference.md#asynchronous-operations>`_.
        Use the OperationsStatus URI provided in Azure-AsyncOperation header, the duration will be
        specified in retry-after header. Once the operation gets to terminal state - Succeeded |
        Failed, then the URI will change to Get URI and full details can be checked.
        Any change in the filters will be applicable to the future quota assignments, existing quota
        allocated to subscriptions from the GroupQuotas remains unchanged.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param group_quotas_patch_request_body: The  GroupQuotas Patch Request. Default value is None.
        :type group_quotas_patch_request_body: ~azure.mgmt.quota.models.GroupQuotasEntityPatch
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns GroupQuotasEntity. The GroupQuotasEntity is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotasEntity]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        group_quotas_patch_request_body: Optional[JSON] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotasEntity]:
        """Updates the GroupQuotas for the name passed. A GroupQuotas RequestId will be returned by the
        Service. The status can be polled periodically. The status Async polling is using standards
        defined at -
        `https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/async-api-reference.md#asynchronous-operations
        <https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/async-api-reference.md#asynchronous-operations>`_.
        Use the OperationsStatus URI provided in Azure-AsyncOperation header, the duration will be
        specified in retry-after header. Once the operation gets to terminal state - Succeeded |
        Failed, then the URI will change to Get URI and full details can be checked.
        Any change in the filters will be applicable to the future quota assignments, existing quota
        allocated to subscriptions from the GroupQuotas remains unchanged.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param group_quotas_patch_request_body: The  GroupQuotas Patch Request. Default value is None.
        :type group_quotas_patch_request_body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns GroupQuotasEntity. The GroupQuotasEntity is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotasEntity]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        group_quotas_patch_request_body: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotasEntity]:
        """Updates the GroupQuotas for the name passed. A GroupQuotas RequestId will be returned by the
        Service. The status can be polled periodically. The status Async polling is using standards
        defined at -
        `https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/async-api-reference.md#asynchronous-operations
        <https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/async-api-reference.md#asynchronous-operations>`_.
        Use the OperationsStatus URI provided in Azure-AsyncOperation header, the duration will be
        specified in retry-after header. Once the operation gets to terminal state - Succeeded |
        Failed, then the URI will change to Get URI and full details can be checked.
        Any change in the filters will be applicable to the future quota assignments, existing quota
        allocated to subscriptions from the GroupQuotas remains unchanged.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param group_quotas_patch_request_body: The  GroupQuotas Patch Request. Default value is None.
        :type group_quotas_patch_request_body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns GroupQuotasEntity. The GroupQuotasEntity is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotasEntity]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        group_quotas_patch_request_body: Optional[Union[_models.GroupQuotasEntityPatch, JSON, IO[bytes]]] = None,
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotasEntity]:
        """Updates the GroupQuotas for the name passed. A GroupQuotas RequestId will be returned by the
        Service. The status can be polled periodically. The status Async polling is using standards
        defined at -
        `https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/async-api-reference.md#asynchronous-operations
        <https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/async-api-reference.md#asynchronous-operations>`_.
        Use the OperationsStatus URI provided in Azure-AsyncOperation header, the duration will be
        specified in retry-after header. Once the operation gets to terminal state - Succeeded |
        Failed, then the URI will change to Get URI and full details can be checked.
        Any change in the filters will be applicable to the future quota assignments, existing quota
        allocated to subscriptions from the GroupQuotas remains unchanged.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param group_quotas_patch_request_body: The  GroupQuotas Patch Request. Is one of the following
         types: GroupQuotasEntityPatch, JSON, IO[bytes] Default value is None.
        :type group_quotas_patch_request_body: ~azure.mgmt.quota.models.GroupQuotasEntityPatch or JSON
         or IO[bytes]
        :return: An instance of LROPoller that returns GroupQuotasEntity. The GroupQuotasEntity is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotasEntity]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if group_quotas_patch_request_body else None
        cls: ClsType[_models.GroupQuotasEntity] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._update_initial(
                management_group_id=management_group_id,
                group_quota_name=group_quota_name,
                group_quotas_patch_request_body=group_quotas_patch_request_body,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = _deserialize(_models.GroupQuotasEntity, response.json())
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, ARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[_models.GroupQuotasEntity].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[_models.GroupQuotasEntity](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    def _delete_initial(self, management_group_id: str, group_quota_name: str, **kwargs: Any) -> Iterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Iterator[bytes]] = kwargs.pop("cls", None)

        _request = build_group_quotas_delete_request(
            management_group_id=management_group_id,
            group_quota_name=group_quota_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            try:
                response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def begin_delete(self, management_group_id: str, group_quota_name: str, **kwargs: Any) -> LROPoller[None]:
        """Deletes the GroupQuotas for the name passed. All the remaining shareQuota in the GroupQuotas
        will be lost.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :return: An instance of LROPoller that returns None
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._delete_initial(
                management_group_id=management_group_id,
                group_quota_name=group_quota_name,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, ARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def list(self, management_group_id: str, **kwargs: Any) -> ItemPaged["_models.GroupQuotasEntity"]:
        """Lists GroupQuotas for the scope passed. It will return the GroupQuotas QuotaEntity properties
        only.The details on group quota can be access from the group quota APIs.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :return: An iterator like instance of GroupQuotasEntity
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.quota.models.GroupQuotasEntity]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.GroupQuotasEntity]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_group_quotas_list_request(
                    management_group_id=management_group_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.GroupQuotasEntity], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ErrorResponse, response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)


class GroupQuotaLimitsRequestOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.quota.QuotaMgmtClient`'s
        :attr:`group_quota_limits_request` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: QuotaMgmtClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        *,
        filter: str,
        **kwargs: Any
    ) -> ItemPaged["_models.SubmittedResourceRequestStatus"]:
        """Get API to check the status of a GroupQuota request by requestId.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :keyword filter: | Field | Supported operators
         \\r\\n|---------------------|------------------------\\n\\r\\n location eq {location} and
         resource eq {resourceName}\\n Example: $filter=location eq eastus and resourceName eq cores.
         Required.
        :paramtype filter: str
        :return: An iterator like instance of SubmittedResourceRequestStatus
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.quota.models.SubmittedResourceRequestStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.SubmittedResourceRequestStatus]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_group_quota_limits_request_list_request(
                    management_group_id=management_group_id,
                    group_quota_name=group_quota_name,
                    resource_provider_name=resource_provider_name,
                    filter=filter,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.SubmittedResourceRequestStatus], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ErrorResponse, response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    def _update_initial(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        location: str,
        group_quota_request: Optional[Union[_models.GroupQuotaLimitList, JSON, IO[bytes]]] = None,
        **kwargs: Any
    ) -> Iterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if group_quota_request else None
        cls: ClsType[Iterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json" if group_quota_request else None
        _content = None
        if isinstance(group_quota_request, (IOBase, bytes)):
            _content = group_quota_request
        else:
            if group_quota_request is not None:
                _content = json.dumps(group_quota_request, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_group_quota_limits_request_update_request(
            management_group_id=management_group_id,
            group_quota_name=group_quota_name,
            resource_provider_name=resource_provider_name,
            location=location,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    def begin_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        location: str,
        group_quota_request: Optional[_models.GroupQuotaLimitList] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotaLimitList]:
        """Create the GroupQuota requests for a specific ResourceProvider/Location/Resource. The
        resourceName properties are specified in the request body. Only 1 resource quota can be
        requested. Please note that patch request creates a new groupQuota request.
        Use the polling API - OperationsStatus URI specified in Azure-AsyncOperation header field, with
        retry-after duration in seconds to check the intermediate status. This API provides the finals
        status with the request details and status.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param location: The name of the Azure region. Required.
        :type location: str
        :param group_quota_request: The GroupQuotaRequest body details for specific
         resourceProvider/location/resources. Default value is None.
        :type group_quota_request: ~azure.mgmt.quota.models.GroupQuotaLimitList
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns GroupQuotaLimitList. The GroupQuotaLimitList is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotaLimitList]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        location: str,
        group_quota_request: Optional[JSON] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotaLimitList]:
        """Create the GroupQuota requests for a specific ResourceProvider/Location/Resource. The
        resourceName properties are specified in the request body. Only 1 resource quota can be
        requested. Please note that patch request creates a new groupQuota request.
        Use the polling API - OperationsStatus URI specified in Azure-AsyncOperation header field, with
        retry-after duration in seconds to check the intermediate status. This API provides the finals
        status with the request details and status.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param location: The name of the Azure region. Required.
        :type location: str
        :param group_quota_request: The GroupQuotaRequest body details for specific
         resourceProvider/location/resources. Default value is None.
        :type group_quota_request: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns GroupQuotaLimitList. The GroupQuotaLimitList is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotaLimitList]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        location: str,
        group_quota_request: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotaLimitList]:
        """Create the GroupQuota requests for a specific ResourceProvider/Location/Resource. The
        resourceName properties are specified in the request body. Only 1 resource quota can be
        requested. Please note that patch request creates a new groupQuota request.
        Use the polling API - OperationsStatus URI specified in Azure-AsyncOperation header field, with
        retry-after duration in seconds to check the intermediate status. This API provides the finals
        status with the request details and status.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param location: The name of the Azure region. Required.
        :type location: str
        :param group_quota_request: The GroupQuotaRequest body details for specific
         resourceProvider/location/resources. Default value is None.
        :type group_quota_request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns GroupQuotaLimitList. The GroupQuotaLimitList is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotaLimitList]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        location: str,
        group_quota_request: Optional[Union[_models.GroupQuotaLimitList, JSON, IO[bytes]]] = None,
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotaLimitList]:
        """Create the GroupQuota requests for a specific ResourceProvider/Location/Resource. The
        resourceName properties are specified in the request body. Only 1 resource quota can be
        requested. Please note that patch request creates a new groupQuota request.
        Use the polling API - OperationsStatus URI specified in Azure-AsyncOperation header field, with
        retry-after duration in seconds to check the intermediate status. This API provides the finals
        status with the request details and status.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param location: The name of the Azure region. Required.
        :type location: str
        :param group_quota_request: The GroupQuotaRequest body details for specific
         resourceProvider/location/resources. Is one of the following types: GroupQuotaLimitList, JSON,
         IO[bytes] Default value is None.
        :type group_quota_request: ~azure.mgmt.quota.models.GroupQuotaLimitList or JSON or IO[bytes]
        :return: An instance of LROPoller that returns GroupQuotaLimitList. The GroupQuotaLimitList is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotaLimitList]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if group_quota_request else None
        cls: ClsType[_models.GroupQuotaLimitList] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._update_initial(
                management_group_id=management_group_id,
                group_quota_name=group_quota_name,
                resource_provider_name=resource_provider_name,
                location=location,
                group_quota_request=group_quota_request,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = _deserialize(_models.GroupQuotaLimitList, response.json())
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, ARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[_models.GroupQuotaLimitList].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[_models.GroupQuotaLimitList](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def get(
        self, management_group_id: str, group_quota_name: str, request_id_parameter: str, **kwargs: Any
    ) -> _models.SubmittedResourceRequestStatus:
        """Get API to check the status of a GroupQuota request by requestId.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param request_id_parameter: Request Id. Required.
        :type request_id_parameter: str
        :return: SubmittedResourceRequestStatus. The SubmittedResourceRequestStatus is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.quota.models.SubmittedResourceRequestStatus
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.SubmittedResourceRequestStatus] = kwargs.pop("cls", None)

        _request = build_group_quota_limits_request_get_request(
            management_group_id=management_group_id,
            group_quota_name=group_quota_name,
            request_id_parameter=request_id_parameter,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.SubmittedResourceRequestStatus, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class GroupQuotaUsagesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.quota.QuotaMgmtClient`'s
        :attr:`group_quota_usages` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: QuotaMgmtClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self, management_group_id: str, group_quota_name: str, resource_provider_name: str, location: str, **kwargs: Any
    ) -> ItemPaged["_models.ResourceUsages"]:
        """Gets the GroupQuotas usages and limits(quota). Location is required paramter.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param location: The name of the Azure region. Required.
        :type location: str
        :return: An iterator like instance of ResourceUsages
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.quota.models.ResourceUsages]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.ResourceUsages]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_group_quota_usages_list_request(
                    management_group_id=management_group_id,
                    group_quota_name=group_quota_name,
                    resource_provider_name=resource_provider_name,
                    location=location,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.ResourceUsages], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ErrorResponse, response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)


class GroupQuotaSubscriptionsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.quota.QuotaMgmtClient`'s
        :attr:`group_quota_subscriptions` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: QuotaMgmtClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def get(self, management_group_id: str, group_quota_name: str, **kwargs: Any) -> _models.GroupQuotaSubscriptionId:
        """Returns the subscriptionIds along with its provisioning state for being associated with the
        GroupQuota. If the subscription is not a member of GroupQuota, it will return 404, else 200.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :return: GroupQuotaSubscriptionId. The GroupQuotaSubscriptionId is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.quota.models.GroupQuotaSubscriptionId
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.GroupQuotaSubscriptionId] = kwargs.pop("cls", None)

        _request = build_group_quota_subscriptions_get_request(
            management_group_id=management_group_id,
            group_quota_name=group_quota_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.GroupQuotaSubscriptionId, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    def _create_or_update_initial(
        self, management_group_id: str, group_quota_name: str, **kwargs: Any
    ) -> Iterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Iterator[bytes]] = kwargs.pop("cls", None)

        _request = build_group_quota_subscriptions_create_or_update_request(
            management_group_id=management_group_id,
            group_quota_name=group_quota_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            try:
                response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 201:
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def begin_create_or_update(
        self, management_group_id: str, group_quota_name: str, **kwargs: Any
    ) -> LROPoller[_models.GroupQuotaSubscriptionId]:
        """Adds a subscription to GroupQuotas. The subscriptions will be validated based on the
        additionalAttributes defined in the GroupQuota. The additionalAttributes works as filter for
        the subscriptions, which can be included in the GroupQuotas. The request's TenantId is
        validated against the subscription's TenantId.

        :param management_group_id: Management Group Id. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :return: An instance of LROPoller that returns GroupQuotaSubscriptionId. The
         GroupQuotaSubscriptionId is compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotaSubscriptionId]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.GroupQuotaSubscriptionId] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._create_or_update_initial(
                management_group_id=management_group_id,
                group_quota_name=group_quota_name,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = _deserialize(_models.GroupQuotaSubscriptionId, response.json())
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, ARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[_models.GroupQuotaSubscriptionId].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[_models.GroupQuotaSubscriptionId](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    def _update_initial(self, management_group_id: str, group_quota_name: str, **kwargs: Any) -> Iterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Iterator[bytes]] = kwargs.pop("cls", None)

        _request = build_group_quota_subscriptions_update_request(
            management_group_id=management_group_id,
            group_quota_name=group_quota_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def begin_update(
        self, management_group_id: str, group_quota_name: str, **kwargs: Any
    ) -> LROPoller[_models.GroupQuotaSubscriptionId]:
        """Updates the GroupQuotas with the subscription to add to the subscriptions list. The
        subscriptions will be validated if additionalAttributes are defined in the GroupQuota. The
        request's TenantId is validated against the subscription's TenantId.

        :param management_group_id: Management Group Id. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :return: An instance of LROPoller that returns GroupQuotaSubscriptionId. The
         GroupQuotaSubscriptionId is compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotaSubscriptionId]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.GroupQuotaSubscriptionId] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._update_initial(
                management_group_id=management_group_id,
                group_quota_name=group_quota_name,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = _deserialize(_models.GroupQuotaSubscriptionId, response.json())
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, ARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[_models.GroupQuotaSubscriptionId].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[_models.GroupQuotaSubscriptionId](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    def _delete_initial(self, management_group_id: str, group_quota_name: str, **kwargs: Any) -> Iterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Iterator[bytes]] = kwargs.pop("cls", None)

        _request = build_group_quota_subscriptions_delete_request(
            management_group_id=management_group_id,
            group_quota_name=group_quota_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            try:
                response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def begin_delete(self, management_group_id: str, group_quota_name: str, **kwargs: Any) -> LROPoller[None]:
        """Removes the subscription from GroupQuotas. The request's TenantId is validated against the
        subscription's TenantId.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :return: An instance of LROPoller that returns None
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._delete_initial(
                management_group_id=management_group_id,
                group_quota_name=group_quota_name,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, ARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def list(
        self, management_group_id: str, group_quota_name: str, **kwargs: Any
    ) -> ItemPaged["_models.GroupQuotaSubscriptionId"]:
        """Returns a list of the subscriptionIds associated with the GroupQuotas.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :return: An iterator like instance of GroupQuotaSubscriptionId
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.quota.models.GroupQuotaSubscriptionId]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.GroupQuotaSubscriptionId]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_group_quota_subscriptions_list_request(
                    management_group_id=management_group_id,
                    group_quota_name=group_quota_name,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.GroupQuotaSubscriptionId], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ErrorResponse, response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)


class GroupQuotaSubscriptionRequestsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.quota.QuotaMgmtClient`'s
        :attr:`group_quota_subscription_requests` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: QuotaMgmtClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def get(
        self, management_group_id: str, group_quota_name: str, request_id_parameter: str, **kwargs: Any
    ) -> _models.GroupQuotaSubscriptionRequestStatus:
        """Get API to check the status of a subscriptionIds request by requestId.  Use the polling API -
        OperationsStatus URI specified in Azure-AsyncOperation header field, with retry-after duration
        in seconds to check the intermediate status. This API provides the finals status with the
        request details and status.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param request_id_parameter: Request Id. Required.
        :type request_id_parameter: str
        :return: GroupQuotaSubscriptionRequestStatus. The GroupQuotaSubscriptionRequestStatus is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.quota.models.GroupQuotaSubscriptionRequestStatus
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.GroupQuotaSubscriptionRequestStatus] = kwargs.pop("cls", None)

        _request = build_group_quota_subscription_requests_get_request(
            management_group_id=management_group_id,
            group_quota_name=group_quota_name,
            request_id_parameter=request_id_parameter,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.GroupQuotaSubscriptionRequestStatus, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list(
        self, management_group_id: str, group_quota_name: str, **kwargs: Any
    ) -> ItemPaged["_models.GroupQuotaSubscriptionRequestStatus"]:
        """List API to check the status of a subscriptionId requests by requestId. Request history is
        maintained for 1 year.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :return: An iterator like instance of GroupQuotaSubscriptionRequestStatus
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.mgmt.quota.models.GroupQuotaSubscriptionRequestStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.GroupQuotaSubscriptionRequestStatus]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_group_quota_subscription_requests_list_request(
                    management_group_id=management_group_id,
                    group_quota_name=group_quota_name,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(
                List[_models.GroupQuotaSubscriptionRequestStatus], deserialized.get("value", [])
            )
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ErrorResponse, response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)


class GroupQuotaLimitsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.quota.QuotaMgmtClient`'s
        :attr:`group_quota_limits` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: QuotaMgmtClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self, management_group_id: str, group_quota_name: str, resource_provider_name: str, location: str, **kwargs: Any
    ) -> _models.GroupQuotaLimitList:
        """Gets the GroupQuotaLimits for the specified resource provider and location for resource names
        passed in $filter=resourceName eq {SKU}.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param location: The name of the Azure region. Required.
        :type location: str
        :return: GroupQuotaLimitList. The GroupQuotaLimitList is compatible with MutableMapping
        :rtype: ~azure.mgmt.quota.models.GroupQuotaLimitList
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.GroupQuotaLimitList] = kwargs.pop("cls", None)

        _request = build_group_quota_limits_list_request(
            management_group_id=management_group_id,
            group_quota_name=group_quota_name,
            resource_provider_name=resource_provider_name,
            location=location,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.GroupQuotaLimitList, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class GroupQuotaSubscriptionAllocationOperations:  # pylint: disable=name-too-long
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.quota.QuotaMgmtClient`'s
        :attr:`group_quota_subscription_allocation` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: QuotaMgmtClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self, management_group_id: str, group_quota_name: str, resource_provider_name: str, location: str, **kwargs: Any
    ) -> _models.SubscriptionQuotaAllocationsList:
        """Gets all the quota allocated to a subscription for the specified resource provider and location
        for resource names passed in $filter=resourceName eq {SKU}. This will include the GroupQuota
        and total quota allocated to the subscription. Only the Group quota allocated to the
        subscription can be allocated back to the MG Group Quota.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param location: The name of the Azure region. Required.
        :type location: str
        :return: SubscriptionQuotaAllocationsList. The SubscriptionQuotaAllocationsList is compatible
         with MutableMapping
        :rtype: ~azure.mgmt.quota.models.SubscriptionQuotaAllocationsList
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.SubscriptionQuotaAllocationsList] = kwargs.pop("cls", None)

        _request = build_group_quota_subscription_allocation_list_request(
            management_group_id=management_group_id,
            group_quota_name=group_quota_name,
            resource_provider_name=resource_provider_name,
            location=location,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.SubscriptionQuotaAllocationsList, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class GroupQuotaSubscriptionAllocationRequestOperations:  # pylint: disable=name-too-long
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.quota.QuotaMgmtClient`'s
        :attr:`group_quota_subscription_allocation_request` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: QuotaMgmtClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    def _update_initial(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        location: str,
        allocate_quota_request: Union[_models.SubscriptionQuotaAllocationsList, JSON, IO[bytes]],
        **kwargs: Any
    ) -> Iterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Iterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(allocate_quota_request, (IOBase, bytes)):
            _content = allocate_quota_request
        else:
            _content = json.dumps(allocate_quota_request, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_group_quota_subscription_allocation_request_update_request(
            management_group_id=management_group_id,
            group_quota_name=group_quota_name,
            resource_provider_name=resource_provider_name,
            location=location,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    def begin_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        location: str,
        allocate_quota_request: _models.SubscriptionQuotaAllocationsList,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.SubscriptionQuotaAllocationsList]:
        """Request to assign quota from group quota to a specific Subscription. The assign GroupQuota to
        subscriptions or reduce the quota allocated to subscription to give back the unused quota (
        quota >= usages) to the groupQuota. So, this API can be used to assign Quota to subscriptions
        and assign back unused quota to group quota, which can be assigned to another subscriptions in
        the GroupQuota. User can collect unused quotas from multiple subscriptions within the
        groupQuota and assign the groupQuota to the subscription, where it's needed.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param location: The name of the Azure region. Required.
        :type location: str
        :param allocate_quota_request: Quota requests payload. Required.
        :type allocate_quota_request: ~azure.mgmt.quota.models.SubscriptionQuotaAllocationsList
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns SubscriptionQuotaAllocationsList. The
         SubscriptionQuotaAllocationsList is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.SubscriptionQuotaAllocationsList]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        location: str,
        allocate_quota_request: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.SubscriptionQuotaAllocationsList]:
        """Request to assign quota from group quota to a specific Subscription. The assign GroupQuota to
        subscriptions or reduce the quota allocated to subscription to give back the unused quota (
        quota >= usages) to the groupQuota. So, this API can be used to assign Quota to subscriptions
        and assign back unused quota to group quota, which can be assigned to another subscriptions in
        the GroupQuota. User can collect unused quotas from multiple subscriptions within the
        groupQuota and assign the groupQuota to the subscription, where it's needed.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param location: The name of the Azure region. Required.
        :type location: str
        :param allocate_quota_request: Quota requests payload. Required.
        :type allocate_quota_request: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns SubscriptionQuotaAllocationsList. The
         SubscriptionQuotaAllocationsList is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.SubscriptionQuotaAllocationsList]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        location: str,
        allocate_quota_request: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.SubscriptionQuotaAllocationsList]:
        """Request to assign quota from group quota to a specific Subscription. The assign GroupQuota to
        subscriptions or reduce the quota allocated to subscription to give back the unused quota (
        quota >= usages) to the groupQuota. So, this API can be used to assign Quota to subscriptions
        and assign back unused quota to group quota, which can be assigned to another subscriptions in
        the GroupQuota. User can collect unused quotas from multiple subscriptions within the
        groupQuota and assign the groupQuota to the subscription, where it's needed.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param location: The name of the Azure region. Required.
        :type location: str
        :param allocate_quota_request: Quota requests payload. Required.
        :type allocate_quota_request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns SubscriptionQuotaAllocationsList. The
         SubscriptionQuotaAllocationsList is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.SubscriptionQuotaAllocationsList]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        location: str,
        allocate_quota_request: Union[_models.SubscriptionQuotaAllocationsList, JSON, IO[bytes]],
        **kwargs: Any
    ) -> LROPoller[_models.SubscriptionQuotaAllocationsList]:
        """Request to assign quota from group quota to a specific Subscription. The assign GroupQuota to
        subscriptions or reduce the quota allocated to subscription to give back the unused quota (
        quota >= usages) to the groupQuota. So, this API can be used to assign Quota to subscriptions
        and assign back unused quota to group quota, which can be assigned to another subscriptions in
        the GroupQuota. User can collect unused quotas from multiple subscriptions within the
        groupQuota and assign the groupQuota to the subscription, where it's needed.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param location: The name of the Azure region. Required.
        :type location: str
        :param allocate_quota_request: Quota requests payload. Is one of the following types:
         SubscriptionQuotaAllocationsList, JSON, IO[bytes] Required.
        :type allocate_quota_request: ~azure.mgmt.quota.models.SubscriptionQuotaAllocationsList or JSON
         or IO[bytes]
        :return: An instance of LROPoller that returns SubscriptionQuotaAllocationsList. The
         SubscriptionQuotaAllocationsList is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.SubscriptionQuotaAllocationsList]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SubscriptionQuotaAllocationsList] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._update_initial(
                management_group_id=management_group_id,
                group_quota_name=group_quota_name,
                resource_provider_name=resource_provider_name,
                location=location,
                allocate_quota_request=allocate_quota_request,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = _deserialize(_models.SubscriptionQuotaAllocationsList, response.json())
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, ARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[_models.SubscriptionQuotaAllocationsList].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[_models.SubscriptionQuotaAllocationsList](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def get(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        allocation_id: str,
        **kwargs: Any
    ) -> _models.QuotaAllocationRequestStatus:
        """Get the quota allocation request status for the subscriptionId by allocationId.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param allocation_id: Request Id. Required.
        :type allocation_id: str
        :return: QuotaAllocationRequestStatus. The QuotaAllocationRequestStatus is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.quota.models.QuotaAllocationRequestStatus
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.QuotaAllocationRequestStatus] = kwargs.pop("cls", None)

        _request = build_group_quota_subscription_allocation_request_get_request(
            management_group_id=management_group_id,
            group_quota_name=group_quota_name,
            resource_provider_name=resource_provider_name,
            allocation_id=allocation_id,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.QuotaAllocationRequestStatus, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        *,
        filter: str,
        **kwargs: Any
    ) -> ItemPaged["_models.QuotaAllocationRequestStatus"]:
        """Get all the quotaAllocationRequests for a resourceProvider/location. The filter paramter for
        location is required.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :keyword filter: | Field | Supported operators
         |---------------------|------------------------

         location eq {location}
         Example: $filter=location eq eastus. Required.
        :paramtype filter: str
        :return: An iterator like instance of QuotaAllocationRequestStatus
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.quota.models.QuotaAllocationRequestStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.QuotaAllocationRequestStatus]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_group_quota_subscription_allocation_request_list_request(
                    management_group_id=management_group_id,
                    group_quota_name=group_quota_name,
                    resource_provider_name=resource_provider_name,
                    subscription_id=self._config.subscription_id,
                    filter=filter,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.QuotaAllocationRequestStatus], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ErrorResponse, response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)


class GroupQuotaLocationSettingsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.quota.QuotaMgmtClient`'s
        :attr:`group_quota_location_settings` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: QuotaMgmtClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def get(
        self, management_group_id: str, group_quota_name: str, resource_provider_name: str, location: str, **kwargs: Any
    ) -> _models.GroupQuotasEnforcementStatus:
        """Gets the GroupQuotas enforcement settings for the ResourceProvider/location. The locations,
        where GroupQuota enforcement is not enabled will return Not Found.

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param location: The name of the Azure region. Required.
        :type location: str
        :return: GroupQuotasEnforcementStatus. The GroupQuotasEnforcementStatus is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.quota.models.GroupQuotasEnforcementStatus
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.GroupQuotasEnforcementStatus] = kwargs.pop("cls", None)

        _request = build_group_quota_location_settings_get_request(
            management_group_id=management_group_id,
            group_quota_name=group_quota_name,
            resource_provider_name=resource_provider_name,
            location=location,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.GroupQuotasEnforcementStatus, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    def _create_or_update_initial(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        location: str,
        location_settings: Optional[Union[_models.GroupQuotasEnforcementStatus, JSON, IO[bytes]]] = None,
        **kwargs: Any
    ) -> Iterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if location_settings else None
        cls: ClsType[Iterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json" if location_settings else None
        _content = None
        if isinstance(location_settings, (IOBase, bytes)):
            _content = location_settings
        else:
            if location_settings is not None:
                _content = json.dumps(location_settings, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_group_quota_location_settings_create_or_update_request(
            management_group_id=management_group_id,
            group_quota_name=group_quota_name,
            resource_provider_name=resource_provider_name,
            location=location,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            try:
                response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 201:
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    def begin_create_or_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        location: str,
        location_settings: Optional[_models.GroupQuotasEnforcementStatus] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotasEnforcementStatus]:
        """Enables the GroupQuotas enforcement for the resource provider and the location specified. The
        resource provider will start using the group quotas as the overall quota for the subscriptions
        included in the GroupQuota. The subscriptions cannot request quota at subscription level since
        it is now part of an enforced group.
        The subscriptions share the GroupQuotaLimits assigned to the GroupQuota. If the
        GroupQuotaLimits is used, then submit a groupQuotaLimit request for the specific resource -
        provider/location/resource.
        Once the GroupQuota Enforcement is enabled then, it cannot be deleted or reverted back. To
        disable GroupQuota Enforcement -

        1. Remove all the subscriptions from the groupQuota using the delete API for Subscriptions
        (Check the example - GroupQuotaSubscriptions_Delete).
        2. Then delete the GroupQuota (Check the example - GroupQuotas_Delete).

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param location: The name of the Azure region. Required.
        :type location: str
        :param location_settings: The GroupQuota body details for creation or update of a GroupQuota
         entity. Default value is None.
        :type location_settings: ~azure.mgmt.quota.models.GroupQuotasEnforcementStatus
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns GroupQuotasEnforcementStatus. The
         GroupQuotasEnforcementStatus is compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotasEnforcementStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_create_or_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        location: str,
        location_settings: Optional[JSON] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotasEnforcementStatus]:
        """Enables the GroupQuotas enforcement for the resource provider and the location specified. The
        resource provider will start using the group quotas as the overall quota for the subscriptions
        included in the GroupQuota. The subscriptions cannot request quota at subscription level since
        it is now part of an enforced group.
        The subscriptions share the GroupQuotaLimits assigned to the GroupQuota. If the
        GroupQuotaLimits is used, then submit a groupQuotaLimit request for the specific resource -
        provider/location/resource.
        Once the GroupQuota Enforcement is enabled then, it cannot be deleted or reverted back. To
        disable GroupQuota Enforcement -

        1. Remove all the subscriptions from the groupQuota using the delete API for Subscriptions
        (Check the example - GroupQuotaSubscriptions_Delete).
        2. Then delete the GroupQuota (Check the example - GroupQuotas_Delete).

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param location: The name of the Azure region. Required.
        :type location: str
        :param location_settings: The GroupQuota body details for creation or update of a GroupQuota
         entity. Default value is None.
        :type location_settings: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns GroupQuotasEnforcementStatus. The
         GroupQuotasEnforcementStatus is compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotasEnforcementStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_create_or_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        location: str,
        location_settings: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotasEnforcementStatus]:
        """Enables the GroupQuotas enforcement for the resource provider and the location specified. The
        resource provider will start using the group quotas as the overall quota for the subscriptions
        included in the GroupQuota. The subscriptions cannot request quota at subscription level since
        it is now part of an enforced group.
        The subscriptions share the GroupQuotaLimits assigned to the GroupQuota. If the
        GroupQuotaLimits is used, then submit a groupQuotaLimit request for the specific resource -
        provider/location/resource.
        Once the GroupQuota Enforcement is enabled then, it cannot be deleted or reverted back. To
        disable GroupQuota Enforcement -

        1. Remove all the subscriptions from the groupQuota using the delete API for Subscriptions
        (Check the example - GroupQuotaSubscriptions_Delete).
        2. Then delete the GroupQuota (Check the example - GroupQuotas_Delete).

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param location: The name of the Azure region. Required.
        :type location: str
        :param location_settings: The GroupQuota body details for creation or update of a GroupQuota
         entity. Default value is None.
        :type location_settings: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns GroupQuotasEnforcementStatus. The
         GroupQuotasEnforcementStatus is compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotasEnforcementStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_create_or_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        location: str,
        location_settings: Optional[Union[_models.GroupQuotasEnforcementStatus, JSON, IO[bytes]]] = None,
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotasEnforcementStatus]:
        """Enables the GroupQuotas enforcement for the resource provider and the location specified. The
        resource provider will start using the group quotas as the overall quota for the subscriptions
        included in the GroupQuota. The subscriptions cannot request quota at subscription level since
        it is now part of an enforced group.
        The subscriptions share the GroupQuotaLimits assigned to the GroupQuota. If the
        GroupQuotaLimits is used, then submit a groupQuotaLimit request for the specific resource -
        provider/location/resource.
        Once the GroupQuota Enforcement is enabled then, it cannot be deleted or reverted back. To
        disable GroupQuota Enforcement -

        1. Remove all the subscriptions from the groupQuota using the delete API for Subscriptions
        (Check the example - GroupQuotaSubscriptions_Delete).
        2. Then delete the GroupQuota (Check the example - GroupQuotas_Delete).

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param location: The name of the Azure region. Required.
        :type location: str
        :param location_settings: The GroupQuota body details for creation or update of a GroupQuota
         entity. Is one of the following types: GroupQuotasEnforcementStatus, JSON, IO[bytes] Default
         value is None.
        :type location_settings: ~azure.mgmt.quota.models.GroupQuotasEnforcementStatus or JSON or
         IO[bytes]
        :return: An instance of LROPoller that returns GroupQuotasEnforcementStatus. The
         GroupQuotasEnforcementStatus is compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotasEnforcementStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if location_settings else None
        cls: ClsType[_models.GroupQuotasEnforcementStatus] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._create_or_update_initial(
                management_group_id=management_group_id,
                group_quota_name=group_quota_name,
                resource_provider_name=resource_provider_name,
                location=location,
                location_settings=location_settings,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = _deserialize(_models.GroupQuotasEnforcementStatus, response.json())
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, ARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[_models.GroupQuotasEnforcementStatus].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[_models.GroupQuotasEnforcementStatus](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    def _update_initial(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        location: str,
        location_settings: Optional[Union[_models.GroupQuotasEnforcementStatus, JSON, IO[bytes]]] = None,
        **kwargs: Any
    ) -> Iterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if location_settings else None
        cls: ClsType[Iterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json" if location_settings else None
        _content = None
        if isinstance(location_settings, (IOBase, bytes)):
            _content = location_settings
        else:
            if location_settings is not None:
                _content = json.dumps(location_settings, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_group_quota_location_settings_update_request(
            management_group_id=management_group_id,
            group_quota_name=group_quota_name,
            resource_provider_name=resource_provider_name,
            location=location,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    def begin_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        location: str,
        location_settings: Optional[_models.GroupQuotasEnforcementStatus] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotasEnforcementStatus]:
        """Enables the GroupQuotas enforcement for the resource provider and the location specified. The
        resource provider will start using the group quotas as the overall quota for the subscriptions
        included in the GroupQuota.  The subscriptions cannot request quota at subscription level since
        it is now part of an enforced group.
        The subscriptions share the GroupQuotaLimits assigned to the GroupQuota. If the
        GroupQuotaLimits is used, then submit a groupQuotaLimit request for the specific resource -
        provider/location/resource.
        Once the GroupQuota Enforcement is enabled then, it cannot be deleted or reverted back. To
        disable GroupQuota Enforcement -

        1. Remove all the subscriptions from the groupQuota using the delete API for Subscriptions
        (Check the example - GroupQuotaSubscriptions_Delete).
        2. Ten delete the GroupQuota (Check the example - GroupQuotas_Delete).

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param location: The name of the Azure region. Required.
        :type location: str
        :param location_settings: The GroupQuota body details for creation or update of a GroupQuota
         entity. Default value is None.
        :type location_settings: ~azure.mgmt.quota.models.GroupQuotasEnforcementStatus
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns GroupQuotasEnforcementStatus. The
         GroupQuotasEnforcementStatus is compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotasEnforcementStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        location: str,
        location_settings: Optional[JSON] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotasEnforcementStatus]:
        """Enables the GroupQuotas enforcement for the resource provider and the location specified. The
        resource provider will start using the group quotas as the overall quota for the subscriptions
        included in the GroupQuota.  The subscriptions cannot request quota at subscription level since
        it is now part of an enforced group.
        The subscriptions share the GroupQuotaLimits assigned to the GroupQuota. If the
        GroupQuotaLimits is used, then submit a groupQuotaLimit request for the specific resource -
        provider/location/resource.
        Once the GroupQuota Enforcement is enabled then, it cannot be deleted or reverted back. To
        disable GroupQuota Enforcement -

        1. Remove all the subscriptions from the groupQuota using the delete API for Subscriptions
        (Check the example - GroupQuotaSubscriptions_Delete).
        2. Ten delete the GroupQuota (Check the example - GroupQuotas_Delete).

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param location: The name of the Azure region. Required.
        :type location: str
        :param location_settings: The GroupQuota body details for creation or update of a GroupQuota
         entity. Default value is None.
        :type location_settings: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns GroupQuotasEnforcementStatus. The
         GroupQuotasEnforcementStatus is compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotasEnforcementStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        location: str,
        location_settings: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotasEnforcementStatus]:
        """Enables the GroupQuotas enforcement for the resource provider and the location specified. The
        resource provider will start using the group quotas as the overall quota for the subscriptions
        included in the GroupQuota.  The subscriptions cannot request quota at subscription level since
        it is now part of an enforced group.
        The subscriptions share the GroupQuotaLimits assigned to the GroupQuota. If the
        GroupQuotaLimits is used, then submit a groupQuotaLimit request for the specific resource -
        provider/location/resource.
        Once the GroupQuota Enforcement is enabled then, it cannot be deleted or reverted back. To
        disable GroupQuota Enforcement -

        1. Remove all the subscriptions from the groupQuota using the delete API for Subscriptions
        (Check the example - GroupQuotaSubscriptions_Delete).
        2. Ten delete the GroupQuota (Check the example - GroupQuotas_Delete).

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param location: The name of the Azure region. Required.
        :type location: str
        :param location_settings: The GroupQuota body details for creation or update of a GroupQuota
         entity. Default value is None.
        :type location_settings: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns GroupQuotasEnforcementStatus. The
         GroupQuotasEnforcementStatus is compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotasEnforcementStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        resource_provider_name: str,
        location: str,
        location_settings: Optional[Union[_models.GroupQuotasEnforcementStatus, JSON, IO[bytes]]] = None,
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotasEnforcementStatus]:
        """Enables the GroupQuotas enforcement for the resource provider and the location specified. The
        resource provider will start using the group quotas as the overall quota for the subscriptions
        included in the GroupQuota.  The subscriptions cannot request quota at subscription level since
        it is now part of an enforced group.
        The subscriptions share the GroupQuotaLimits assigned to the GroupQuota. If the
        GroupQuotaLimits is used, then submit a groupQuotaLimit request for the specific resource -
        provider/location/resource.
        Once the GroupQuota Enforcement is enabled then, it cannot be deleted or reverted back. To
        disable GroupQuota Enforcement -

        1. Remove all the subscriptions from the groupQuota using the delete API for Subscriptions
        (Check the example - GroupQuotaSubscriptions_Delete).
        2. Ten delete the GroupQuota (Check the example - GroupQuotas_Delete).

        :param management_group_id: The management group ID. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param resource_provider_name: The resource provider name, such as - Microsoft.Compute.
         Currently only Microsoft.Compute resource provider supports this API. Required.
        :type resource_provider_name: str
        :param location: The name of the Azure region. Required.
        :type location: str
        :param location_settings: The GroupQuota body details for creation or update of a GroupQuota
         entity. Is one of the following types: GroupQuotasEnforcementStatus, JSON, IO[bytes] Default
         value is None.
        :type location_settings: ~azure.mgmt.quota.models.GroupQuotasEnforcementStatus or JSON or
         IO[bytes]
        :return: An instance of LROPoller that returns GroupQuotasEnforcementStatus. The
         GroupQuotasEnforcementStatus is compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotasEnforcementStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if location_settings else None
        cls: ClsType[_models.GroupQuotasEnforcementStatus] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._update_initial(
                management_group_id=management_group_id,
                group_quota_name=group_quota_name,
                resource_provider_name=resource_provider_name,
                location=location,
                location_settings=location_settings,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = _deserialize(_models.GroupQuotasEnforcementStatus, response.json())
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, ARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[_models.GroupQuotasEnforcementStatus].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[_models.GroupQuotasEnforcementStatus](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )


class UsagesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.quota.QuotaMgmtClient`'s
        :attr:`usages` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: QuotaMgmtClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def get(self, resource_name: str, scope: str, **kwargs: Any) -> _models.CurrentUsagesBase:
        """Get the current usage of a resource.

        :param resource_name: Resource name for a given resource provider. For example:

         * SKU name for Microsoft.Compute
         * SKU or TotalLowPriorityCores for Microsoft.MachineLearningServices
          For Microsoft.Network PublicIPAddresses. Required.
        :type resource_name: str
        :param scope: The fully qualified Azure Resource manager identifier of the resource. Required.
        :type scope: str
        :return: CurrentUsagesBase. The CurrentUsagesBase is compatible with MutableMapping
        :rtype: ~azure.mgmt.quota.models.CurrentUsagesBase
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.CurrentUsagesBase] = kwargs.pop("cls", None)

        _request = build_usages_get_request(
            resource_name=resource_name,
            scope=scope,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ExceptionResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CurrentUsagesBase, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list(self, scope: str, **kwargs: Any) -> ItemPaged["_models.CurrentUsagesBase"]:
        """Get a list of current usage for all resources for the scope specified.

        :param scope: The fully qualified Azure Resource manager identifier of the resource. Required.
        :type scope: str
        :return: An iterator like instance of CurrentUsagesBase
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.quota.models.CurrentUsagesBase]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.CurrentUsagesBase]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_usages_list_request(
                    scope=scope,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.CurrentUsagesBase], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ExceptionResponse, response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)


class QuotaOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.quota.QuotaMgmtClient`'s
        :attr:`quota` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: QuotaMgmtClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def get(self, resource_name: str, scope: str, **kwargs: Any) -> _models.CurrentQuotaLimitBase:
        """Get the quota limit of a resource. The response can be used to determine the remaining quota to
        calculate a new quota limit that can be submitted with a PUT request.

        :param resource_name: Resource name for a given resource provider. For example:

         * SKU name for Microsoft.Compute
         * SKU or TotalLowPriorityCores for Microsoft.MachineLearningServices
          For Microsoft.Network PublicIPAddresses. Required.
        :type resource_name: str
        :param scope: The fully qualified Azure Resource manager identifier of the resource. Required.
        :type scope: str
        :return: CurrentQuotaLimitBase. The CurrentQuotaLimitBase is compatible with MutableMapping
        :rtype: ~azure.mgmt.quota.models.CurrentQuotaLimitBase
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.CurrentQuotaLimitBase] = kwargs.pop("cls", None)

        _request = build_quota_get_request(
            resource_name=resource_name,
            scope=scope,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ExceptionResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CurrentQuotaLimitBase, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    def _create_or_update_initial(
        self,
        resource_name: str,
        scope: str,
        create_quota_request: Union[_models.CurrentQuotaLimitBase, JSON, IO[bytes]],
        **kwargs: Any
    ) -> Iterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Iterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(create_quota_request, (IOBase, bytes)):
            _content = create_quota_request
        else:
            _content = json.dumps(create_quota_request, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_quota_create_or_update_request(
            resource_name=resource_name,
            scope=scope,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ExceptionResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    def begin_create_or_update(
        self,
        resource_name: str,
        scope: str,
        create_quota_request: _models.CurrentQuotaLimitBase,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.CurrentQuotaLimitBase]:
        """Create or update the quota limit for the specified resource with the requested value. To update
        the quota, follow these steps:

        1. Use the GET operation for quotas and usages to determine how much quota remains for the
        specific resource and to calculate the new quota limit. These steps are detailed in [this
        example](https://techcommunity.microsoft.com/t5/azure-governance-and-management/using-the-new-quota-rest-api/ba-p/2183670).
        2. Use this PUT operation to update the quota limit. Please check the URI in location header
        for the detailed status of the request.

        :param resource_name: Resource name for a given resource provider. For example:

         * SKU name for Microsoft.Compute
         * SKU or TotalLowPriorityCores for Microsoft.MachineLearningServices
          For Microsoft.Network PublicIPAddresses. Required.
        :type resource_name: str
        :param scope: The fully qualified Azure Resource manager identifier of the resource. Required.
        :type scope: str
        :param create_quota_request: Quota request payload. Required.
        :type create_quota_request: ~azure.mgmt.quota.models.CurrentQuotaLimitBase
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns CurrentQuotaLimitBase. The CurrentQuotaLimitBase
         is compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.CurrentQuotaLimitBase]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_create_or_update(
        self,
        resource_name: str,
        scope: str,
        create_quota_request: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.CurrentQuotaLimitBase]:
        """Create or update the quota limit for the specified resource with the requested value. To update
        the quota, follow these steps:

        1. Use the GET operation for quotas and usages to determine how much quota remains for the
        specific resource and to calculate the new quota limit. These steps are detailed in [this
        example](https://techcommunity.microsoft.com/t5/azure-governance-and-management/using-the-new-quota-rest-api/ba-p/2183670).
        2. Use this PUT operation to update the quota limit. Please check the URI in location header
        for the detailed status of the request.

        :param resource_name: Resource name for a given resource provider. For example:

         * SKU name for Microsoft.Compute
         * SKU or TotalLowPriorityCores for Microsoft.MachineLearningServices
          For Microsoft.Network PublicIPAddresses. Required.
        :type resource_name: str
        :param scope: The fully qualified Azure Resource manager identifier of the resource. Required.
        :type scope: str
        :param create_quota_request: Quota request payload. Required.
        :type create_quota_request: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns CurrentQuotaLimitBase. The CurrentQuotaLimitBase
         is compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.CurrentQuotaLimitBase]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_create_or_update(
        self,
        resource_name: str,
        scope: str,
        create_quota_request: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.CurrentQuotaLimitBase]:
        """Create or update the quota limit for the specified resource with the requested value. To update
        the quota, follow these steps:

        1. Use the GET operation for quotas and usages to determine how much quota remains for the
        specific resource and to calculate the new quota limit. These steps are detailed in [this
        example](https://techcommunity.microsoft.com/t5/azure-governance-and-management/using-the-new-quota-rest-api/ba-p/2183670).
        2. Use this PUT operation to update the quota limit. Please check the URI in location header
        for the detailed status of the request.

        :param resource_name: Resource name for a given resource provider. For example:

         * SKU name for Microsoft.Compute
         * SKU or TotalLowPriorityCores for Microsoft.MachineLearningServices
          For Microsoft.Network PublicIPAddresses. Required.
        :type resource_name: str
        :param scope: The fully qualified Azure Resource manager identifier of the resource. Required.
        :type scope: str
        :param create_quota_request: Quota request payload. Required.
        :type create_quota_request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns CurrentQuotaLimitBase. The CurrentQuotaLimitBase
         is compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.CurrentQuotaLimitBase]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_create_or_update(
        self,
        resource_name: str,
        scope: str,
        create_quota_request: Union[_models.CurrentQuotaLimitBase, JSON, IO[bytes]],
        **kwargs: Any
    ) -> LROPoller[_models.CurrentQuotaLimitBase]:
        """Create or update the quota limit for the specified resource with the requested value. To update
        the quota, follow these steps:

        1. Use the GET operation for quotas and usages to determine how much quota remains for the
        specific resource and to calculate the new quota limit. These steps are detailed in [this
        example](https://techcommunity.microsoft.com/t5/azure-governance-and-management/using-the-new-quota-rest-api/ba-p/2183670).
        2. Use this PUT operation to update the quota limit. Please check the URI in location header
        for the detailed status of the request.

        :param resource_name: Resource name for a given resource provider. For example:

         * SKU name for Microsoft.Compute
         * SKU or TotalLowPriorityCores for Microsoft.MachineLearningServices
          For Microsoft.Network PublicIPAddresses. Required.
        :type resource_name: str
        :param scope: The fully qualified Azure Resource manager identifier of the resource. Required.
        :type scope: str
        :param create_quota_request: Quota request payload. Is one of the following types:
         CurrentQuotaLimitBase, JSON, IO[bytes] Required.
        :type create_quota_request: ~azure.mgmt.quota.models.CurrentQuotaLimitBase or JSON or IO[bytes]
        :return: An instance of LROPoller that returns CurrentQuotaLimitBase. The CurrentQuotaLimitBase
         is compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.CurrentQuotaLimitBase]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CurrentQuotaLimitBase] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._create_or_update_initial(
                resource_name=resource_name,
                scope=scope,
                create_quota_request=create_quota_request,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = _deserialize(_models.CurrentQuotaLimitBase, response.json())
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, ARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[_models.CurrentQuotaLimitBase].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[_models.CurrentQuotaLimitBase](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    def _update_initial(
        self,
        resource_name: str,
        scope: str,
        create_quota_request: Union[_models.CurrentQuotaLimitBase, JSON, IO[bytes]],
        **kwargs: Any
    ) -> Iterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Iterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(create_quota_request, (IOBase, bytes)):
            _content = create_quota_request
        else:
            _content = json.dumps(create_quota_request, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_quota_update_request(
            resource_name=resource_name,
            scope=scope,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ExceptionResponse, response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    def begin_update(
        self,
        resource_name: str,
        scope: str,
        create_quota_request: _models.CurrentQuotaLimitBase,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.CurrentQuotaLimitBase]:
        """Update the quota limit for a specific resource to the specified value:

        1. Use the Usages-GET and Quota-GET operations to determine the remaining quota for the
        specific resource and to calculate the new quota limit. These steps are detailed in [this
        example](https://techcommunity.microsoft.com/t5/azure-governance-and-management/using-the-new-quota-rest-api/ba-p/2183670).
        2. Use this PUT operation to update the quota limit. Please check the URI in location header
        for the detailed status of the request.

        :param resource_name: Resource name for a given resource provider. For example:

         * SKU name for Microsoft.Compute
         * SKU or TotalLowPriorityCores for Microsoft.MachineLearningServices
          For Microsoft.Network PublicIPAddresses. Required.
        :type resource_name: str
        :param scope: The fully qualified Azure Resource manager identifier of the resource. Required.
        :type scope: str
        :param create_quota_request: Quota requests payload. Required.
        :type create_quota_request: ~azure.mgmt.quota.models.CurrentQuotaLimitBase
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns CurrentQuotaLimitBase. The CurrentQuotaLimitBase
         is compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.CurrentQuotaLimitBase]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_update(
        self,
        resource_name: str,
        scope: str,
        create_quota_request: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.CurrentQuotaLimitBase]:
        """Update the quota limit for a specific resource to the specified value:

        1. Use the Usages-GET and Quota-GET operations to determine the remaining quota for the
        specific resource and to calculate the new quota limit. These steps are detailed in [this
        example](https://techcommunity.microsoft.com/t5/azure-governance-and-management/using-the-new-quota-rest-api/ba-p/2183670).
        2. Use this PUT operation to update the quota limit. Please check the URI in location header
        for the detailed status of the request.

        :param resource_name: Resource name for a given resource provider. For example:

         * SKU name for Microsoft.Compute
         * SKU or TotalLowPriorityCores for Microsoft.MachineLearningServices
          For Microsoft.Network PublicIPAddresses. Required.
        :type resource_name: str
        :param scope: The fully qualified Azure Resource manager identifier of the resource. Required.
        :type scope: str
        :param create_quota_request: Quota requests payload. Required.
        :type create_quota_request: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns CurrentQuotaLimitBase. The CurrentQuotaLimitBase
         is compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.CurrentQuotaLimitBase]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_update(
        self,
        resource_name: str,
        scope: str,
        create_quota_request: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.CurrentQuotaLimitBase]:
        """Update the quota limit for a specific resource to the specified value:

        1. Use the Usages-GET and Quota-GET operations to determine the remaining quota for the
        specific resource and to calculate the new quota limit. These steps are detailed in [this
        example](https://techcommunity.microsoft.com/t5/azure-governance-and-management/using-the-new-quota-rest-api/ba-p/2183670).
        2. Use this PUT operation to update the quota limit. Please check the URI in location header
        for the detailed status of the request.

        :param resource_name: Resource name for a given resource provider. For example:

         * SKU name for Microsoft.Compute
         * SKU or TotalLowPriorityCores for Microsoft.MachineLearningServices
          For Microsoft.Network PublicIPAddresses. Required.
        :type resource_name: str
        :param scope: The fully qualified Azure Resource manager identifier of the resource. Required.
        :type scope: str
        :param create_quota_request: Quota requests payload. Required.
        :type create_quota_request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns CurrentQuotaLimitBase. The CurrentQuotaLimitBase
         is compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.CurrentQuotaLimitBase]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_update(
        self,
        resource_name: str,
        scope: str,
        create_quota_request: Union[_models.CurrentQuotaLimitBase, JSON, IO[bytes]],
        **kwargs: Any
    ) -> LROPoller[_models.CurrentQuotaLimitBase]:
        """Update the quota limit for a specific resource to the specified value:

        1. Use the Usages-GET and Quota-GET operations to determine the remaining quota for the
        specific resource and to calculate the new quota limit. These steps are detailed in [this
        example](https://techcommunity.microsoft.com/t5/azure-governance-and-management/using-the-new-quota-rest-api/ba-p/2183670).
        2. Use this PUT operation to update the quota limit. Please check the URI in location header
        for the detailed status of the request.

        :param resource_name: Resource name for a given resource provider. For example:

         * SKU name for Microsoft.Compute
         * SKU or TotalLowPriorityCores for Microsoft.MachineLearningServices
          For Microsoft.Network PublicIPAddresses. Required.
        :type resource_name: str
        :param scope: The fully qualified Azure Resource manager identifier of the resource. Required.
        :type scope: str
        :param create_quota_request: Quota requests payload. Is one of the following types:
         CurrentQuotaLimitBase, JSON, IO[bytes] Required.
        :type create_quota_request: ~azure.mgmt.quota.models.CurrentQuotaLimitBase or JSON or IO[bytes]
        :return: An instance of LROPoller that returns CurrentQuotaLimitBase. The CurrentQuotaLimitBase
         is compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.CurrentQuotaLimitBase]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CurrentQuotaLimitBase] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._update_initial(
                resource_name=resource_name,
                scope=scope,
                create_quota_request=create_quota_request,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = _deserialize(_models.CurrentQuotaLimitBase, response.json())
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, ARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[_models.CurrentQuotaLimitBase].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[_models.CurrentQuotaLimitBase](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list(self, scope: str, **kwargs: Any) -> ItemPaged["_models.CurrentQuotaLimitBase"]:
        """Get a list of current quota limits of all resources for the specified scope. The response from
        this GET operation can be leveraged to submit requests to update a quota.

        :param scope: The fully qualified Azure Resource manager identifier of the resource. Required.
        :type scope: str
        :return: An iterator like instance of CurrentQuotaLimitBase
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.quota.models.CurrentQuotaLimitBase]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.CurrentQuotaLimitBase]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_quota_list_request(
                    scope=scope,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.CurrentQuotaLimitBase], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ExceptionResponse, response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)
