/*
 * wxCHTDecoder
 * Copyright (C) 2004,2008 emuWorks
 * http://games.technoplaza.net/
 *
 * This file is part of wxCHTDecoder.
 *
 * wxCHTDecoder is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * wxCHTDecoder is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with wxCHTDecoder; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

// $Id: chtcode.cc,v 1.4 2008/12/15 03:57:04 jdratlif Exp $

#ifdef HAVE_CONFIG_H
    #include <config.h>
#endif
 
#include "datastructures/chtcode.hh"

using namespace wxCHTDecoder;

CHTCode::CHTCode(wxString &name, int address, int value, bool active) {
    this->name = 0;
    
    setName(name);
    setAddress(address);
    setValue(value);
    setActive(active);
}

CHTCode::CHTCode(const CHTCode &chtcode) {
    this->name = 0;
    
    setName(chtcode.getName());
    setAddress(chtcode.getAddress());
    setValue(chtcode.getValue());
    setActive(chtcode.isActive());
}

CHTCode::~CHTCode() {
    if (name) { 
        delete name;
    }
}

CHTCode CHTCode::parseCHTData(const char *data) {
    bool active = true;
    
    if (data[0] == 4) {
        active = false;
    }
    
    int address = 0;
    
    for (int pos = 4; pos > 1; pos--) {
        address <<= 8;
        address |= (data[pos] & 0xFF);
    }
    
    int value = (data[1] & 0xFF);
    wxString name;
    
    for (int pos = 8; pos < 26; pos++) {
        if (data[pos] == 0) {
            break;
        }
        
        name += data[pos];
    }

    return CHTCode(name, address, value, active);
}

wxString CHTCode::toString() {
    wxString string;
    
    string.Printf(wxT("%-18s %06X:%02X %-8s"), getName().c_str(), getAddress(), 
        getValue(), (isActive() ? wxT("active") : wxT("inactive")));
    
    return string;
}

