// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// TuneSslOptions tune ssl options
//
// swagger:model tune_ssl_options
type TuneSslOptions struct {

	// cachesize
	Cachesize *int64 `json:"cachesize,omitempty"`

	// capture buffer size
	CaptureBufferSize *int64 `json:"capture_buffer_size,omitempty"`

	// ctx cache size
	CtxCacheSize int64 `json:"ctx_cache_size,omitempty"`

	// default dh param
	DefaultDhParam int64 `json:"default_dh_param,omitempty"`

	// force private cache
	ForcePrivateCache bool `json:"force_private_cache,omitempty"`

	// keylog
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	Keylog string `json:"keylog,omitempty"`

	// lifetime
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	Lifetime *int64 `json:"lifetime,omitempty"`

	// maxrecord
	Maxrecord *int64 `json:"maxrecord,omitempty"`

	// ocsp update max delay
	OcspUpdateMaxDelay *int64 `json:"ocsp_update_max_delay,omitempty"`

	// ocsp update min delay
	OcspUpdateMinDelay *int64 `json:"ocsp_update_min_delay,omitempty"`
}

// Validate validates this tune ssl options
func (m *TuneSslOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateKeylog(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLifetime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var tuneSslOptionsTypeKeylogPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tuneSslOptionsTypeKeylogPropEnum = append(tuneSslOptionsTypeKeylogPropEnum, v)
	}
}

const (

	// TuneSslOptionsKeylogEnabled captures enum value "enabled"
	TuneSslOptionsKeylogEnabled string = "enabled"

	// TuneSslOptionsKeylogDisabled captures enum value "disabled"
	TuneSslOptionsKeylogDisabled string = "disabled"
)

// prop value enum
func (m *TuneSslOptions) validateKeylogEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tuneSslOptionsTypeKeylogPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *TuneSslOptions) validateKeylog(formats strfmt.Registry) error {
	if swag.IsZero(m.Keylog) { // not required
		return nil
	}

	// value enum
	if err := m.validateKeylogEnum("keylog", "body", m.Keylog); err != nil {
		return err
	}

	return nil
}

func (m *TuneSslOptions) validateLifetime(formats strfmt.Registry) error {
	if swag.IsZero(m.Lifetime) { // not required
		return nil
	}

	if err := validate.MinimumInt("lifetime", "body", *m.Lifetime, 0, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this tune ssl options based on context it is used
func (m *TuneSslOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *TuneSslOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TuneSslOptions) UnmarshalBinary(b []byte) error {
	var res TuneSslOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
