export default {
  branches: ["main"],
  plugins: [
    "@semantic-release/commit-analyzer",
    {
      "preset": "angular",
      "releaseRules": [
        {"type": "breaking", "release": "major"},
        {"type": "feat", "release": "minor"},
        {"type": "fix", "release": "patch"},
        {"type": "refactor", "release": "patch"},
        {"type": "chore", "release": "patch"},
        {"type": "docs", "release": "patch"},
        {"type": "style", "release": false},
        {"type": "test", "release": false},
        {"scope": "no-release", "release": false}
      ]
    },
    "@semantic-release/release-notes-generator",
    "@semantic-release/changelog",
    "@semantic-release/gitlab",
    ["@semantic-release/git", {
      assets: ["CHANGELOG.md"],
      message: "chore(release): ${nextRelease.version} [skip ci]\n\n${nextRelease.notes}"
    }]
  ]
};
