﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/apigateway/APIGatewayRequest.h>
#include <aws/apigateway/APIGateway_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace APIGateway {
namespace Model {

/**
 * <p>Request to delete an existing Authorizer resource.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/apigateway-2015-07-09/DeleteAuthorizerRequest">AWS
 * API Reference</a></p>
 */
class DeleteAuthorizerRequest : public APIGatewayRequest {
 public:
  AWS_APIGATEWAY_API DeleteAuthorizerRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteAuthorizer"; }

  AWS_APIGATEWAY_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The string identifier of the associated RestApi.</p>
   */
  inline const Aws::String& GetRestApiId() const { return m_restApiId; }
  inline bool RestApiIdHasBeenSet() const { return m_restApiIdHasBeenSet; }
  template <typename RestApiIdT = Aws::String>
  void SetRestApiId(RestApiIdT&& value) {
    m_restApiIdHasBeenSet = true;
    m_restApiId = std::forward<RestApiIdT>(value);
  }
  template <typename RestApiIdT = Aws::String>
  DeleteAuthorizerRequest& WithRestApiId(RestApiIdT&& value) {
    SetRestApiId(std::forward<RestApiIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the Authorizer resource.</p>
   */
  inline const Aws::String& GetAuthorizerId() const { return m_authorizerId; }
  inline bool AuthorizerIdHasBeenSet() const { return m_authorizerIdHasBeenSet; }
  template <typename AuthorizerIdT = Aws::String>
  void SetAuthorizerId(AuthorizerIdT&& value) {
    m_authorizerIdHasBeenSet = true;
    m_authorizerId = std::forward<AuthorizerIdT>(value);
  }
  template <typename AuthorizerIdT = Aws::String>
  DeleteAuthorizerRequest& WithAuthorizerId(AuthorizerIdT&& value) {
    SetAuthorizerId(std::forward<AuthorizerIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_restApiId;
  bool m_restApiIdHasBeenSet = false;

  Aws::String m_authorizerId;
  bool m_authorizerIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace APIGateway
}  // namespace Aws
