﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codeartifact/CodeArtifact_EXPORTS.h>
#include <aws/codeartifact/model/PackageFormat.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CodeArtifact {
namespace Model {
class GetPackageVersionReadmeResult {
 public:
  AWS_CODEARTIFACT_API GetPackageVersionReadmeResult() = default;
  AWS_CODEARTIFACT_API GetPackageVersionReadmeResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CODEARTIFACT_API GetPackageVersionReadmeResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> The format of the package with the requested readme file. </p>
   */
  inline PackageFormat GetFormat() const { return m_format; }
  inline void SetFormat(PackageFormat value) {
    m_formatHasBeenSet = true;
    m_format = value;
  }
  inline GetPackageVersionReadmeResult& WithFormat(PackageFormat value) {
    SetFormat(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The namespace of the package version with the requested readme file. The
   * package component that specifies its namespace depends on its type. For
   * example:</p> <ul> <li> <p> The namespace of a Maven package version is its
   * <code>groupId</code>. </p> </li> <li> <p> The namespace of an npm or Swift
   * package version is its <code>scope</code>. </p> </li> <li> <p>The namespace of a
   * generic package is its <code>namespace</code>.</p> </li> <li> <p> Python, NuGet,
   * Ruby, and Cargo package versions do not contain a corresponding component,
   * package versions of those formats do not have a namespace. </p> </li> </ul>
   */
  inline const Aws::String& GetNamespace() const { return m_namespace; }
  template <typename NamespaceT = Aws::String>
  void SetNamespace(NamespaceT&& value) {
    m_namespaceHasBeenSet = true;
    m_namespace = std::forward<NamespaceT>(value);
  }
  template <typename NamespaceT = Aws::String>
  GetPackageVersionReadmeResult& WithNamespace(NamespaceT&& value) {
    SetNamespace(std::forward<NamespaceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The name of the package that contains the returned readme file. </p>
   */
  inline const Aws::String& GetPackage() const { return m_package; }
  template <typename PackageT = Aws::String>
  void SetPackage(PackageT&& value) {
    m_packageHasBeenSet = true;
    m_package = std::forward<PackageT>(value);
  }
  template <typename PackageT = Aws::String>
  GetPackageVersionReadmeResult& WithPackage(PackageT&& value) {
    SetPackage(std::forward<PackageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The version of the package with the requested readme file. </p>
   */
  inline const Aws::String& GetVersion() const { return m_version; }
  template <typename VersionT = Aws::String>
  void SetVersion(VersionT&& value) {
    m_versionHasBeenSet = true;
    m_version = std::forward<VersionT>(value);
  }
  template <typename VersionT = Aws::String>
  GetPackageVersionReadmeResult& WithVersion(VersionT&& value) {
    SetVersion(std::forward<VersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The current revision associated with the package version. </p>
   */
  inline const Aws::String& GetVersionRevision() const { return m_versionRevision; }
  template <typename VersionRevisionT = Aws::String>
  void SetVersionRevision(VersionRevisionT&& value) {
    m_versionRevisionHasBeenSet = true;
    m_versionRevision = std::forward<VersionRevisionT>(value);
  }
  template <typename VersionRevisionT = Aws::String>
  GetPackageVersionReadmeResult& WithVersionRevision(VersionRevisionT&& value) {
    SetVersionRevision(std::forward<VersionRevisionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The text of the returned readme file. </p>
   */
  inline const Aws::String& GetReadme() const { return m_readme; }
  template <typename ReadmeT = Aws::String>
  void SetReadme(ReadmeT&& value) {
    m_readmeHasBeenSet = true;
    m_readme = std::forward<ReadmeT>(value);
  }
  template <typename ReadmeT = Aws::String>
  GetPackageVersionReadmeResult& WithReadme(ReadmeT&& value) {
    SetReadme(std::forward<ReadmeT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetPackageVersionReadmeResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  PackageFormat m_format{PackageFormat::NOT_SET};
  bool m_formatHasBeenSet = false;

  Aws::String m_namespace;
  bool m_namespaceHasBeenSet = false;

  Aws::String m_package;
  bool m_packageHasBeenSet = false;

  Aws::String m_version;
  bool m_versionHasBeenSet = false;

  Aws::String m_versionRevision;
  bool m_versionRevisionHasBeenSet = false;

  Aws::String m_readme;
  bool m_readmeHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CodeArtifact
}  // namespace Aws
