﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/compute-optimizer/model/MetricStatistic.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Utils;

namespace Aws {
namespace ComputeOptimizer {
namespace Model {
namespace MetricStatisticMapper {

static const int Maximum_HASH = HashingUtils::HashString("Maximum");
static const int Average_HASH = HashingUtils::HashString("Average");

MetricStatistic GetMetricStatisticForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == Maximum_HASH) {
    return MetricStatistic::Maximum;
  } else if (hashCode == Average_HASH) {
    return MetricStatistic::Average;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<MetricStatistic>(hashCode);
  }

  return MetricStatistic::NOT_SET;
}

Aws::String GetNameForMetricStatistic(MetricStatistic enumValue) {
  switch (enumValue) {
    case MetricStatistic::NOT_SET:
      return {};
    case MetricStatistic::Maximum:
      return "Maximum";
    case MetricStatistic::Average:
      return "Average";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace MetricStatisticMapper
}  // namespace Model
}  // namespace ComputeOptimizer
}  // namespace Aws
