// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// RingBase Ring Base
//
// # HAProxy ring configuration
//
// swagger:model ring_base
type RingBase struct {

	// description
	Description string `json:"description,omitempty"`

	// format
	// Enum: ["iso","local","raw","rfc3164","rfc5424","short","priority","timed"]
	// +kubebuilder:validation:Enum=iso;local;raw;rfc3164;rfc5424;short;priority;timed;
	Format string `json:"format,omitempty"`

	// maxlen
	Maxlen *int64 `json:"maxlen,omitempty"`

	// name
	// Required: true
	// Pattern: ^[A-Za-z0-9-_.:]+$
	// +kubebuilder:validation:Pattern=`^[A-Za-z0-9-_.:]+$`
	Name string `json:"name"`

	// size
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	Size *int64 `json:"size,omitempty"`

	// timeout connect
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	TimeoutConnect *int64 `json:"timeout_connect,omitempty"`

	// timeout server
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	TimeoutServer *int64 `json:"timeout_server,omitempty"`
}

// Validate validates this ring base
func (m *RingBase) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFormat(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimeoutConnect(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimeoutServer(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var ringBaseTypeFormatPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["iso","local","raw","rfc3164","rfc5424","short","priority","timed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ringBaseTypeFormatPropEnum = append(ringBaseTypeFormatPropEnum, v)
	}
}

const (

	// RingBaseFormatIso captures enum value "iso"
	RingBaseFormatIso string = "iso"

	// RingBaseFormatLocal captures enum value "local"
	RingBaseFormatLocal string = "local"

	// RingBaseFormatRaw captures enum value "raw"
	RingBaseFormatRaw string = "raw"

	// RingBaseFormatRfc3164 captures enum value "rfc3164"
	RingBaseFormatRfc3164 string = "rfc3164"

	// RingBaseFormatRfc5424 captures enum value "rfc5424"
	RingBaseFormatRfc5424 string = "rfc5424"

	// RingBaseFormatShort captures enum value "short"
	RingBaseFormatShort string = "short"

	// RingBaseFormatPriority captures enum value "priority"
	RingBaseFormatPriority string = "priority"

	// RingBaseFormatTimed captures enum value "timed"
	RingBaseFormatTimed string = "timed"
)

// prop value enum
func (m *RingBase) validateFormatEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ringBaseTypeFormatPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RingBase) validateFormat(formats strfmt.Registry) error {
	if swag.IsZero(m.Format) { // not required
		return nil
	}

	// value enum
	if err := m.validateFormatEnum("format", "body", m.Format); err != nil {
		return err
	}

	return nil
}

func (m *RingBase) validateName(formats strfmt.Registry) error {

	if err := validate.RequiredString("name", "body", m.Name); err != nil {
		return err
	}

	if err := validate.Pattern("name", "body", m.Name, `^[A-Za-z0-9-_.:]+$`); err != nil {
		return err
	}

	return nil
}

func (m *RingBase) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(m.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("size", "body", *m.Size, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *RingBase) validateTimeoutConnect(formats strfmt.Registry) error {
	if swag.IsZero(m.TimeoutConnect) { // not required
		return nil
	}

	if err := validate.MinimumInt("timeout_connect", "body", *m.TimeoutConnect, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *RingBase) validateTimeoutServer(formats strfmt.Registry) error {
	if swag.IsZero(m.TimeoutServer) { // not required
		return nil
	}

	if err := validate.MinimumInt("timeout_server", "body", *m.TimeoutServer, 0, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this ring base based on context it is used
func (m *RingBase) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *RingBase) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *RingBase) UnmarshalBinary(b []byte) error {
	var res RingBase
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
