// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// TuneZlibOptions tune zlib options
//
// swagger:model tune_zlib_options
type TuneZlibOptions struct {
	// memlevel
	// Maximum: 9
	// Minimum: 1
	// +kubebuilder:validation:Maximum=9
	// +kubebuilder:validation:Minimum=1
	Memlevel int64 `json:"memlevel,omitempty"`

	// windowsize
	// Maximum: 15
	// Minimum: 8
	// +kubebuilder:validation:Maximum=15
	// +kubebuilder:validation:Minimum=8
	Windowsize int64 `json:"windowsize,omitempty"`
}

// Validate validates this tune zlib options
func (m *TuneZlibOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMemlevel(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWindowsize(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TuneZlibOptions) validateMemlevel(formats strfmt.Registry) error {
	if swag.IsZero(m.Memlevel) { // not required
		return nil
	}

	if err := validate.MinimumInt("memlevel", "body", m.Memlevel, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("memlevel", "body", m.Memlevel, 9, false); err != nil {
		return err
	}

	return nil
}

func (m *TuneZlibOptions) validateWindowsize(formats strfmt.Registry) error {
	if swag.IsZero(m.Windowsize) { // not required
		return nil
	}

	if err := validate.MinimumInt("windowsize", "body", m.Windowsize, 8, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("windowsize", "body", m.Windowsize, 15, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this tune zlib options based on context it is used
func (m *TuneZlibOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *TuneZlibOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TuneZlibOptions) UnmarshalBinary(b []byte) error {
	var res TuneZlibOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
